/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.interactor;

import ilog.views.IlvGraphicUtil;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.interactor.IlvPermanentInteractorInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class IlvMagnifyInteractor
extends IlvManagerViewInteractor
implements IlvPermanentInteractorInterface {
    private static final String a = "factor should be greater or equal to 1 and smaller or equal to 4";
    private static final String b = "size should be strictly greater than zero";
    public static final short RECTANGULAR = 0;
    public static final short CIRCULAR = 1;
    public static final short LENS = 2;
    private int c = 128;
    private float d = 2.0f;
    private transient Image e = null;
    private transient Image f = null;
    private short g = 0;
    private transient ImageTransformer h = null;
    private final IlvRect i = new IlvRect(0.0f, 0.0f, 128.0f, 128.0f);
    private IlvRect j = null;
    private boolean k = false;
    private boolean l = false;
    private boolean m = true;

    public IlvMagnifyInteractor() {
        this.enableEvents(48L);
    }

    protected void attach(IlvManagerView ilvManagerView) {
        if (ilvManagerView != null) {
            this.e = this.g == 2 ? new BufferedImage((int)(this.d * (float)this.c), (int)(this.d * (float)this.c), 2) : new BufferedImage(this.c, this.c, 2);
        }
        super.attach(ilvManagerView);
    }

    protected void detach() {
        if (this.k && this.j != null) {
            this.k = false;
            this.getManagerView().invalidateRect(this.j);
            this.j = null;
            this.getManagerView().reDrawViews();
        }
        super.detach();
        this.e = null;
        this.f = null;
    }

    public final void setSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(b);
        }
        if (n2 != this.c) {
            int n3 = this.c;
            this.c = n2;
            this.i.width = this.c;
            this.i.height = this.c;
            if (this.g == 2) {
                this.h.setSize((int)(this.d * (float)this.c));
            } else if (this.g == 1) {
                this.h.setSize(this.c);
            }
            if (this.getManagerView() != null) {
                this.e = this.g == 2 ? new BufferedImage((int)(this.d * (float)this.c), (int)(this.d * (float)this.c), 2) : new BufferedImage(this.c, this.c, 2);
            }
            if (this.k) {
                if (this.j != null) {
                    this.getManagerView().invalidateRect(this.j);
                    this.j = null;
                }
                this.i.move(this.i.x + (float)((n3 - n2) / 2), this.i.y + (float)((n3 - n2) / 2));
                this.getManagerView().invalidateRect(this.i);
                this.getManagerView().reDrawViews();
            }
        }
    }

    public final int getSize() {
        return this.c;
    }

    public final void setMode(short s2) {
        if (s2 != this.g) {
            this.g = s2;
            if (this.g == 1) {
                this.h = new CircularTransformer();
                this.h.setSize(this.c);
            } else if (this.g == 2) {
                this.h = new LensTransformer();
                this.h.setSize((int)(this.d * (float)this.c));
            } else {
                this.h = null;
            }
            if (this.getManagerView() != null) {
                this.e = this.g == 2 ? new BufferedImage((int)(this.d * (float)this.c), (int)(this.d * (float)this.c), 2) : new BufferedImage(this.c, this.c, 2);
            }
            if (this.k && this.j != null) {
                this.getManagerView().invalidateRect(this.j);
                this.j = null;
                this.getManagerView().reDrawViews();
            }
        }
    }

    public final short getMode() {
        return this.g;
    }

    public final void setFactor(float f2) {
        block8: {
            block7: {
                if (f2 < 1.0f) break block7;
                if (!(f2 > 4.0f)) break block8;
            }
            throw new IllegalArgumentException(a);
        }
        if (f2 != this.d) {
            this.d = f2;
            if (this.g == 2) {
                this.h.setSize((int)(this.d * (float)this.c));
                if (this.getManagerView() != null) {
                    this.e = new BufferedImage((int)(this.d * (float)this.c), (int)(this.d * (float)this.c), 2);
                }
            }
            if (this.k && this.j != null) {
                this.getManagerView().invalidateRect(this.j);
                this.j = null;
                this.getManagerView().reDrawViews();
            }
        }
    }

    public final float getFactor() {
        return this.d;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.getID() == 501) {
            this.k = true;
            IlvPoint ilvPoint = new IlvPoint(mouseEvent.getX(), mouseEvent.getY());
            this.i.move(ilvPoint.x - this.i.width * 0.5f, ilvPoint.y - this.i.height * 0.5f);
            this.getManagerView().invalidateRect(this.getDrawingRect());
            this.getManagerView().reDrawViews();
        }
        if (mouseEvent.getID() == 502) {
            this.k = false;
            if (this.j != null) {
                this.getManagerView().invalidateRect(this.j);
            }
            this.j = null;
            this.getManagerView().reDrawViews();
            if (!this.l && this.getManagerView() != null) {
                this.getManagerView().popInteractor();
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        IlvManagerView ilvManagerView;
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.getID() == 506 && (ilvManagerView = this.getManagerView()) != null) {
            IlvTransformer ilvTransformer = this.getTransformer();
            IlvPoint ilvPoint = new IlvPoint(mouseEvent.getX(), mouseEvent.getY());
            this.i.move(ilvPoint.x - this.i.width * 0.5f, ilvPoint.y - this.i.height * 0.5f);
            IlvRect ilvRect = this.getDrawingRect();
            ilvTransformer.boundingBox(ilvRect, true);
            if (this.j != null) {
                ilvTransformer.boundingBox(this.j, true);
            }
            this.m = false;
            this.ensureVisible(ilvPoint);
            this.m = true;
            ilvTransformer = this.getTransformer();
            ilvTransformer.boundingBox(ilvRect, false);
            if (this.j != null) {
                ilvTransformer.boundingBox(this.j, false);
            }
            if (this.j != null) {
                ilvManagerView.invalidateRect(this.j);
            }
            ilvManagerView.invalidateRect(ilvRect);
            this.j = null;
            ilvManagerView.reDrawViews();
        }
    }

    protected void handleExpose(Graphics graphics) {
        if (this.k && this.m) {
            Rectangle rectangle = graphics.getClipBounds();
            Dimension dimension = this.getManagerView().getSize();
            Rectangle rectangle2 = new Rectangle(Math.max(0, (int)Math.floor(this.i.x)), Math.max(0, (int)Math.floor(this.i.y)), Math.min((int)Math.floor((float)dimension.width - this.i.x), (int)Math.floor(this.i.width)), Math.min((int)Math.floor((float)dimension.height - this.i.y), (int)Math.floor(this.i.height)));
            if (rectangle.contains(rectangle2)) {
                this.update();
                this.a(graphics);
            } else if (rectangle.intersects(rectangle2)) {
                this.getManagerView().invalidateRect(this.i);
                this.getManagerView().reDrawViews();
                if (this.f == null) {
                    this.update();
                }
                this.a(graphics);
            }
        }
    }

    protected void update() {
        switch (this.g) {
            case 0: {
                this.d();
                break;
            }
            case 1: {
                this.c();
                break;
            }
            case 2: {
                this.b();
            }
        }
    }

    protected IlvRect getDrawingRect() {
        return new IlvRect(this.i);
    }

    private void a(Graphics graphics) {
        if (this.j == null) {
            this.j = new IlvRect();
        }
        IlvRect ilvRect = this.getDrawingRect();
        this.j.reshape(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height);
        this.drawMagnifier(graphics);
    }

    protected void drawMagnifier(Graphics graphics) {
        int n2 = (int)Math.floor(this.i.x + this.i.width / 2.0f);
        int n3 = (int)Math.floor(this.i.y + this.i.height / 2.0f);
        int n4 = n2 - (int)Math.floor(this.i.width / 2.0f);
        int n5 = n3 - (int)Math.floor(this.i.height / 2.0f);
        int n6 = (int)Math.floor(this.i.width);
        int n7 = (int)Math.floor(this.i.height);
        graphics.drawImage(this.f, n4, n5, n6, n7, null);
    }

    private double a() {
        IlvTransformer ilvTransformer = this.getManagerView().getTransformer();
        IlvPoint ilvPoint = new IlvPoint(0.0f, 0.0f);
        IlvPoint ilvPoint2 = new IlvPoint(1000.0f, 0.0f);
        ilvTransformer.apply(ilvPoint);
        ilvTransformer.apply(ilvPoint2);
        return Math.toDegrees(Math.atan2(ilvPoint2.y - ilvPoint.y, ilvPoint2.x - ilvPoint.x));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b() {
        Graphics graphics = this.e.getGraphics();
        try {
            Color color = graphics.getColor();
            Color color2 = this.getManagerView().getBackground();
            if (color2 == null) {
                color2 = this.getManagerView().getParent().getBackground();
            }
            graphics.setColor(color2);
            graphics.fillRect(0, 0, (int)(this.d * (float)this.c), (int)(this.d * (float)this.c));
            graphics.setColor(color);
            IlvRect ilvRect = new IlvRect(this.i);
            this.getManagerView().getTransformer().boundingBox(ilvRect, true);
            IlvTransformer ilvTransformer = new IlvTransformer();
            IlvTransformer.computeTransformer(ilvRect, new IlvRect(0.0f, 0.0f, (int)(this.d * (float)this.c), (int)(this.d * (float)this.c)), ilvTransformer);
            double d2 = this.a();
            if (d2 != 0.0) {
                float f2 = this.d * (float)this.c / 2.0f;
                float f3 = this.d * (float)this.c / 2.0f;
                IlvPoint ilvPoint = new IlvPoint(f2, f3);
                IlvTransformer ilvTransformer2 = new IlvTransformer(ilvPoint, d2);
                ilvTransformer.compose(ilvTransformer2);
            }
            if (this.getManagerView().isAntialiasing()) {
                IlvGraphicUtil.StartAntiAliasing(graphics);
            }
            this.getManagerView().getManager().print(graphics, ilvRect, this.getManagerView(), ilvTransformer, false);
        }
        finally {
            graphics.dispose();
        }
        this.f = this.h.apply(this.e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(Graphics graphics) {
        Color color = this.getManagerView().getBackground();
        if (color == null) {
            color = this.getManagerView().getParent().getBackground();
        }
        graphics.setColor(color);
        graphics.fillRect(0, 0, this.c, this.c);
        double d2 = this.a();
        IlvRect ilvRect = new IlvRect(this.i);
        IlvTransformer ilvTransformer = this.getManagerView().getTransformer();
        if (d2 != 0.0) {
            ilvTransformer.rotate(this.i.getCenterX(), this.i.getCenterY(), -d2);
        }
        ilvTransformer.boundingBox(ilvRect, true);
        ilvRect.x += (1.0f - 1.0f / this.d) * ilvRect.width / 2.0f;
        ilvRect.y += (1.0f - 1.0f / this.d) * ilvRect.height / 2.0f;
        ilvRect.width /= this.d;
        ilvRect.height /= this.d;
        IlvTransformer ilvTransformer2 = new IlvTransformer();
        IlvTransformer.computeTransformer(ilvRect, new IlvRect(0.0f, 0.0f, this.i.width, this.i.height), ilvTransformer2);
        if (d2 != 0.0) {
            float f2 = this.i.width / 2.0f;
            float f3 = this.i.height / 2.0f;
            IlvPoint ilvPoint = new IlvPoint(f2, f3);
            IlvTransformer ilvTransformer3 = new IlvTransformer(ilvPoint, d2);
            ilvTransformer2.compose(ilvTransformer3);
        }
        Graphics graphics2 = graphics.create();
        try {
            if (this.getManagerView().isAntialiasing()) {
                IlvGraphicUtil.StartAntiAliasing(graphics2);
            }
            this.getManagerView().getManager().print(graphics2, ilvRect, this.getManagerView(), ilvTransformer2, false);
        }
        finally {
            graphics2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c() {
        Graphics graphics = this.e.getGraphics();
        try {
            this.b(graphics);
        }
        finally {
            graphics.dispose();
        }
        this.f = this.h.apply(this.e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d() {
        Graphics graphics = this.e.getGraphics();
        try {
            this.b(graphics);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, this.c - 1, this.c - 1);
        }
        finally {
            graphics.dispose();
        }
        this.f = this.e;
    }

    public final boolean isPermanent() {
        return this.l;
    }

    public final void setPermanent(boolean bl) {
        this.l = bl;
    }

    private static void b(Image image, int[] nArray, int n2, int n3) {
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n2, n3, nArray, 0, n2);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class LensTransformer
    implements ImageTransformer {
        private static final float a = 0.75f;
        private final Point b = new Point(-1, -1, null);
        private MemoryImageSource c;
        private Image d = null;
        private int[] e;
        private int[] f;
        private Point[] g;
        private int h;

        private LensTransformer() {
        }

        public void setSize(int n2) {
            int n3;
            int n4;
            if (this.h == n2) {
                return;
            }
            this.h = n2;
            int n5 = (int)((float)this.h / IlvMagnifyInteractor.this.d);
            this.e = new int[n5 * n5];
            this.f = new int[n2 * n2];
            this.c = new MemoryImageSource(n5, n5, this.e, 0, n5);
            this.c.setAnimated(true);
            this.d = Toolkit.getDefaultToolkit().createImage(this.c);
            this.g = new Point[n5 * n5];
            float f2 = (float)this.h * 0.5f;
            float f3 = f2 * f2;
            float f4 = 0.75f / IlvMagnifyInteractor.this.d;
            float f5 = f4 * f4;
            float f6 = 2.0f * IlvMagnifyInteractor.this.d;
            for (n4 = 0; n4 < this.h; ++n4) {
                for (n3 = 0; n3 < this.h; ++n3) {
                    float f7 = (float)n3 - f2;
                    float f8 = (float)n4 - f2;
                    float f9 = (f7 * f7 + f8 * f8) / f3;
                    if (f9 > 1.0f) continue;
                    if (f9 > f5) {
                        double d2 = (Math.sqrt(f9) - (double)f4) / (double)(1.0f - f4);
                        d2 = 1.0 / (1.0 + (double)(IlvMagnifyInteractor.this.d - 1.0f) * d2);
                        f7 = (float)((double)f7 * d2);
                        f8 = (float)((double)f8 * d2);
                    }
                    int n6 = (int)(f7 + (float)((int)((float)this.h / f6))) + (int)(f8 + (float)((int)((float)this.h / f6))) * n5;
                    this.g[n6] = new Point(n3, n4, this.g[n6]);
                }
            }
            for (n4 = 0; n4 < n5; ++n4) {
                for (n3 = 0; n3 < n5; ++n3) {
                    if (this.g[n3 + n4 * n5] == null || n3 != 0 && n4 != 0 && n3 != n5 - 1 && n4 != n5 - 1 && this.g[n3 - 1 + n4 * n5] != null && this.g[n3 + 1 + n4 * n5] != null && this.g[n3 + (n4 - 1) * n5] != null && this.g[n3 + (n4 + 1) * n5] != null) continue;
                    this.g[n3 + n4 * n5] = this.b;
                }
            }
        }

        private int a(Point point) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (point != null) {
                int n6 = this.f[point.a + this.h * point.b];
                n2 += (n6 & 0xFF0000) >> 16;
                n3 += (n6 & 0xFF00) >> 8;
                n4 += n6 & 0xFF;
                point = point.c;
                ++n5;
            }
            return 0xFF000000 | n2 / n5 << 16 | n3 / n5 << 8 | n4 / n5;
        }

        public Image apply(Image image) {
            IlvMagnifyInteractor.b(image, this.f, this.h, this.h);
            int n2 = (int)((float)this.h / IlvMagnifyInteractor.this.d) * (int)((float)this.h / IlvMagnifyInteractor.this.d);
            Point point = null;
            for (int i2 = 0; i2 < n2; ++i2) {
                point = this.g[i2];
                if (point == null) {
                    this.e[i2] = 0;
                    continue;
                }
                if (point == this.b) {
                    this.e[i2] = -16777216;
                    continue;
                }
                this.e[i2] = this.a(point);
            }
            this.c.newPixels();
            return this.d;
        }
    }

    private static class CircularTransformer
    implements ImageTransformer {
        private MemoryImageSource a;
        private int[] b;
        private Image c = null;
        private byte[] d;
        private int e;
        private static final byte f = 0;
        private static final byte g = 1;
        private static final byte h = 2;

        private CircularTransformer() {
        }

        public void setSize(int n2) {
            int n3;
            int n4;
            if (this.e == n2) {
                return;
            }
            this.e = n2;
            this.b = new int[this.e * this.e];
            this.a = new MemoryImageSource(this.e, this.e, this.b, 0, this.e);
            this.a.setAnimated(true);
            this.c = Toolkit.getDefaultToolkit().createImage(this.a);
            this.d = new byte[this.e * this.e];
            float f2 = (float)this.e * 0.5f;
            float f3 = f2 * f2;
            int n5 = 0;
            for (n4 = 0; n4 < this.e; ++n4) {
                for (n3 = 0; n3 < this.e; ++n3) {
                    float f4 = (float)n3 - f2;
                    float f5 = (float)n4 - f2;
                    this.d[n5] = (f4 * f4 + f5 * f5) / f3 > 1.0f ? (byte)0 : 1;
                    ++n5;
                }
            }
            for (n4 = 0; n4 < this.e; ++n4) {
                for (n3 = 0; n3 < this.e; ++n3) {
                    if (this.d[n3 + n4 * this.e] == 0 || n3 != 0 && n4 != 0 && n3 != this.e - 1 && n4 != this.e - 1 && this.d[n3 - 1 + n4 * this.e] != 0 && this.d[n3 + 1 + n4 * this.e] != 0 && this.d[n3 + (n4 - 1) * this.e] != 0 && this.d[n3 + (n4 + 1) * this.e] != 0) continue;
                    this.d[n3 + n4 * this.e] = 2;
                }
            }
        }

        public Image apply(Image image) {
            IlvMagnifyInteractor.b(image, this.b, this.e, this.e);
            int n2 = this.e * this.e;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.d[i2] == 0) {
                    this.b[i2] = 0;
                    continue;
                }
                if (this.d[i2] != 2) continue;
                this.b[i2] = -16777216;
            }
            this.a.newPixels();
            return this.c;
        }
    }

    private static interface ImageTransformer {
        public void setSize(int var1);

        public Image apply(Image var1);
    }

    private static class Point {
        int a;
        int b;
        Point c;

        Point(int n2, int n3, Point point) {
            this.a = n2;
            this.b = n3;
            this.c = point;
        }
    }
}

