/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.graphic.IlvLine;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.internal.IlvUtility;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.io.IOException;

public class IlvArrowLine
extends IlvLine {
    private float a = 1.0f;
    static final IlvPoint[] b = new IlvPoint[3];
    static final IlvPoint c = new IlvPoint();
    static final Boolean d = new Boolean(true);

    public IlvArrowLine() {
        this(0.0f, 0.0f, 100.0f, 100.0f, 1.0f);
    }

    public IlvArrowLine(float f2, float f3, float f4, float f5, float f6) {
        super(f2, f3, f4, f5);
        this.a = f6;
    }

    public IlvArrowLine(IlvArrowLine ilvArrowLine) {
        super(ilvArrowLine);
        this.a = ilvArrowLine.a;
    }

    public IlvArrowLine(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setArrowPosition(ilvInputStream.readFloat("arrowPosition"));
    }

    public IlvGraphic copy() {
        return new IlvArrowLine(this);
    }

    public void setArrowPosition(float f2) {
        this.a = f2;
        this.a = Math.min(1.0f, this.a);
        this.a = Math.max(0.0f, this.a);
    }

    public float getArrowPosition() {
        return this.a;
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        float f2 = this.getArrowSize(this.a(ilvTransformer, false), ilvTransformer);
        if (f2 > 4.0f && this.a == 1.0f) {
            int n2 = this.getEndCap();
            IlvPoint ilvPoint = this.getTo();
            IlvPoint ilvPoint2 = this.getFrom();
            float f3 = ilvPoint.x;
            float f4 = ilvPoint.y;
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint);
                ilvTransformer.apply(ilvPoint2);
            }
            double d2 = ilvPoint.x - ilvPoint2.x;
            double d3 = ilvPoint.y - ilvPoint2.y;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            double d5 = n2 != 0 ? 2.0 * (double)f2 : 1.5 * (double)f2;
            double d6 = 0.0;
            double d7 = 0.0;
            if (d4 != 0.0) {
                d6 = -d5 * d3 / d4;
                d7 = d5 * d2 / d4;
            }
            ilvPoint.x += -((float)d7);
            ilvPoint.y += (float)d6;
            if (ilvTransformer != null) {
                ilvTransformer.inverse(ilvPoint);
            }
            this.setTo(ilvPoint);
            super.draw(graphics, ilvTransformer);
            ilvPoint.x = f3;
            ilvPoint.y = f4;
            this.setTo(ilvPoint);
        } else {
            super.draw(graphics, ilvTransformer);
        }
        graphics.setColor(this.getForeground());
        IlvPoint ilvPoint = this.getFrom();
        IlvPoint ilvPoint3 = this.getTo();
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint);
            ilvTransformer.apply(ilvPoint3);
        }
        IlvUtility.drawArrow(graphics, ilvPoint.x, ilvPoint.y, ilvPoint3.x, ilvPoint3.y, this.a, f2);
    }

    protected float getArrowSize(float f2, IlvTransformer ilvTransformer) {
        return IlvUtility.arrowSize(f2, ilvTransformer);
    }

    private static IlvRect a(IlvPoint[] ilvPointArray) {
        IlvRect ilvRect = new IlvRect();
        IlvUtil.BoundingBox(ilvRect, ilvPointArray, 3);
        return ilvRect;
    }

    private float a(IlvTransformer ilvTransformer, boolean bl) {
        float f2 = this.getLineWidth();
        if (f2 == 0.0f) {
            return 0.0f;
        }
        return IlvStrokeInfo.zoomedLineWidth(f2, this.getMaximumLineWidth(), ilvTransformer, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        float f2 = this.getArrowSize(this.a(ilvTransformer, true), ilvTransformer);
        IlvRect ilvRect = super.boundingBox(ilvTransformer);
        Boolean bl = d;
        synchronized (bl) {
            IlvPoint ilvPoint = this.getFrom();
            IlvPoint ilvPoint2 = this.getTo();
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint);
                ilvTransformer.apply(ilvPoint2);
            }
            IlvUtility.ComputeArrow(ilvPoint.x, ilvPoint.y, ilvPoint2.x, ilvPoint2.y, this.a, b, f2);
            ilvRect.add(IlvArrowLine.a(b));
        }
        return ilvRect;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("arrowPosition", this.getArrowPosition());
    }

    static {
        for (int i2 = 0; i2 < b.length; ++i2) {
            IlvArrowLine.b[i2] = new IlvPoint();
        }
    }
}

