/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class IlvRect
extends Rectangle2D.Float
implements Serializable {
    static final long serialVersionUID = -8670827708447265349L;

    public IlvRect() {
    }

    public IlvRect(float f2, float f3, float f4, float f5) {
        this.x = f2;
        this.y = f3;
        this.height = f5;
        this.width = f4;
    }

    public IlvRect(IlvRect ilvRect) {
        this.x = ilvRect.x;
        this.y = ilvRect.y;
        this.width = ilvRect.width;
        this.height = ilvRect.height;
    }

    public final void add(float f2, float f3) {
        if (f2 < this.x) {
            this.width += this.x - f2;
            this.x = f2;
        } else if (f2 > this.x + this.width) {
            this.width = f2 - this.x;
        }
        if (f3 < this.y) {
            this.height += this.y - f3;
            this.y = f3;
        } else if (f3 > this.y + this.height) {
            this.height = f3 - this.y;
        }
    }

    public final void add(IlvRect ilvRect) {
        double d2 = this.x;
        double d3 = ilvRect.x;
        double d4 = d2 < d3 ? d2 : d3;
        double d5 = d2 > d3 ? (d2 += (double)this.width) : (d3 += (double)ilvRect.width);
        d2 = this.y;
        d3 = ilvRect.y;
        double d6 = d2 < d3 ? d2 : d3;
        double d7 = d2 > d3 ? (d2 += (double)this.height) : (d3 += (double)ilvRect.height);
        this.x = (float)d4;
        this.y = (float)d6;
        this.width = (float)(d5 - d4);
        this.height = (float)(d7 - d6);
    }

    public final boolean inside(float f2, float f3) {
        float f4 = this.x;
        float f5 = this.y;
        return f2 >= f4 && f3 >= f5 && f2 <= f4 + this.width && f3 <= f5 + this.height;
    }

    public final void move(float f2, float f3) {
        this.x = f2;
        this.y = f3;
    }

    public final void translate(float f2, float f3) {
        this.x += f2;
        this.y += f3;
    }

    public final void resize(float f2, float f3) {
        this.width = f2;
        this.height = f3;
    }

    public final void reshape(float f2, float f3, float f4, float f5) {
        this.x = f2;
        this.y = f3;
        this.width = f4;
        this.height = f5;
    }

    public final void expand(float f2) {
        this.x -= f2;
        this.y -= f2;
        this.width = Math.max(this.width + 2.0f * f2, 0.0f);
        this.height = Math.max(this.height + 2.0f * f2, 0.0f);
    }

    public final void expand(float f2, float f3) {
        this.x -= f2;
        this.y -= f3;
        this.width = Math.max(this.width + 2.0f * f2, 0.0f);
        this.height = Math.max(this.height + 2.0f * f3, 0.0f);
    }

    public final boolean contains(IlvRect ilvRect) {
        float f2 = ilvRect.width;
        float f3 = ilvRect.height;
        if (this.width <= 0.0f || this.height <= 0.0f || f2 < 0.0f || f3 < 0.0f) {
            return false;
        }
        float f4 = ilvRect.x;
        float f5 = ilvRect.y;
        return f4 >= this.x && f5 >= this.y && f4 + f2 <= this.x + this.width && f5 + f3 <= this.y + this.height;
    }

    public final boolean intersects(IlvRect ilvRect) {
        if (this.width <= 0.0f || this.height <= 0.0f || ilvRect.width < 0.0f || ilvRect.height < 0.0f) {
            return false;
        }
        return this.x <= ilvRect.x + ilvRect.width && this.x + this.width >= ilvRect.x && this.y <= ilvRect.y + ilvRect.height && this.y + this.height >= ilvRect.y;
    }

    public final void intersection(IlvRect ilvRect) {
        float f2 = this.x + this.width;
        float f3 = this.y + this.height;
        float f4 = ilvRect.x + ilvRect.width;
        float f5 = ilvRect.y + ilvRect.height;
        if (ilvRect.x > this.x) {
            this.x = ilvRect.x;
            this.width = f2 > f4 ? ilvRect.width : f2 - this.x;
        } else if (f2 > f4) {
            this.width = f4 - this.x;
        }
        if (ilvRect.y > this.y) {
            this.y = ilvRect.y;
            this.height = f3 > f5 ? ilvRect.height : f3 - this.y;
        } else if (f3 > f5) {
            this.height = f5 - this.y;
        }
    }

    public final void floor() {
        float f2 = this.x > 0.0f ? (float)((int)this.x) : (float)Math.floor(this.x);
        float f3 = this.y > 0.0f ? (float)((int)this.y) : (float)Math.floor(this.y);
        float f4 = this.x + this.width;
        f4 = f4 > 0.0f ? (float)((int)f4) : (float)Math.floor(f4);
        float f5 = this.y + this.height;
        f5 = f5 > 0.0f ? (float)((int)f5) : (float)Math.floor(f5);
        this.x = f2;
        this.y = f3;
        this.width = f4 - f2;
        this.height = f5 - f3;
    }

    public final int xFloor() {
        return this.x > 0.0f ? (int)this.x : (int)Math.floor(this.x);
    }

    public final int yFloor() {
        return this.y > 0.0f ? (int)this.y : (int)Math.floor(this.y);
    }

    public final int widthFloor() {
        float f2 = this.x > 0.0f ? (float)((int)this.x) : (float)Math.floor(this.x);
        float f3 = this.x + this.width;
        f3 = f3 > 0.0f ? (float)((int)f3) : (float)Math.floor(f3);
        return (int)(f3 - f2);
    }

    public final int heightFloor() {
        float f2 = this.y > 0.0f ? (float)((int)this.y) : (float)Math.floor(this.y);
        float f3 = this.y + this.height;
        f3 = f3 > 0.0f ? (float)((int)f3) : (float)Math.floor(f3);
        return (int)(f3 - f2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeFloat(this.x);
        objectOutputStream.writeFloat(this.y);
        objectOutputStream.writeFloat(this.width);
        objectOutputStream.writeFloat(this.height);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        try {
            this.x = getField.get("x", 0.0f);
            this.y = getField.get("y", 0.0f);
            this.width = getField.get("width", 0.0f);
            this.height = getField.get("height", 0.0f);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.x = objectInputStream.readFloat();
            this.y = objectInputStream.readFloat();
            this.width = objectInputStream.readFloat();
            this.height = objectInputStream.readFloat();
        }
    }

    public String toString() {
        return String.valueOf(this.x) + " " + String.valueOf(this.y) + " " + String.valueOf(this.width) + " " + String.valueOf(this.height);
    }
}

