/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGrapherLinkProperty;
import ilog.views.IlvGrapherObjectProperty;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvObjectProperty;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.linkpolicy.IlvPolicyAwareLinkImage;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.io.IOException;
import java.io.Serializable;

public abstract class IlvLinkConnector
implements Serializable,
IlvPersistentObject {
    private IlvGraphic a;
    private boolean b = false;
    private static final String c = "__ilvLinkConnector";
    private static final String d = "__ilvFromLinkConnector";
    private static final String e = "__ilvToLinkConnector";

    public IlvLinkConnector() {
    }

    public IlvLinkConnector(IlvGraphic ilvGraphic) {
        this.attach(ilvGraphic, true);
    }

    public IlvLinkConnector(IlvLinkImage ilvLinkImage, boolean bl) {
        this.attach(ilvLinkImage, bl, true);
    }

    public IlvLinkConnector(IlvInputStream ilvInputStream) throws IlvReadFileException {
    }

    public void attach(IlvGraphic ilvGraphic, boolean bl) {
        if (ilvGraphic == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        if (ilvGraphic instanceof IlvLinkImage) {
            throw new IllegalArgumentException("attach(IlvGraphic, boolean) should be used only for nodes. Use attach(IlvLinkImage, boolean, boolean) for the link " + ilvGraphic);
        }
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached(ilvGraphic);
        if (ilvLinkConnector == this) {
            return;
        }
        if (this.b) {
            throw new IllegalArgumentException("Link connector " + this + " has been already attached to a link, for its end-node (" + this.a + ") which is different than the specified node (" + ilvGraphic + ")");
        }
        if (ilvLinkConnector != null) {
            ilvLinkConnector.detach(bl);
        }
        this.detach(bl);
        this.a = ilvGraphic;
        IlvLinkConnector.a(this.a, this, bl);
    }

    public void attach(IlvLinkImage ilvLinkImage, boolean bl, boolean bl2) {
        IlvGraphic ilvGraphic;
        if (ilvLinkImage == null) {
            throw new IllegalArgumentException("link cannot be null");
        }
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached(ilvLinkImage, bl);
        if (ilvLinkConnector == this) {
            return;
        }
        IlvGraphic ilvGraphic2 = ilvGraphic = bl ? ilvLinkImage.getVisibleFrom() : ilvLinkImage.getVisibleTo();
        if (this.a != null) {
            if (IlvLinkConnector.GetAttached(this.a) == this) {
                throw new IllegalArgumentException("Link connector " + this + " has been already attached to a node (" + this.a + ")");
            }
            if (this.a != ilvGraphic) {
                throw new IllegalArgumentException("Link connector " + this + " has been already attached to a link for its extremity " + this.a + " which is different than the end-node " + ilvGraphic + " of the specified link " + ilvLinkImage);
            }
        }
        if (ilvLinkConnector != null) {
            ilvLinkConnector.detach(ilvLinkImage, bl, bl2);
        }
        this.detach(ilvLinkImage, bl, bl2);
        this.a = ilvGraphic;
        IlvLinkConnector.a(ilvLinkImage, this, bl, bl2);
    }

    public void detach(boolean bl) {
        if (this.a == null) {
            return;
        }
        if (this.b) {
            IlvLinkImage ilvLinkImage;
            IlvGraphicBag ilvGraphicBag = this.a.getGraphicBag();
            if (!(ilvGraphicBag instanceof IlvGrapher)) {
                throw new RuntimeException("Link connector " + this + " has been attached to at least one link and its node is not contained" + " in an IlvGrapher. Use detach(IlvLinkImage,boolean,boolean) instead.");
            }
            IlvGrapher ilvGrapher = (IlvGrapher)ilvGraphicBag;
            IlvGraphicEnumeration ilvGraphicEnumeration = ilvGrapher.getLinksFrom(this.a);
            while (ilvGraphicEnumeration.hasMoreElements()) {
                ilvLinkImage = (IlvLinkImage)ilvGraphicEnumeration.nextElement();
                if (IlvLinkConnector.GetAttached(ilvLinkImage, true) != this) continue;
                this.detach(ilvLinkImage, true, bl);
            }
            ilvGraphicEnumeration = ilvGrapher.getLinksTo(this.a);
            while (ilvGraphicEnumeration.hasMoreElements()) {
                ilvLinkImage = (IlvLinkImage)ilvGraphicEnumeration.nextElement();
                if (IlvLinkConnector.GetAttached(ilvLinkImage, false) != this) continue;
                this.detach(ilvLinkImage, false, bl);
            }
            this.b = false;
        }
        IlvLinkConnector.a(this.a, null, bl);
        this.a = null;
    }

    public void detach(IlvLinkImage ilvLinkImage, boolean bl, boolean bl2) {
        if (this.a == null) {
            return;
        }
        IlvLinkConnector.a(ilvLinkImage, null, bl, bl2);
    }

    public static IlvLinkConnector GetAttached(IlvGraphic ilvGraphic) {
        IlvObjectProperty ilvObjectProperty = ilvGraphic.b();
        return ilvObjectProperty instanceof IlvGrapherObjectProperty ? ((IlvGrapherObjectProperty)ilvObjectProperty).a() : (IlvLinkConnector)ilvGraphic.getProperty(c);
    }

    public static IlvLinkConnector GetAttached(IlvLinkImage ilvLinkImage, boolean bl) {
        IlvObjectProperty ilvObjectProperty = ilvLinkImage.b();
        return ilvObjectProperty instanceof IlvGrapherLinkProperty ? ((IlvGrapherLinkProperty)ilvObjectProperty).e(bl) : (IlvLinkConnector)ilvLinkImage.getProperty(bl ? d : e);
    }

    private static void a(final IlvGraphic ilvGraphic, final IlvLinkConnector ilvLinkConnector, boolean bl) {
        final IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        if (ilvGraphicBag == null) {
            ilvGraphic.setProperty(c, ilvLinkConnector);
        } else {
            ilvGraphicBag.applyToObject(ilvGraphic, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic2, Object object) {
                    if (ilvGraphicBag instanceof IlvManager) {
                        IlvObjectProperty ilvObjectProperty = ilvGraphic.b();
                        if (ilvObjectProperty instanceof IlvGrapherObjectProperty) {
                            ((IlvGrapherObjectProperty)ilvObjectProperty).a(ilvLinkConnector);
                        } else {
                            ilvGraphic.setProperty(IlvLinkConnector.c, ilvLinkConnector);
                        }
                    } else {
                        ilvGraphic.setProperty(IlvLinkConnector.c, ilvLinkConnector);
                    }
                    IlvLinkConnector.b(ilvGraphic2);
                }
            }, null, bl);
        }
    }

    private static void b(IlvGraphic ilvGraphic) {
        IlvPolicyAwareLinkImage ilvPolicyAwareLinkImage;
        IlvLinkImage ilvLinkImage;
        if (!(ilvGraphic.getGraphicBag() instanceof IlvGrapher)) {
            return;
        }
        IlvGrapher ilvGrapher = (IlvGrapher)ilvGraphic.getGraphicBag();
        if (!ilvGrapher.isNode(ilvGraphic)) {
            return;
        }
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvGrapher.getLinksFrom(ilvGraphic);
        while (ilvGraphicEnumeration.hasMoreElements()) {
            ilvLinkImage = (IlvLinkImage)ilvGraphicEnumeration.nextElement();
            if (!(ilvLinkImage instanceof IlvPolicyAwareLinkImage) || (ilvPolicyAwareLinkImage = (IlvPolicyAwareLinkImage)ilvLinkImage).getLinkShapePolicy() == null) continue;
            ilvPolicyAwareLinkImage.getLinkShapePolicy().afterFromNodeMoved(ilvPolicyAwareLinkImage);
        }
        ilvGraphicEnumeration = ilvGrapher.getLinksTo(ilvGraphic);
        while (ilvGraphicEnumeration.hasMoreElements()) {
            ilvLinkImage = (IlvLinkImage)ilvGraphicEnumeration.nextElement();
            if (!(ilvLinkImage instanceof IlvPolicyAwareLinkImage) || (ilvPolicyAwareLinkImage = (IlvPolicyAwareLinkImage)ilvLinkImage).getLinkShapePolicy() == null) continue;
            ilvPolicyAwareLinkImage.getLinkShapePolicy().afterToNodeMoved(ilvPolicyAwareLinkImage);
        }
    }

    private static void a(final IlvLinkImage ilvLinkImage, final IlvLinkConnector ilvLinkConnector, final boolean bl, boolean bl2) {
        final IlvGraphicBag ilvGraphicBag = ilvLinkImage.getGraphicBag();
        if (ilvGraphicBag == null) {
            ilvLinkImage.setProperty(bl ? d : e, ilvLinkConnector);
        } else {
            ilvGraphicBag.applyToObject(ilvLinkImage, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    if (ilvGraphicBag instanceof IlvManager) {
                        IlvObjectProperty ilvObjectProperty = ilvLinkImage.b();
                        if (ilvObjectProperty instanceof IlvGrapherLinkProperty) {
                            ((IlvGrapherLinkProperty)ilvObjectProperty).a(ilvLinkConnector, bl);
                        } else {
                            ilvLinkImage.setProperty(bl ? IlvLinkConnector.d : IlvLinkConnector.e, ilvLinkConnector);
                        }
                    } else {
                        ilvLinkImage.setProperty(bl ? IlvLinkConnector.d : IlvLinkConnector.e, ilvLinkConnector);
                    }
                    IlvLinkConnector.b(ilvLinkImage, bl);
                }
            }, null, bl2);
        }
        if (ilvLinkConnector != null) {
            ilvLinkConnector.b = true;
        }
    }

    private static void b(IlvLinkImage ilvLinkImage, boolean bl) {
        IlvPolicyAwareLinkImage ilvPolicyAwareLinkImage;
        if (ilvLinkImage instanceof IlvPolicyAwareLinkImage && (ilvPolicyAwareLinkImage = (IlvPolicyAwareLinkImage)ilvLinkImage).getLinkShapePolicy() != null) {
            if (bl) {
                ilvPolicyAwareLinkImage.getLinkShapePolicy().afterFromNodeMoved(ilvPolicyAwareLinkImage);
            } else {
                ilvPolicyAwareLinkImage.getLinkShapePolicy().afterToNodeMoved(ilvPolicyAwareLinkImage);
            }
        }
    }

    static final void a(IlvGraphic ilvGraphic, IlvGrapherObjectProperty ilvGrapherObjectProperty, IlvGrapherObjectProperty ilvGrapherObjectProperty2) {
        if (ilvGrapherObjectProperty == ilvGrapherObjectProperty2) {
            return;
        }
        if (ilvGrapherObjectProperty != null) {
            IlvLinkConnector ilvLinkConnector = ilvGrapherObjectProperty.a();
            if (ilvLinkConnector != null) {
                ilvGrapherObjectProperty.a((IlvLinkConnector)null);
                if (ilvGrapherObjectProperty2 != null) {
                    ilvGrapherObjectProperty2.a(ilvGrapherObjectProperty.a());
                } else {
                    ilvGraphic.setProperty(c, ilvLinkConnector);
                }
            }
        } else if (ilvGrapherObjectProperty2 != null) {
            ilvGrapherObjectProperty2.a((IlvLinkConnector)ilvGraphic.getProperty(c));
            ilvGraphic.setProperty(c, null);
        }
    }

    static final void a(IlvLinkImage ilvLinkImage, IlvGrapherLinkProperty ilvGrapherLinkProperty, IlvGrapherLinkProperty ilvGrapherLinkProperty2) {
        if (ilvGrapherLinkProperty == ilvGrapherLinkProperty2) {
            return;
        }
        IlvLinkConnector.a(ilvLinkImage, ilvGrapherLinkProperty, ilvGrapherLinkProperty2, true);
        IlvLinkConnector.a(ilvLinkImage, ilvGrapherLinkProperty, ilvGrapherLinkProperty2, false);
    }

    private static void a(IlvLinkImage ilvLinkImage, IlvGrapherLinkProperty ilvGrapherLinkProperty, IlvGrapherLinkProperty ilvGrapherLinkProperty2, boolean bl) {
        String string = bl ? d : e;
        if (ilvGrapherLinkProperty != null) {
            IlvLinkConnector ilvLinkConnector = ilvGrapherLinkProperty.e(bl);
            if (ilvLinkConnector != null) {
                ilvGrapherLinkProperty.a(null, bl);
                if (ilvGrapherLinkProperty2 != null) {
                    ilvGrapherLinkProperty2.a(ilvGrapherLinkProperty.a(), bl);
                } else {
                    ilvLinkImage.setProperty(string, ilvLinkConnector);
                }
            }
        } else if (ilvGrapherLinkProperty2 != null) {
            ilvGrapherLinkProperty2.a((IlvLinkConnector)ilvLinkImage.getProperty(string), bl);
            ilvLinkImage.setProperty(string, null);
        }
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
    }

    public void write(IlvOutputStream ilvOutputStream, IlvLinkImage ilvLinkImage, boolean bl) throws IOException {
    }

    public void read(IlvInputStream ilvInputStream, IlvLinkImage ilvLinkImage, boolean bl) throws IlvReadFileException {
    }

    public boolean isPersistent() {
        return false;
    }

    public final IlvGraphic getNode() {
        return this.a;
    }

    public static IlvLinkConnector Get(IlvGraphic ilvGraphic) {
        return IlvLinkConnector.GetAttached(ilvGraphic);
    }

    public static IlvLinkConnector Get(IlvLinkImage ilvLinkImage, boolean bl) {
        return IlvLinkConnector.a(ilvLinkImage, null, bl);
    }

    static IlvLinkConnector a(IlvLinkImage ilvLinkImage, IlvGraphic ilvGraphic, boolean bl) {
        IlvLinkConnector ilvLinkConnector;
        IlvGraphic ilvGraphic2;
        IlvGraphic ilvGraphic3 = ilvGraphic2 = bl ? ilvLinkImage.getFrom() : ilvLinkImage.getTo();
        if (ilvGraphic2 == null) {
            return null;
        }
        if (ilvGraphic == null) {
            IlvGraphic ilvGraphic4 = ilvGraphic = bl ? ilvLinkImage.getVisibleFrom() : ilvLinkImage.getVisibleTo();
        }
        if (ilvGraphic2 == ilvGraphic && (ilvLinkConnector = IlvLinkConnector.GetAttached(ilvLinkImage, bl)) != null) {
            return ilvLinkConnector;
        }
        return IlvLinkConnector.GetAttached(ilvGraphic);
    }

    public abstract IlvPoint getConnectionPoint(IlvLinkImage var1, boolean var2, IlvTransformer var3);

    protected abstract boolean zoomable();

    public abstract IlvPoint getClosestConnectionPoint(IlvPoint var1, Object var2, Object var3, Object var4, boolean var5, IlvTransformer var6);

    public abstract void connectLink(IlvLinkImage var1, IlvPoint var2, boolean var3, IlvTransformer var4);

    public void disconnectLink(IlvLinkImage ilvLinkImage, boolean bl) {
    }

    public boolean allowsConnectionPointMove(IlvLinkImage ilvLinkImage, boolean bl) {
        return true;
    }

    public void linkRemoved(IlvLinkImage ilvLinkImage) {
    }

    protected void allLinksRemoved() {
    }

    public void drawGhost(Graphics graphics, IlvTransformer ilvTransformer, Object object, Object object2, Object object3, boolean bl) {
    }

    public abstract IlvRect getGhostBoundingBox(IlvTransformer var1);

    public boolean supportsDrawGhost() {
        return false;
    }
}

