/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Wrapper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ArrayDataResultSet;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.BinaryFloatAccessor;
import oracle.jdbc.driver.BlobAccessor;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.CancelLock;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.ClobAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateAccessor;
import oracle.jdbc.driver.GeneratedStatement;
import oracle.jdbc.driver.IntervaldsAccessor;
import oracle.jdbc.driver.IntervalymAccessor;
import oracle.jdbc.driver.LongAccessor;
import oracle.jdbc.driver.LongRawAccessor;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.NumberAccessor;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleReturnResultSet;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OracleStatementWrapper;
import oracle.jdbc.driver.OutRawAccessor;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.RawAccessor;
import oracle.jdbc.driver.ReadOnlyByteArray;
import oracle.jdbc.driver.RefTypeAccessor;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.ResultSetCache;
import oracle.jdbc.driver.ResultSetCacheEntry;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.T4CTTIoac;
import oracle.jdbc.driver.TimestampAccessor;
import oracle.jdbc.driver.TimestampltzAccessor;
import oracle.jdbc.driver.TimestamptzAccessor;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.driver.VarnumAccessor;
import oracle.jdbc.driver.Wrappable;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.sql.ARRAY;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

abstract class OracleStatement
extends GeneratedStatement
implements oracle.jdbc.internal.OracleStatement,
Wrappable<OracleStatementWrapper> {
    byte[] defineBytes;
    char[] defineChars;
    short[] defineIndicators;
    int[] returnParamMeta;
    static final int PLAIN_STMT = 0;
    static final int PREP_STMT = 1;
    static final int CALL_STMT = 2;
    static final int METADATALENGTH = 1;
    static final int VALID_ROWS_UNINIT = -999;
    static final byte EXECUTE_NONE = -1;
    static final byte EXECUTE_QUERY = 1;
    static final byte EXECUTE_UPDATE = 2;
    static final byte EXECUTE_NORMAL = 3;
    static final int DMLR_METADATA_PREFIX_SIZE = 3;
    static final int DMLR_METADATA_NUM_OF_RETURN_PARAMS = 0;
    static final int DMLR_METADATA_ROW_BIND_BYTES = 1;
    static final int DMLR_METADATA_ROW_BIND_CHARS = 2;
    static final int DMLR_METADATA_TYPE_OFFSET = 0;
    static final int DMLR_METADATA_IS_CHAR_TYPE_OFFSET = 1;
    static final int DMLR_METADATA_BIND_SIZE_OFFSET = 2;
    static final int DMLR_METADATA_FORM_OF_USE_OFFSET = 3;
    static final int DMLR_METADATA_PER_POSITION_SIZE = 4;
    static final String SYS_ODCIVARCHAR2LIST = "SYS.ODCIVARCHAR2LIST";
    static final OracleResultSet.ResultSetType DEFAULT_RESULT_SET_TYPE = OracleResultSet.ResultSetType.FORWARD_READ_ONLY;
    boolean closed;
    protected boolean isAllFetched;
    int cursorId;
    int refCursorRowNumber;
    ByteArray rowData = null;
    ByteArray bindData = null;
    boolean bindUseDBA = false;
    long[] bindDataOffsets = null;
    int[] bindDataLengths = null;
    long beyondBindData = 0L;
    int numberOfDefinePositions;
    int definesBatchSize;
    boolean described = false;
    boolean describedWithNames = false;
    boolean executeDoneForDefines = false;
    protected FetchMode fetchMode = FetchMode.OVERWRITE;
    int rowsProcessed;
    protected int validRows;
    protected int storedRowCount;
    protected int currentCapacity = -1;
    private int numberOfUserColumns = -1;
    boolean isStreaming;
    boolean isFetchStreams;
    OracleStatement children = null;
    OracleStatement parent = null;
    OracleStatement nextChild = null;
    OracleStatement next;
    OracleStatement prev;
    long c_state;
    int numberOfBindPositions;
    int bindDBAOffset;
    byte[] bindBytes;
    char[] bindChars;
    short[] bindIndicators;
    int bindByteOffset;
    int bindCharOffset;
    int bindIndicatorOffset;
    int bindByteSubRange;
    int bindCharSubRange;
    int bindIndicatorSubRange;
    Accessor[] outBindAccessors;
    InputStream[][] parameterStream;
    Object[][] userStream;
    int firstRowInBatch;
    boolean hasIbtBind = false;
    byte[] ibtBindBytes;
    char[] ibtBindChars;
    short[] ibtBindIndicators;
    int ibtBindByteOffset;
    int ibtBindCharOffset;
    int ibtBindIndicatorOffset;
    int ibtBindIndicatorSize;
    OracleInputStream nextStream;
    OracleResultSet currentResultSet;
    ArrayDeque<OracleStatement> implicitResultSetStatements = null;
    ArrayDeque<OracleResultSet> openImplicitResultSets = null;
    Iterator<OracleStatement> implicitResultSetIterator = null;
    boolean processEscapes;
    boolean convertNcharLiterals;
    int queryTimeout;
    int maxFieldSize;
    int maxRows;
    int batch;
    int numberOfExecutedElementsInBatch = -1;
    int currentRank;
    boolean bsendBatchInProgress = false;
    int[] batchRowsUpdatedArray;
    int rowPrefetch;
    int rowPrefetchInLastFetch = -1;
    int defaultRowPrefetch;
    boolean rowPrefetchChanged;
    int defaultLobPrefetchSize;
    OracleSql sqlObject;
    boolean needToParse;
    boolean needToPrepareDefineBuffer;
    boolean columnsDefinedByUser;
    boolean gotLastBatch;
    boolean clearParameters;
    OracleStatement.SqlKind sqlKind = OracleStatement.SqlKind.SELECT;
    byte sqlKindByte = 1;
    boolean serverCursor;
    boolean fixedString = false;
    boolean noMoreUpdateCounts = false;
    protected CancelLock cancelLock = new CancelLock();
    OracleStatementWrapper wrapper;
    byte executionType = (byte)-1;
    OracleResultSet.ResultSetType userRsetType;
    OracleResultSet.ResultSetType realRsetType;
    boolean isRowidPrepended = false;
    SQLWarning sqlWarning;
    int cacheState = 3;
    int creationState = 0;
    boolean isOpen = false;
    int statementType = 0;
    boolean columnSetNull = false;
    boolean isDmlReturning = false;
    boolean returnParamsFetched;
    int rowsDmlReturned;
    int numReturnParams;
    boolean isAutoGeneratedKey;
    AutoKeyInfo autoKeyInfo;
    TimeZone defaultTimeZone = null;
    String defaultTimeZoneName = null;
    Calendar defaultCalendar = null;
    Calendar gmtCalendar = null;
    long inScn = 0L;
    OraclePreparedStatement refreshStatement = null;
    protected ResultSetCacheEntry cachedQueryResult = null;
    protected QueryCacheState queryCacheState = QueryCacheState.UNKNOWN;
    ByteBuffer[] nioBuffers = null;
    Object[] lobPrefetchMetaData = null;
    boolean hasStream;
    byte[] tmpByteArray;
    int sizeTmpByteArray = 0;
    byte[] tmpBindsByteArray;
    boolean needToSendOalToFetch = false;
    int[] definedColumnType = null;
    int[] definedColumnSize = null;
    int[] definedColumnFormOfUse = null;
    T4CTTIoac[] oacdefSent = null;
    int[] nbPostPonedColumns = null;
    int[][] indexOfPostPonedColumn = null;
    boolean aFetchWasDoneDuringDescribe = false;
    boolean implicitDefineForLobPrefetchDone = false;
    long checkSum = 0L;
    boolean checkSumComputationFailure = false;
    Vector m_batchItems = null;
    ArrayList tempClobsToFree = null;
    ArrayList tempBlobsToFree = null;
    ArrayList oldTempClobsToFree = null;
    ArrayList oldTempBlobsToFree = null;
    NTFDCNRegistration registration = null;
    String[] dcnTableName = null;
    long dcnQueryId = -1L;
    long localCheckSum = 0L;
    OracleStatement.BindChecksumListener bindChecksumListener;
    boolean isCloseOnCompletion = false;
    protected Object acProxy;
    private byte[] querycacheCompileKey;
    private long queryId;
    byte[] runtimeKey = null;
    MessageDigest md = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    abstract void doDescribe(boolean var1) throws SQLException;

    abstract void executeForDescribe() throws SQLException;

    abstract void executeForRows(boolean var1) throws SQLException;

    protected abstract void fetch(int var1, boolean var2) throws SQLException;

    abstract void doClose() throws SQLException;

    abstract void closeQuery() throws SQLException;

    public int cursorIfRefCursor() throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "cursorIfRefCursor not implemented");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    void continueReadRow(int n2) throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "continueReadRow is only implemented by the T4C statements.");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    void closeCursorOnPlainStatement() throws SQLException {
    }

    static final byte convertSqlKindEnumToByte(OracleStatement.SqlKind sqlKind) {
        return sqlKind.getKind();
    }

    static final OracleStatement.SqlKind convertSqlKindByteToEnum(byte by) {
        return OracleStatement.SqlKind.valueOf(by);
    }

    OracleStatement(PhysicalConnection physicalConnection, int n2, int n3) throws SQLException {
        this(physicalConnection, n2, n3, -1, -1);
    }

    OracleStatement(PhysicalConnection physicalConnection, int n2, int n3, int n4, int n5) throws SQLException {
        super(physicalConnection);
        this.connection.needLine();
        this.connection.registerHeartbeat();
        this.sqlObject = new OracleSql(this.connection.conversion);
        this.processEscapes = this.connection.processEscapes;
        this.convertNcharLiterals = this.connection.convertNcharLiterals;
        this.gotLastBatch = false;
        this.closed = false;
        this.clearParameters = true;
        this.serverCursor = false;
        this.fixedString = this.connection.getDefaultFixedString();
        this.rowPrefetchChanged = false;
        this.currentCapacity = this.rowPrefetch = n3;
        this.defaultRowPrefetch = n3;
        this.defaultLobPrefetchSize = this.connection.getVersionNumber() >= 11000 ? this.connection.defaultLobPrefetchSize : -1;
        this.batch = n2;
        this.needToParse = true;
        this.needToPrepareDefineBuffer = true;
        this.columnsDefinedByUser = false;
        this.configureRowData();
        this.userRsetType = OracleResultSet.ResultSetType.typeFor(n4, n5);
        if (this.userRsetType == OracleResultSet.ResultSetType.UNKNOWN) {
            this.userRsetType = DEFAULT_RESULT_SET_TYPE;
            this.realRsetType = DEFAULT_RESULT_SET_TYPE;
        } else {
            this.realRsetType = OracleResultSet.ResultSetType.UNKNOWN;
        }
        this.isFetchStreams = this.connection.useFetchSizeWithLongColumn || this.userRsetType != DEFAULT_RESULT_SET_TYPE;
        this.connection.addStatement(this);
    }

    @Override
    public void setWrapper(OracleStatementWrapper oracleStatementWrapper) {
        this.wrapper = oracleStatementWrapper;
    }

    @Override
    public void setSnapshotSCN(long l2) throws SQLException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("negative value");
        }
        this.connection.isResultSetCacheEnabled = false;
        this.doSetSnapshotSCN(l2);
    }

    void doSetSnapshotSCN(long l2) throws SQLException {
        SQLFeatureNotSupportedException sQLFeatureNotSupportedException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLFeatureNotSupportedException.fillInStackTrace();
        throw sQLFeatureNotSupportedException;
    }

    protected abstract void configureRowData();

    void prepareAccessors() throws SQLException {
        int n2;
        if (this.accessors == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        for (n2 = 0; n2 < this.numberOfDefinePositions; ++n2) {
            Accessor accessor = this.accessors[n2];
            if (accessor == null) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            switch (accessor.internalType) {
                case 8: 
                case 24: {
                    this.hasStream = true;
                }
            }
        }
        if (this.streamList != null && !this.isFetchStreams) {
            this.rowPrefetch = 1;
        }
        this.definesBatchSize = n2 = this.rowPrefetch;
        for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
            Accessor accessor = this.accessors[i2];
            accessor.setCapacity(n2);
        }
    }

    boolean checkAccessorsUsable() throws SQLException {
        int n2 = this.accessors.length;
        if (n2 < this.numberOfDefinePositions) {
            return false;
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
            Accessor accessor = this.accessors[i2];
            if (accessor == null || accessor.externalType == 0) {
                bl = false;
                continue;
            }
            bl2 = true;
        }
        if (bl) {
            bl3 = true;
        } else {
            if (bl2) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.columnsDefinedByUser = false;
        }
        return bl3;
    }

    void executeMaybeDescribe() throws SQLException {
        boolean bl = true;
        if (this.rowPrefetchChanged) {
            if (this.streamList == null && this.rowPrefetch != this.definesBatchSize) {
                this.needToPrepareDefineBuffer = true;
            }
            this.rowPrefetchChanged = false;
        }
        if (!this.needToPrepareDefineBuffer) {
            if (this.accessors == null) {
                this.needToPrepareDefineBuffer = true;
            } else if (this.columnsDefinedByUser) {
                this.needToPrepareDefineBuffer = !this.checkAccessorsUsable();
            }
        }
        boolean bl2 = false;
        try {
            this.cancelLock.enterExecuting();
            if (this.needToPrepareDefineBuffer) {
                if (!this.columnsDefinedByUser) {
                    this.executeForDescribe();
                    bl2 = true;
                    if (this.aFetchWasDoneDuringDescribe) {
                        bl = false;
                    }
                }
                if (this.needToPrepareDefineBuffer) {
                    this.prepareAccessors();
                }
            }
            int n2 = this.accessors.length;
            for (int i2 = this.numberOfDefinePositions; i2 < n2; ++i2) {
                Accessor accessor = this.accessors[i2];
                if (accessor == null) continue;
                accessor.rowSpaceIndicator = null;
            }
            if (bl) {
                this.executeForRows(bl2);
            }
            this.currentCapacity = this.rowPrefetch;
            this.storedRowCount = this.validRows == -2 ? 1 : this.validRows;
            this.indexOfFirstRow = 0;
        }
        catch (SQLException sQLException) {
            this.needToParse = true;
            throw sQLException;
        }
        finally {
            this.cancelLock.exitExecuting();
        }
    }

    void adjustGotLastBatch() {
    }

    protected void locationToPutBytes(Accessor accessor, int n2, int n3) throws SQLException {
        accessor.setOffset(n2, this.rowData.length());
    }

    protected boolean isQueryResultCached() throws SQLException {
        return false;
    }

    protected void cacheQueryResultIfAppropriate() throws SQLException {
    }

    protected void useCachedQueryResult() throws SQLException {
        this.rowData.free();
        this.rowData = this.cachedQueryResult.getRowData();
        this.accessors = this.cachedQueryResult.newAccessors(this);
        this.storedRowCount = this.cachedQueryResult.getNumberOfRows();
        this.validRows = this.cachedQueryResult.getNumberOfRows();
        this.cachedQueryResult = null;
        this.isAllFetched = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doExecuteWithTimeout() throws SQLException {
        block31: {
            if (this.realRsetType == OracleResultSet.ResultSetType.UNKNOWN) {
                this.realRsetType = this.userRsetType;
            }
            try {
                this.cleanOldTempLobs();
                this.connection.registerHeartbeat();
                this.rowsProcessed = 0;
                if (this.sqlKind.isSELECT()) {
                    if (this.connection.j2ee13Compliant && this.executionType == 2) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 129);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    if (this.isQueryResultCached()) {
                        this.useCachedQueryResult();
                    } else {
                        if (this.rowData instanceof ReadOnlyByteArray) {
                            this.rowData = this.bindData;
                            if (this.accessors != null) {
                                for (Accessor accessor : this.accessors) {
                                    if (accessor == null) continue;
                                    accessor.reinitForResultSetCache(this.rowData, this);
                                }
                            }
                        }
                        this.connection.needLine();
                        if (!this.isOpen) {
                            this.connection.open(this);
                            this.isOpen = true;
                        }
                        if (this.queryTimeout != 0) {
                            try {
                                this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
                                this.executeMaybeDescribe();
                            }
                            finally {
                                this.connection.getTimeout().cancelTimeout();
                            }
                        } else {
                            this.executeMaybeDescribe();
                        }
                        this.cacheQueryResultIfAppropriate();
                        this.checkValidRowsStatus();
                    }
                    if (this.serverCursor) {
                        this.adjustGotLastBatch();
                    }
                    break block31;
                }
                if (this.connection.j2ee13Compliant && !this.sqlKind.isPlsqlOrCall() && this.executionType == 1) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 128);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                ++this.currentRank;
                if (this.currentRank < this.batch) break block31;
                try {
                    this.connection.needLine();
                    this.cancelLock.enterExecuting();
                    if (!this.isOpen) {
                        this.connection.open(this);
                        this.isOpen = true;
                    }
                    if (this.queryTimeout != 0) {
                        this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
                    }
                    this.executeForRows(false);
                }
                catch (SQLException sQLException) {
                    this.needToParse = true;
                    if (this.batch > 1) {
                        int n2;
                        int[] nArray;
                        this.clearBatch();
                        if (this.numberOfExecutedElementsInBatch != -1 && this.numberOfExecutedElementsInBatch < this.batch) {
                            nArray = new int[this.numberOfExecutedElementsInBatch];
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                nArray[n2] = -2;
                            }
                        } else {
                            nArray = new int[this.batch];
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                nArray[n2] = -3;
                            }
                        }
                        BatchUpdateException batchUpdateException = DatabaseError.createBatchUpdateException(sQLException, nArray.length, nArray);
                        batchUpdateException.fillInStackTrace();
                        throw batchUpdateException;
                    }
                    this.resetCurrentRowBinders();
                    throw sQLException;
                }
                finally {
                    if (this.queryTimeout != 0) {
                        this.connection.getTimeout().cancelTimeout();
                    }
                    this.currentRank = 0;
                    this.cancelLock.exitExecuting();
                    this.checkValidRowsStatus();
                }
            }
            catch (SQLException sQLException) {
                this.resetOnExceptionDuringExecute();
                throw sQLException;
            }
        }
        this.connection.registerHeartbeat();
    }

    void resetOnExceptionDuringExecute() {
        this.needToParse = true;
    }

    void resetCurrentRowBinders() {
    }

    void open() throws SQLException {
        if (!this.isOpen) {
            this.connection.needLine();
            this.connection.open(this);
            this.isOpen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSet oracleResultSet = null;
            this.cleanUpBeforeExecute();
            this.realRsetType = OracleResultSet.ResultSetType.UNKNOWN;
            try {
                this.executionType = 1;
                this.noMoreUpdateCounts = false;
                this.ensureOpen();
                this.checkIfJdbcBatchExists();
                this.sendBatch();
                this.hasStream = false;
                this.sqlObject.initialize(string);
                this.sqlKind = this.sqlObject.getSqlKind();
                this.needToParse = true;
                this.prepareForNewResults(true, true, true);
                if (this.userRsetType == DEFAULT_RESULT_SET_TYPE) {
                    this.doExecuteWithTimeout();
                    if (this.implicitResultSetStatements == null) {
                        if (this.sqlKind.isPlsqlOrCall()) {
                            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 128);
                            sQLException.fillInStackTrace();
                            throw sQLException;
                        }
                        this.computeOffsetOfFirstUserColumn();
                        this.computeNumberOfUserColumns();
                        oracleResultSet = this.currentResultSet = OracleResultSet.createResultSet(this);
                    }
                } else {
                    oracleResultSet = this.doScrollStmtExecuteQuery();
                    if (oracleResultSet == null && this.implicitResultSetStatements == null) {
                        if (this.sqlKind.isPlsqlOrCall()) {
                            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 128);
                            sQLException.fillInStackTrace();
                            throw sQLException;
                        }
                        this.computeOffsetOfFirstUserColumn();
                        this.computeNumberOfUserColumns();
                        oracleResultSet = this.currentResultSet = OracleResultSet.createResultSet(this);
                    }
                }
            }
            finally {
                this.executionType = (byte)-1;
            }
            return oracleResultSet;
        }
    }

    @Override
    public void closeWithKey(String string) throws SQLException {
        SQLFeatureNotSupportedException sQLFeatureNotSupportedException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLFeatureNotSupportedException.fillInStackTrace();
        throw sQLFeatureNotSupportedException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.closeOrCache(null);
        }
    }

    void closeWrapper() throws SQLException {
        if (this.wrapper != null) {
            this.wrapper.beClosed();
        }
    }

    protected void closeOrCache(String string) throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.connection.lifecycle == 2) {
            this.connection.needLineUnchecked();
        } else {
            this.connection.needLine();
        }
        if (this.statementType != 0 && this.cacheState != 0 && this.cacheState != 3 && this.connection.isStatementCacheInitialized()) {
            if (string == null) {
                if (this.connection.getImplicitCachingEnabled()) {
                    this.connection.cacheImplicitStatement((OraclePreparedStatement)this, this.sqlObject.getOriginalSql(), this.statementType, this.userRsetType);
                } else {
                    this.cacheState = 0;
                    this.hardClose();
                }
            } else if (this.connection.getExplicitCachingEnabled()) {
                this.connection.cacheExplicitStatement((OraclePreparedStatement)this, string);
            } else {
                this.cacheState = 0;
                this.hardClose();
            }
        } else {
            this.hardClose();
        }
    }

    protected void hardClose() throws SQLException {
        this.hardClose(true);
    }

    private void hardClose(boolean bl) throws SQLException {
        this.alwaysOnClose();
        this.describedWithNames = false;
        this.described = false;
        this.connection.removeStatement(this);
        this.clearDefines();
        if (this.isOpen && bl && (this.connection.lifecycle == 1 || this.connection.lifecycle == 16 || this.connection.lifecycle == 2)) {
            this.connection.registerHeartbeat();
            this.doClose();
            this.isOpen = false;
            if (this.refreshStatement != null) {
                this.refreshStatement.close();
            }
        }
        this.sqlObject = null;
    }

    protected void alwaysOnClose() throws SQLException {
        if (this.implicitResultSetStatements != null) {
            for (OracleStatement wrapper : this.implicitResultSetStatements) {
                wrapper.close();
            }
            if (this.openImplicitResultSets != null) {
                for (OracleResultSet oracleResultSet : this.openImplicitResultSets) {
                    oracleResultSet.close();
                }
            }
        }
        Iterator<OracleResultSet> iterator = this.children;
        while (iterator != null) {
            OracleStatement oracleStatement = ((OracleStatement)((Object)iterator)).nextChild;
            ((OracleStatement)((Object)iterator)).close();
            iterator = oracleStatement;
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.closed = true;
        if (this.connection != null && (this.connection.lifecycle == 1 || this.connection.lifecycle == 2) && this.currentResultSet != null) {
            this.currentResultSet.doneFetchingRows(false);
            this.currentResultSet.close();
            this.currentResultSet = null;
        }
        this.sqlWarning = null;
        this.m_batchItems = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeLeaveCursorOpen() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                return;
            }
            this.hardClose(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.cleanUpBeforeExecute();
            return this.executeUpdateInternal(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int executeUpdateInternal(String string) throws SQLException {
        try {
            if (this.executionType == -1) {
                this.executionType = (byte)2;
            }
            this.noMoreUpdateCounts = false;
            this.ensureOpen();
            this.checkIfJdbcBatchExists();
            this.sendBatch();
            this.hasStream = false;
            this.sqlObject.initialize(string);
            this.sqlKind = this.sqlObject.getSqlKind();
            this.needToParse = true;
            this.prepareForNewResults(true, true, true);
            if (this.userRsetType == DEFAULT_RESULT_SET_TYPE) {
                this.doExecuteWithTimeout();
            } else {
                this.doScrollStmtExecuteQuery();
            }
            int n2 = this.validRows;
            return n2;
        }
        finally {
            this.executionType = (byte)-1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.cleanUpBeforeExecute();
            return this.executeInternal(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeInternal(String string) throws SQLException {
        try {
            this.executionType = (byte)3;
            this.checkSum = 0L;
            this.checkSumComputationFailure = false;
            this.noMoreUpdateCounts = false;
            this.ensureOpen();
            this.checkIfJdbcBatchExists();
            this.sendBatch();
            this.hasStream = false;
            this.sqlObject.initialize(string);
            this.sqlKind = this.sqlObject.getSqlKind();
            this.needToParse = true;
            this.prepareForNewResults(true, true, true);
            if (this.isCloseOnCompletion) {
                this.ensureOpen();
            }
            this.runtimeKey = null;
            if (this.userRsetType == DEFAULT_RESULT_SET_TYPE) {
                this.doExecuteWithTimeout();
            } else {
                this.doScrollStmtExecuteQuery();
            }
            boolean bl = this.sqlKind.isSELECT() || this.implicitResultSetStatements != null;
            return bl;
        }
        finally {
            this.executionType = (byte)-1;
        }
    }

    final int getNumberOfUserColumns() throws SQLException {
        return this.numberOfUserColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void computeNumberOfUserColumns() throws SQLException {
        if (this.serverCursor) {
            this.numberOfUserColumns = this.accessors == null ? 0 : this.accessors.length;
        } else if (this.sqlKind.isSELECT()) {
            this.ensureOpen();
            if (!this.described) {
                PhysicalConnection physicalConnection = this.connection;
                synchronized (physicalConnection) {
                    this.doDescribe(false);
                    this.described = true;
                }
            }
            this.numberOfUserColumns = this.numberOfDefinePositions - (1 + this.offsetOfFirstUserColumn);
        } else {
            this.numberOfUserColumns = this.numReturnParams;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Accessor[] getDescription() throws SQLException {
        this.ensureOpen();
        if (!this.described) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.doDescribe(false);
                this.described = true;
            }
        }
        return this.accessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Accessor[] getDescriptionWithNames() throws SQLException {
        this.ensureOpen();
        if (!this.describedWithNames) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.doDescribe(true);
                this.described = true;
                this.describedWithNames = true;
            }
        }
        return this.accessors;
    }

    @Override
    public OracleStatement.SqlKind getSqlKind() throws SQLException {
        return this.sqlObject.getSqlKind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDefines() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.freeLine();
            this.streamList = null;
            this.columnsDefinedByUser = false;
            this.needToPrepareDefineBuffer = true;
            this.numberOfDefinePositions = 0;
            this.definesBatchSize = 0;
            this.described = false;
            this.describedWithNames = false;
            this.cleanupDefines();
        }
    }

    void reparseOnRedefineIfNeeded() throws SQLException {
    }

    void defineColumnTypeInternal(int n2, int n3, int n4, boolean bl, String string) throws SQLException {
        this.defineColumnTypeInternal(n2, n3, n4, (short)1, bl, string);
    }

    void defineColumnTypeInternal(int n2, int n3, int n4, short s2, boolean bl, String string) throws SQLException {
        int n5;
        if (this.connection.disableDefinecolumntype) {
            return;
        }
        if (n2 < 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n3 == 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n6 = n2 - 1;
        int n7 = n5 = this.maxFieldSize > 0 ? this.maxFieldSize : -1;
        if (!bl) {
            if (n4 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 53);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n3 == 2005 || n3 == 2004) {
                if (n5 == -1 && n4 > 0 || n5 > 0 && n4 < n5) {
                    n5 = n4;
                }
            } else {
                n5 = -1;
            }
        }
        if (this.currentResultSet != null && !this.currentResultSet.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 28);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (!this.columnsDefinedByUser) {
            this.clearDefines();
            this.columnsDefinedByUser = true;
        }
        if (this.numberOfDefinePositions < n2) {
            if (this.accessors == null || this.accessors.length < n2) {
                Accessor[] accessorArray = new Accessor[n2 << 1];
                if (this.accessors != null) {
                    System.arraycopy(this.accessors, 0, accessorArray, 0, this.numberOfDefinePositions);
                }
                this.accessors = accessorArray;
            }
            this.numberOfDefinePositions = n2;
        }
        switch (n3) {
            case -16: 
            case -15: 
            case -9: 
            case 2011: {
                s2 = (short)2;
                break;
            }
            case 2009: {
                string = "SYS.XMLTYPE";
                break;
            }
        }
        int n8 = this.getInternalType(n3);
        if (!(n8 != 109 && n8 != 111 || string != null && !string.equals(""))) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = this.accessors[n6];
        boolean bl2 = true;
        if (accessor != null) {
            int n9 = accessor.useForDataAccessIfPossible(n8, n3, n5, string);
            if (n9 == 0) {
                s2 = accessor.formOfUse;
                accessor = null;
                this.reparseOnRedefineIfNeeded();
            } else if (n9 == 1) {
                accessor = null;
                this.reparseOnRedefineIfNeeded();
            } else if (n9 == 2) {
                bl2 = false;
            }
        }
        if (bl2) {
            this.needToPrepareDefineBuffer = true;
        }
        if (accessor == null) {
            this.accessors[n6] = this.allocateAccessor(n8, n3, n2, n5, s2, string, false);
            this.described = false;
            this.describedWithNames = false;
        }
        this.executeDoneForDefines = false;
    }

    Accessor allocateAccessor(int n2, int n3, int n4, int n5, short s2, String string, boolean bl) throws SQLException {
        switch (n2) {
            case 96: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new CharAccessor(this, n5, s2, n3, bl);
            }
            case 8: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (!bl) {
                    return new LongAccessor(this, n4, n5, s2, n3);
                }
            }
            case 1: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new VarcharAccessor(this, n5, s2, n3, bl);
            }
            case 2: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new NumberAccessor(this, n5, s2, n3, bl);
            }
            case 6: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new VarnumAccessor(this, n5, s2, n3, bl);
            }
            case 24: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (!bl) {
                    return new LongRawAccessor(this, n4, n5, s2, n3);
                }
            }
            case 23: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (bl) {
                    return new OutRawAccessor(this, n5, s2, n3);
                }
                return new RawAccessor(this, n5, s2, n3, false);
            }
            case 100: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new BinaryFloatAccessor(this, n5, s2, n3, bl);
            }
            case 101: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new BinaryDoubleAccessor(this, n5, s2, n3, bl);
            }
            case 104: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK) {
                    n5 = 18;
                    VarcharAccessor varcharAccessor = new VarcharAccessor(this, n5, s2, n3, bl);
                    varcharAccessor.definedColumnType = -8;
                    return varcharAccessor;
                }
                return new RowidAccessor(this, n5, s2, n3, bl);
            }
            case 102: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new ResultSetAccessor(this, n5, s2, n3, bl);
            }
            case 12: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new DateAccessor(this, n5, s2, n3, bl);
            }
            case 113: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                BlobAccessor blobAccessor = new BlobAccessor(this, -1, s2, n3, bl);
                return blobAccessor;
            }
            case 112: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                ClobAccessor clobAccessor = new ClobAccessor(this, -1, s2, n3, bl);
                return clobAccessor;
            }
            case 114: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                BfileAccessor bfileAccessor = new BfileAccessor(this, -1, s2, n3, bl);
                return bfileAccessor;
            }
            case 109: {
                if (string == null) {
                    if (bl) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"null\"");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                NamedTypeAccessor namedTypeAccessor = new NamedTypeAccessor(this, string, s2, n3, bl);
                ((Accessor)namedTypeAccessor).initMetadata();
                return namedTypeAccessor;
            }
            case 111: {
                if (string == null) {
                    if (bl) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"null\"");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                RefTypeAccessor refTypeAccessor = new RefTypeAccessor(this, string, s2, n3, bl);
                ((Accessor)refTypeAccessor).initMetadata();
                return refTypeAccessor;
            }
            case 180: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new TimestampAccessor(this, n5, s2, n3, bl);
            }
            case 181: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new TimestamptzAccessor(this, n5, s2, n3, bl);
            }
            case 231: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new TimestampltzAccessor(this, n5, s2, n3, bl);
            }
            case 182: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new IntervalymAccessor(this, n5, s2, n3, bl);
            }
            case 183: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new IntervaldsAccessor(this, n5, s2, n3, bl);
            }
            case 995: {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    void setDriverSpecificData(Accessor accessor) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineColumnType(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.defineColumnTypeInternal(n2, n3, -1, true, null);
        }
    }

    @Override
    public void defineColumnType(int n2, int n3, int n4) throws SQLException {
        this.defineColumnTypeInternal(n2, n3, n4, false, null);
    }

    @Override
    public void defineColumnType(int n2, int n3, int n4, short s2) throws SQLException {
        this.defineColumnTypeInternal(n2, n3, n4, s2, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineColumnTypeBytes(int n2, int n3, int n4) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.defineColumnTypeInternal(n2, n3, n4, false, null);
        }
    }

    @Override
    public void defineColumnTypeChars(int n2, int n3, int n4) throws SQLException {
        this.defineColumnTypeInternal(n2, n3, n4, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineColumnType(int n2, int n3, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.defineColumnTypeInternal(n2, n3, -1, true, string);
        }
    }

    void setCursorId(int n2) throws SQLException {
        this.cursorId = n2;
    }

    void setPrefetchInternal(int n2, boolean bl, boolean bl2) throws SQLException {
        if (bl) {
            if (n2 <= 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 20);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        } else {
            if (n2 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setFetchSize");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 == 0) {
                n2 = this.connection.getDefaultRowPrefetch();
            }
        }
        if (bl2) {
            if (n2 != this.defaultRowPrefetch) {
                this.defaultRowPrefetch = n2;
                if (this.currentResultSet == null || this.currentResultSet.closed) {
                    this.rowPrefetchChanged = true;
                }
            }
        } else if (n2 != this.rowPrefetch && this.streamList == null) {
            this.rowPrefetch = n2;
            this.rowPrefetchChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRowPrefetch(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setPrefetchInternal(n2, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLobPrefetchSize(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (n2 < -1) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 267);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.defaultLobPrefetchSize = n2;
        }
    }

    @Override
    public int getLobPrefetchSize() throws SQLException {
        return this.defaultLobPrefetchSize;
    }

    int getPrefetchInternal(boolean bl) {
        int n2 = bl ? this.defaultRowPrefetch : this.rowPrefetch;
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowPrefetch() {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getPrefetchInternal(true);
        }
    }

    @Override
    public void setFixedString(boolean bl) {
        this.fixedString = bl;
    }

    @Override
    public boolean getFixedString() {
        return this.fixedString;
    }

    void check_row_prefetch_changed() throws SQLException {
        if (this.rowPrefetchChanged) {
            if (this.streamList == null) {
                this.prepareAccessors();
                this.needToPrepareDefineBuffer = true;
            }
            this.rowPrefetchChanged = false;
        }
    }

    void setDefinesInitialized(boolean bl) {
    }

    void printState(String string) throws SQLException {
    }

    void checkValidRowsStatus() throws SQLException {
        if (this.validRows == -2) {
            this.validRows = 1;
            this.connection.holdLine(this);
            OracleInputStream oracleInputStream = this.streamList;
            while (oracleInputStream != null) {
                if (oracleInputStream.hasBeenOpen) {
                    oracleInputStream = oracleInputStream.accessor.initForNewRow();
                }
                oracleInputStream.closed = false;
                oracleInputStream.hasBeenOpen = true;
                oracleInputStream = oracleInputStream.nextStream;
            }
            this.nextStream = this.streamList;
        } else if (this.sqlKind.isSELECT()) {
            if (this.validRows < this.rowPrefetch) {
                this.gotLastBatch = true;
                this.initializeCacheEntryIfApplicable();
            }
        } else if (!this.sqlKind.isPlsqlOrCall()) {
            this.rowsProcessed = this.validRows;
        }
    }

    void initializeCacheEntryIfApplicable() throws SQLException {
        int n2 = (this.storedRowCount < this.rowPrefetch ? 0 : this.storedRowCount) + this.validRows;
        if (this.cachedQueryResult != null) {
            long l2 = this.rowData.length();
            for (Accessor object : this.accessors) {
                if (object == null) continue;
                l2 += (long)(24 + n2 * 14);
            }
            ResultSetCache resultSetCache = this.connection.getResultSetCacheInternal();
            long l3 = resultSetCache.getMaxCacheSize() - resultSetCache.getCurrentCacheSize();
            if (l2 <= l3) {
                ByteArray byteArray;
                this.rowData = byteArray = this.rowData.compact();
                this.rowData = ReadOnlyByteArray.newReadOnlyByteArray(this.rowData);
                this.cachedQueryResult.initialize(n2, this.rowData, this.accessors, l2);
                resultSetCache.updateCurrentCacheSize(l2);
                this.cachedQueryResult = null;
            }
        }
    }

    void cleanupDefines() {
        if (this.accessors != null) {
            for (int i2 = 0; i2 < this.accessors.length; ++i2) {
                this.accessors[i2] = null;
            }
        }
        this.accessors = null;
        if (this.rowData != null) {
            this.rowData.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxFieldSize() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.maxFieldSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxFieldSize(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (n2 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.maxFieldSize = n2;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.ensureOpen();
        return this.maxRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxRows(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (n2 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.maxRows = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.processEscapes = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getQueryTimeout() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.queryTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQueryTimeout(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (n2 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.queryTimeout = n2;
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.ensureOpen();
        this.doCancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doCancel() throws SQLException {
        boolean bl = false;
        if (this.closed) {
            return bl;
        }
        if (this.connection.statementHoldingLine != null) {
            this.freeLine();
        } else if (this.cancelLock.enterCanceling()) {
            try {
                bl = true;
                this.connection.cancelOperationOnServer(true);
            }
            finally {
                this.cancelLock.exitCanceling();
            }
        } else {
            return bl;
        }
        OracleStatement oracleStatement = this.children;
        while (oracleStatement != null) {
            bl = bl || oracleStatement.doCancel();
            oracleStatement = oracleStatement.nextChild;
        }
        this.connection.releaseLineForCancel();
        return bl;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureOpen();
        return this.sqlWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureOpen();
        this.sqlWarning = null;
    }

    void foundPlsqlCompilerWarning() throws SQLException {
        SQLWarning sQLWarning = DatabaseError.addSqlWarning(this.sqlWarning, "Found Plsql compiler warnings.", 24439);
        if (this.sqlWarning != null) {
            this.sqlWarning.setNextWarning(sQLWarning);
        } else {
            this.sqlWarning = sQLWarning;
        }
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        SQLFeatureNotSupportedException sQLFeatureNotSupportedException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLFeatureNotSupportedException.fillInStackTrace();
        throw sQLFeatureNotSupportedException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getResultSet() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.implicitResultSetStatements != null) {
                if (this.currentResultSet != null) {
                    return this.currentResultSet;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 283);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.sqlKind.isSELECT()) {
                if (this.currentResultSet == null) {
                    this.computeOffsetOfFirstUserColumn();
                    this.computeNumberOfUserColumns();
                    this.currentResultSet = OracleResultSet.createResultSet(this);
                }
                return this.currentResultSet;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUpdateCount() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            int n2 = -1;
            switch (this.sqlKind) {
                case UNINITIALIZED: 
                case SELECT_FOR_UPDATE: 
                case SELECT: {
                    break;
                }
                case ALTER_SESSION: 
                case OTHER: {
                    if (!this.noMoreUpdateCounts) {
                        n2 = this.rowsProcessed;
                    }
                    this.noMoreUpdateCounts = true;
                    break;
                }
                case PLSQL_BLOCK: 
                case CALL_BLOCK: {
                    this.noMoreUpdateCounts = true;
                    break;
                }
                case DELETE: 
                case INSERT: 
                case MERGE: 
                case UPDATE: {
                    if (!this.noMoreUpdateCounts) {
                        n2 = this.rowsProcessed;
                    }
                    this.noMoreUpdateCounts = true;
                }
            }
            return n2;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.ensureOpen();
        return this.getMoreResults(1);
    }

    @Override
    public int sendBatch() throws SQLException {
        return 0;
    }

    protected void increaseCapacity(int n2) {
        if (this.storedRowCount + n2 > this.currentCapacity) {
            int n3;
            if (this.currentCapacity < 1024) {
                n3 = this.currentCapacity * 4;
            }
            n3 = this.currentCapacity < 16384 ? (int)((double)this.currentCapacity * 1.5) : (int)((double)this.currentCapacity * 1.2);
            n3 = Math.max(this.storedRowCount + n2, n3);
            n3 = (n3 / this.rowPrefetch + 1) * this.rowPrefetch;
            for (Accessor accessor : this.accessors) {
                if (accessor == null) continue;
                accessor.setCapacity(n3);
            }
            this.currentCapacity = n3;
        }
        assert (this.currentCapacity >= this.storedRowCount + n2) : "currentCapacity: " + this.currentCapacity + " storedRowCount: " + this.storedRowCount + ", numberOfRows: " + n2;
    }

    protected void drainStreams() throws SQLException {
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int fetchMoreRows(int n2) throws SQLException {
        assert (!this.isAllFetched) : "isAllFetched: " + this.isAllFetched;
        if (this.fetchMode == FetchMode.APPEND) {
            this.increaseCapacity(this.rowPrefetch);
        }
        this.check_row_prefetch_changed();
        this.drainStreams();
        this.connection.registerHeartbeat();
        this.connection.needLine();
        try {
            this.cancelLock.enterExecuting();
            this.fetch(this.fetchMode == FetchMode.APPEND ? n2 : 0, this.fetchMode == FetchMode.APPEND);
            assert (this.validRows != -2 || this.rowPrefetch == 1) : "validRows: " + this.validRows + " rowPrefetch: " + this.rowPrefetch;
        }
        finally {
            this.cancelLock.exitExecuting();
        }
        this.checkValidRowsStatus();
        if (this.fetchMode == FetchMode.APPEND) {
            this.storedRowCount += this.validRows;
        } else {
            this.indexOfFirstRow += this.storedRowCount;
            this.storedRowCount = this.validRows;
        }
        if (this.maxRows > 0 && this.indexOfFirstRow + this.storedRowCount >= this.maxRows) {
            this.isAllFetched = true;
        }
        assert (n2 - this.indexOfFirstRow >= 0) : "firstRow: " + n2 + " indexOfFirstRow: " + this.indexOfFirstRow;
        assert (n2 - this.indexOfFirstRow < this.currentCapacity) : "firstRow: " + n2 + " indexOfFirstRow: " + this.indexOfFirstRow + " currentCapacity: " + this.currentCapacity;
        assert (this.validRows >= 0) : "validRows: " + this.validRows;
        assert (this.validRows > 0 || this.isAllFetched) : "validRows: " + this.validRows + ", isAllFetched: " + this.isAllFetched;
        return this.validRows;
    }

    boolean isAllFetched() throws SQLException {
        return this.isAllFetched || this.implicitResultSetStatements == null && !this.serverCursor && !this.sqlObject.getSqlKind().isSELECT();
    }

    int storedRowCount() {
        return this.storedRowCount;
    }

    int refreshRows(int n2, int n3) throws SQLException {
        ARRAY aRRAY = this.connection.createARRAY(SYS_ODCIVARCHAR2LIST, this.getRowKeys(n2 - this.indexOfFirstRow, n3));
        return this.refreshRowsInternal(aRRAY, n2 - this.indexOfFirstRow, n3);
    }

    void insertRow(int n2, RowId rowId) throws SQLException {
        if (this.currentCapacity < this.storedRowCount + 1) {
            this.increaseCapacity(this.storedRowCount + 1);
        }
        RowId[] rowIdArray = new RowId[]{rowId};
        ARRAY aRRAY = this.connection.createARRAY(SYS_ODCIVARCHAR2LIST, rowIdArray);
        for (Accessor accessor : this.accessors) {
            if (accessor == null) continue;
            accessor.insertNull(n2 - this.indexOfFirstRow);
        }
        int n3 = this.refreshRowsInternal(aRRAY, n2 - this.indexOfFirstRow, 1);
        assert (n3 == 1) : "count: " + n3;
        this.storedRowCount += n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int refreshRowsInternal(Array array, int n2, int n3) throws SQLException {
        if (this.refreshStatement == null) {
            this.refreshStatement = this.connection.prepareStatementInternal(this.sqlObject.getRefetchSql(), 1003, 1007);
            this.refreshStatement.isRowidPrepended = true;
            this.refreshStatement.isFetchStreams = true;
            this.refreshStatement.copyDefines(this, n3);
            this.copyBinds(this.refreshStatement, 1);
        }
        this.refreshStatement.setArray(1, array);
        this.refreshStatement.setFetchSize(n3);
        ResultSet resultSet = null;
        try {
            resultSet = this.refreshStatement.executeQuery();
            int n4 = 0;
            int n5 = 0;
            while (resultSet.next()) {
                if (this.accessors[0].getROWID(n2 + n5) == null || this.accessors[0].getROWID(n2 + n5).equals(this.refreshStatement.accessors[0].getROWID(n5))) {
                    int n6 = this.accessors[0].getROWID(n2 + n5) == null ? 0 : 1;
                    ++n4;
                    for (int i2 = n6; i2 < this.accessors.length; ++i2) {
                        if (this.accessors[i2] == null) continue;
                        this.accessors[i2].copyFrom(this.refreshStatement.accessors[i2], n5, n2 + n5);
                    }
                }
                ++n5;
            }
            n5 = n4;
            return n5;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (this.refreshStatement != null) {
                try {
                    this.refreshStatement.drainStreams();
                    this.refreshStatement.close();
                }
                catch (Exception exception) {
                }
                finally {
                    this.refreshStatement = null;
                }
            }
        }
    }

    protected String[] getRowKeys(int n2, int n3) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>(n3);
        int n4 = Math.min(n3, this.storedRowCount - n2);
        for (int i2 = 0; i2 < n4; ++i2) {
            arrayList.add(this.accessors[0].getString(n2 + i2));
        }
        return arrayList.toArray(new String[0]);
    }

    void removeRowFromCache(int n2) throws SQLException {
        if (n2 < this.indexOfFirstRow) {
            --this.indexOfFirstRow;
        } else if (n2 >= this.indexOfFirstRow) {
            assert (n2 < this.indexOfFirstRow + this.storedRowCount) : "row: " + n2 + " indexOfFirstRow: " + this.indexOfFirstRow + " storedRowCount: " + this.storedRowCount;
            for (Accessor accessor : this.accessors) {
                if (accessor == null) continue;
                this.deleteRow(accessor, n2 - this.indexOfFirstRow);
            }
            --this.storedRowCount;
        }
    }

    void deleteRow(Accessor accessor, int n2) throws SQLException {
        accessor.deleteRow(n2);
    }

    void prepareForNewResults(boolean bl, boolean bl2, boolean bl3) throws SQLException {
        if (!this.closed) {
            this.clearWarnings();
        }
        if (bl3 && this.implicitResultSetStatements != null) {
            for (OracleStatement wrapper : this.implicitResultSetStatements) {
                wrapper.close();
            }
            this.implicitResultSetStatements = null;
            this.implicitResultSetIterator = null;
            if (this.openImplicitResultSets != null) {
                for (OracleResultSet oracleResultSet : this.openImplicitResultSets) {
                    oracleResultSet.close();
                }
                this.openImplicitResultSets = null;
            }
        }
        this.closeAllStreams(bl2);
        if (this.currentResultSet != null) {
            this.currentResultSet.close();
            this.currentResultSet = null;
        }
        if (this.bindUseDBA) {
            this.resetBindData();
        } else {
            this.rowData.reset();
        }
        this.storedRowCount = 0;
        this.indexOfFirstRow = 0;
        this.isAllFetched = false;
        this.offsetOfFirstUserColumn = -1;
        this.numberOfUserColumns = -1;
        this.checkSum = 0L;
        this.checkSumComputationFailure = false;
        this.validRows = 0;
        this.batchRowsUpdatedArray = null;
        this.gotLastBatch = false;
        if (this.needToParse && !this.columnsDefinedByUser) {
            if (bl2 && this.numberOfDefinePositions != 0) {
                this.numberOfDefinePositions = 0;
            }
            this.needToPrepareDefineBuffer = true;
        }
        if (bl && this.rowPrefetch != this.defaultRowPrefetch && this.streamList == null) {
            this.rowPrefetch = this.defaultRowPrefetch;
            this.rowPrefetchChanged = true;
        }
    }

    void resetBindData() {
        this.rowData.setPosition(this.beyondBindData);
    }

    void closeAllStreams(boolean bl) throws SQLException {
        this.drainStreams();
        if (bl) {
            OracleInputStream oracleInputStream = this.streamList;
            OracleInputStream oracleInputStream2 = null;
            this.streamList = null;
            while (oracleInputStream != null) {
                if (!oracleInputStream.hasBeenOpen) {
                    if (oracleInputStream2 == null) {
                        this.streamList = oracleInputStream;
                    } else {
                        oracleInputStream2.nextStream = oracleInputStream;
                    }
                    oracleInputStream2 = oracleInputStream;
                }
                oracleInputStream = oracleInputStream.nextStream;
            }
        }
    }

    void reopenStreams() throws SQLException {
        OracleInputStream oracleInputStream = this.streamList;
        while (oracleInputStream != null) {
            if (oracleInputStream.hasBeenOpen) {
                oracleInputStream = oracleInputStream.accessor.initForNewRow();
            }
            oracleInputStream.closed = false;
            oracleInputStream.hasBeenOpen = true;
            oracleInputStream = oracleInputStream.nextStream;
        }
        this.nextStream = this.streamList;
    }

    void endOfResultSet(boolean bl) throws SQLException {
        if (!bl) {
            this.prepareForNewResults(false, false, false);
        }
        this.clearDefines();
        this.rowPrefetchInLastFetch = -1;
    }

    boolean wasNullValue(int n2) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "wasNull");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.lastIndex < 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.isNull(n2, this.lastIndex);
    }

    boolean isNull(int n2, int n3) throws SQLException {
        if (this.sqlKind.isSELECT() || this.isDmlReturning) {
            return this.accessors[n3 + this.offsetOfFirstUserColumn].isNull(n2 - this.indexOfFirstRow);
        }
        assert (n2 == this.currentRank) : "rowIndex: " + n2 + " currentRank: " + this.currentRank;
        return this.outBindAccessors[n3 - 1].isNull(this.currentRank);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getColumnIndex(String string) throws SQLException {
        Object object;
        this.ensureOpen();
        if (!this.describedWithNames) {
            object = this.connection;
            synchronized (object) {
                this.doDescribe(true);
                this.described = true;
                this.describedWithNames = true;
            }
        }
        for (int i2 = 1 + this.offsetOfFirstUserColumn; i2 < this.numberOfDefinePositions; ++i2) {
            if (!this.accessors[i2].columnName.equalsIgnoreCase(string)) continue;
            return i2 - this.offsetOfFirstUserColumn;
        }
        object = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
        ((Throwable)object).fillInStackTrace();
        throw object;
    }

    int getJDBCType(int n2) throws SQLException {
        int n3 = 0;
        switch (n2) {
            case 6: {
                n3 = 2;
                break;
            }
            case 100: {
                n3 = 100;
                break;
            }
            case 101: {
                n3 = 101;
                break;
            }
            case 999: {
                n3 = 999;
                break;
            }
            case 96: {
                n3 = 1;
                break;
            }
            case 1: {
                n3 = 12;
                break;
            }
            case 8: {
                n3 = -1;
                break;
            }
            case 12: {
                n3 = 91;
                break;
            }
            case 180: {
                n3 = 93;
                break;
            }
            case 181: {
                n3 = -101;
                break;
            }
            case 231: {
                n3 = -102;
                break;
            }
            case 182: {
                n3 = -103;
                break;
            }
            case 183: {
                n3 = -104;
                break;
            }
            case 23: {
                n3 = -2;
                break;
            }
            case 24: {
                n3 = -4;
                break;
            }
            case 104: {
                n3 = -8;
                break;
            }
            case 113: {
                n3 = 2004;
                break;
            }
            case 112: {
                n3 = 2005;
                break;
            }
            case 114: {
                n3 = -13;
                break;
            }
            case 102: {
                n3 = -10;
                break;
            }
            case 109: {
                n3 = 2002;
                break;
            }
            case 111: {
                n3 = 2006;
                break;
            }
            case 998: {
                n3 = -14;
                break;
            }
            case 995: {
                n3 = 0;
                break;
            }
            default: {
                n3 = n2;
            }
        }
        return n3;
    }

    int getInternalType(int n2) throws SQLException {
        int n3 = 0;
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n3 = 6;
                break;
            }
            case 100: {
                n3 = 100;
                break;
            }
            case 101: {
                n3 = 101;
                break;
            }
            case 999: {
                n3 = 999;
                break;
            }
            case 1: {
                n3 = 96;
                break;
            }
            case -15: 
            case -9: 
            case 12: {
                n3 = 1;
                break;
            }
            case -16: 
            case -1: {
                n3 = 8;
                break;
            }
            case 91: 
            case 92: {
                n3 = 12;
                break;
            }
            case -100: 
            case 93: {
                n3 = 180;
                break;
            }
            case -101: {
                n3 = 181;
                break;
            }
            case -102: {
                n3 = 231;
                break;
            }
            case -103: {
                n3 = 182;
                break;
            }
            case -104: {
                n3 = 183;
                break;
            }
            case -3: 
            case -2: {
                n3 = 23;
                break;
            }
            case -4: {
                n3 = 24;
                break;
            }
            case -8: {
                n3 = 104;
                break;
            }
            case 2004: {
                n3 = 113;
                break;
            }
            case 2005: 
            case 2011: {
                n3 = 112;
                break;
            }
            case -13: {
                n3 = 114;
                break;
            }
            case -10: {
                n3 = 102;
                break;
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: 
            case 2009: {
                n3 = 109;
                break;
            }
            case 2006: {
                n3 = 111;
                break;
            }
            case -14: {
                n3 = 998;
                break;
            }
            case 70: {
                n3 = 1;
                break;
            }
            case 0: {
                n3 = 995;
                break;
            }
            default: {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, Integer.toString(n2));
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return n3;
    }

    ResultSetMetaData getResultSetMetaData() throws SQLException {
        return new OracleResultSetMetaData(this.connection, this, this.offsetOfFirstUserColumn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void describe() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (!this.described) {
                this.doDescribe(false);
            }
        }
    }

    void freeLine() throws SQLException {
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    @Override
    void closeUsedStreams(int n2) throws SQLException {
        while (this.nextStream != null && this.nextStream.columnIndex < n2) {
            try {
                this.nextStream.close();
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.nextStream = this.nextStream.nextStream;
        }
    }

    final void ensureOpen() throws SQLException {
        if (this.connection.lifecycle != 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    void allocateTmpByteArray() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (n2 != 1000) {
                if (n2 == 1001 || n2 == 1002) {
                    this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 87);
                } else {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setFetchDirection");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureOpen();
        return 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.setPrefetchInternal(n2, false, true);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.ensureOpen();
        return this.getPrefetchInternal(true);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.ensureOpen();
        return this.userRsetType.getConcur();
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.ensureOpen();
        return this.userRsetType.getType();
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.ensureOpen();
        return this.connection.getWrapper();
    }

    boolean isOracleBatchStyle() {
        return false;
    }

    void initBatch() {
    }

    int getBatchSize() {
        if (this.m_batchItems == null) {
            return 0;
        }
        return this.m_batchItems.size();
    }

    void addBatchItem(String string) {
        if (this.m_batchItems == null) {
            this.m_batchItems = new Vector();
        }
        this.m_batchItems.addElement(string);
    }

    String getBatchItem(int n2) {
        if (this.m_batchItems == null) {
            return null;
        }
        return (String)this.m_batchItems.elementAt(n2);
    }

    void clearBatchItems() {
        if (this.m_batchItems != null) {
            this.m_batchItems.removeAllElements();
        }
    }

    void checkIfJdbcBatchExists() throws SQLException {
        if (this.getBatchSize() > 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 81, "batch must be either executed or cleared");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.addBatchItem(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.clearBatchItems();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cleanUpBeforeExecute();
            this.cleanOldTempLobs();
            int n2 = 0;
            int n3 = this.getBatchSize();
            this.checkSum = 0L;
            this.checkSumComputationFailure = false;
            if (n3 <= 0) {
                return new int[0];
            }
            int[] nArray = new int[n3];
            this.ensureOpen();
            this.prepareForNewResults(true, true, true);
            int n4 = this.numberOfDefinePositions;
            String string = this.sqlObject.getOriginalSql();
            OracleStatement.SqlKind sqlKind = this.sqlKind;
            this.noMoreUpdateCounts = false;
            int n5 = 0;
            try {
                this.connection.registerHeartbeat();
                this.connection.needLine();
                for (n2 = 0; n2 < n3; ++n2) {
                    this.sqlObject.initialize(this.getBatchItem(n2));
                    this.sqlKind = this.sqlObject.getSqlKind();
                    this.needToParse = true;
                    this.numberOfDefinePositions = 0;
                    this.rowsProcessed = 0;
                    this.currentRank = 1;
                    if (this.sqlKind.isSELECT()) {
                        BatchUpdateException batchUpdateException = DatabaseError.createBatchUpdateException(80, "invalid SELECT batch command " + n2, n2, nArray);
                        batchUpdateException.fillInStackTrace();
                        throw batchUpdateException;
                    }
                    if (!this.isOpen) {
                        this.connection.open(this);
                        this.isOpen = true;
                    }
                    int n6 = -1;
                    try {
                        if (this.queryTimeout != 0) {
                            this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
                        }
                        this.cancelLock.enterExecuting();
                        this.executeForRows(false);
                        if (this.validRows > 0) {
                            n5 += this.validRows;
                        }
                        n6 = this.validRows;
                    }
                    catch (SQLException sQLException) {
                        this.needToParse = true;
                        this.resetCurrentRowBinders();
                        throw sQLException;
                    }
                    finally {
                        if (this.queryTimeout != 0) {
                            this.connection.getTimeout().cancelTimeout();
                        }
                        this.validRows = n5;
                        this.cancelLock.exitExecuting();
                        this.checkValidRowsStatus();
                    }
                    nArray[n2] = n6;
                    if (nArray[n2] >= 0) continue;
                    BatchUpdateException batchUpdateException = DatabaseError.createBatchUpdateException(81, "command return value " + nArray[n2], n2, nArray);
                    batchUpdateException.fillInStackTrace();
                    throw batchUpdateException;
                }
            }
            catch (SQLException sQLException) {
                if (sQLException instanceof BatchUpdateException) {
                    throw sQLException;
                }
                BatchUpdateException batchUpdateException = DatabaseError.createBatchUpdateException(81, sQLException.getMessage(), n2, nArray);
                batchUpdateException.fillInStackTrace();
                throw batchUpdateException;
            }
            finally {
                this.clearBatchItems();
                this.numberOfDefinePositions = n4;
                if (string != null) {
                    this.sqlObject.initialize(string);
                    this.sqlKind = sqlKind;
                }
                this.currentRank = 0;
            }
            this.connection.registerHeartbeat();
            return nArray;
        }
    }

    void copyDefines(OracleStatement oracleStatement, int n2) throws SQLException {
        if (oracleStatement.columnsDefinedByUser) {
            Accessor[] accessorArray = oracleStatement.accessors;
            this.accessors = new Accessor[accessorArray.length];
            for (int i2 = 0; i2 < accessorArray.length; ++i2) {
                if (accessorArray[i2] == null) continue;
                this.accessors[i2] = accessorArray[i2].copyForDefine(this);
                this.accessors[i2].setCapacity(n2);
            }
            this.numberOfDefinePositions = oracleStatement.numberOfDefinePositions;
            this.definedColumnType = oracleStatement.definedColumnType;
            this.definedColumnSize = oracleStatement.definedColumnSize;
            this.definedColumnFormOfUse = oracleStatement.definedColumnFormOfUse;
            this.columnsDefinedByUser = true;
        }
    }

    int copyBinds(Statement statement, int n2) throws SQLException {
        return 0;
    }

    public void notifyCloseRset() throws SQLException {
        this.endOfResultSet(false);
    }

    public String getOriginalSql() throws SQLException {
        return this.sqlObject.getOriginalSql();
    }

    boolean isRowidPrepended() {
        return this.isRowidPrepended;
    }

    void computeOffsetOfFirstUserColumn() {
        this.offsetOfFirstUserColumn = -1;
        if (this.sqlKind.isSELECT()) {
            if (this.isRowidPrepended) {
                ++this.offsetOfFirstUserColumn;
            }
        } else if (this.numReturnParams > 0) {
            this.offsetOfFirstUserColumn = this.numberOfBindPositions - this.numReturnParams - 1;
        }
    }

    void doScrollExecuteCommon() throws SQLException {
        if (!this.sqlKind.isSELECT()) {
            this.doExecuteWithTimeout();
            return;
        }
        boolean bl = (this.realRsetType == OracleResultSet.ResultSetType.UNKNOWN ? this.userRsetType : this.realRsetType).isIdentifierRequired();
        if (!bl) {
            this.doExecuteWithTimeout();
            this.computeOffsetOfFirstUserColumn();
            this.computeNumberOfUserColumns();
            this.currentResultSet = OracleResultSet.createResultSet(this);
            this.realRsetType = this.userRsetType;
            if (this.realRsetType.isScrollable()) {
                this.fetchMode = FetchMode.APPEND;
            }
        } else {
            try {
                this.sqlObject.setIncludeRowid(true);
                this.isRowidPrepended = true;
                this.needToParse = true;
                this.prepareForNewResults(true, false, true);
                if (this.columnsDefinedByUser) {
                    Accessor[] accessorArray = this.accessors;
                    if (this.accessors == null || this.accessors.length <= this.numberOfDefinePositions) {
                        this.accessors = new Accessor[this.numberOfDefinePositions + 1];
                    }
                    if (accessorArray != null) {
                        for (int i2 = this.numberOfDefinePositions; i2 > 0; --i2) {
                            Accessor accessor;
                            this.accessors[i2] = accessor = accessorArray[i2 - 1];
                            if (!accessor.isColumnNumberAware) continue;
                            accessor.updateColumnNumber(i2);
                        }
                    }
                    this.allocateRowidAccessor();
                    ++this.numberOfDefinePositions;
                }
                this.doExecuteWithTimeout();
                this.computeOffsetOfFirstUserColumn();
                this.computeNumberOfUserColumns();
                this.currentResultSet = OracleResultSet.createResultSet(this);
                this.realRsetType = this.userRsetType;
                if (this.realRsetType.isScrollable()) {
                    this.fetchMode = FetchMode.APPEND;
                }
            }
            catch (SQLException sQLException) {
                this.realRsetType = this.userRsetType.downgrade();
                this.fetchMode = this.cachedQueryResult != null ? FetchMode.APPEND : (this.realRsetType.isScrollable() ? FetchMode.APPEND : FetchMode.OVERWRITE);
                this.isRowidPrepended = this.realRsetType.isIdentifierRequired();
                this.sqlObject.setIncludeRowid(this.isRowidPrepended);
                this.needToParse = true;
                this.prepareForNewResults(true, false, true);
                if (this.columnsDefinedByUser) {
                    this.needToPrepareDefineBuffer = true;
                    --this.numberOfDefinePositions;
                    System.arraycopy(this.accessors, 1, this.accessors, 0, this.numberOfDefinePositions);
                    this.accessors[this.numberOfDefinePositions] = null;
                    for (int i3 = 0; i3 < this.numberOfDefinePositions; ++i3) {
                        Accessor accessor = this.accessors[i3];
                        if (!accessor.isColumnNumberAware) continue;
                        accessor.updateColumnNumber(i3);
                    }
                }
                this.moveAllTempLobsToFree();
                this.doExecuteWithTimeout();
                this.computeOffsetOfFirstUserColumn();
                this.computeNumberOfUserColumns();
                this.currentResultSet = OracleResultSet.createResultSet(this);
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 91, sQLException.getMessage());
            }
        }
    }

    void allocateRowidAccessor() throws SQLException {
        this.accessors[0] = new RowidAccessor(this, 128, 1, -8, false);
    }

    OracleResultSet doScrollStmtExecuteQuery() throws SQLException {
        this.doScrollExecuteCommon();
        return this.currentResultSet;
    }

    void processDmlReturningBind() throws SQLException {
        this.returnParamsFetched = false;
        int n2 = 0;
        for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
            if (this.accessors[i2] == null) continue;
            ++n2;
        }
        if (this.isAutoGeneratedKey) {
            this.numReturnParams = n2;
        } else {
            if (this.numReturnParams <= 0) {
                this.numReturnParams = this.sqlObject.getReturnParameterCount();
            }
            if (this.numReturnParams != n2) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 173);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        this.returnParamMeta[0] = this.numReturnParams;
    }

    void allocateDmlReturnStorage() {
    }

    void fetchDmlReturnParams() throws SQLException {
        SQLFeatureNotSupportedException sQLFeatureNotSupportedException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLFeatureNotSupportedException.fillInStackTrace();
        throw sQLFeatureNotSupportedException;
    }

    void registerReturnParameterInternal(int n2, int n3, int n4, int n5, short s2, String string) throws SQLException {
        this.isDmlReturning = true;
        if (this.accessors == null) {
            this.accessors = new Accessor[this.numberOfBindPositions];
        }
        if (this.returnParamMeta == null) {
            this.returnParamMeta = new int[3 + this.numberOfBindPositions * 4];
        }
        switch (n4) {
            case -16: 
            case -15: 
            case -9: 
            case 2011: {
                s2 = (short)2;
                break;
            }
            case 2009: {
                string = "SYS.XMLTYPE";
                break;
            }
        }
        Accessor accessor = this.allocateAccessor(n3, n4, n2 + 1, n5, s2, string, true);
        accessor.isDMLReturnedParam = true;
        accessor.setCapacity(this.currentCapacity);
        this.accessors[n2] = accessor;
        boolean bl = accessor.charLength > 0;
        this.returnParamMeta[3 + n2 * 4 + 0] = accessor.defineType;
        this.returnParamMeta[3 + n2 * 4 + 1] = bl ? 1 : 0;
        this.returnParamMeta[3 + n2 * 4 + 2] = bl ? accessor.charLength : accessor.byteLength;
        this.returnParamMeta[3 + n2 * 4 + 3] = s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int creationState() {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.creationState;
        }
    }

    public boolean isColumnSetNull(int n2) {
        return this.columnSetNull;
    }

    @Override
    public boolean isNCHAR(int n2) throws SQLException {
        int n3;
        if (!this.described) {
            this.describe();
        }
        if ((n3 = n2 - 1) < 0 || n3 >= this.numberOfDefinePositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        boolean bl = this.accessors[n3].formOfUse == 2;
        return bl;
    }

    void addChild(OracleStatement oracleStatement) {
        oracleStatement.nextChild = this.children;
        this.children = oracleStatement;
        oracleStatement.parent = this;
    }

    void addImplicitResultSetStmt(OracleStatement oracleStatement) {
        this.implicitResultSetStatements.add(oracleStatement);
    }

    void removeChild(OracleStatement oracleStatement) {
        if (oracleStatement == this.children) {
            this.children = oracleStatement.nextChild;
        } else {
            OracleStatement oracleStatement2 = this.children;
            while (oracleStatement2.nextChild != oracleStatement) {
                oracleStatement2 = oracleStatement2.nextChild;
            }
            oracleStatement2.nextChild = oracleStatement.nextChild;
        }
        oracleStatement.parent = null;
        oracleStatement.nextChild = null;
    }

    @Override
    public boolean getMoreResults(int n2) throws SQLException {
        Wrapper wrapper;
        this.ensureOpen();
        switch (n2) {
            case 1: {
                if (this.currentResultSet == null || this.currentResultSet.isClosed()) break;
                this.currentResultSet.close();
                break;
            }
            case 2: {
                if (this.currentResultSet == null || this.currentResultSet.isClosed()) break;
                if (this.openImplicitResultSets == null) {
                    this.openImplicitResultSets = new ArrayDeque(this.implicitResultSetStatements.size());
                }
                this.openImplicitResultSets.add(this.currentResultSet);
                this.currentResultSet = null;
                break;
            }
            case 3: {
                while (this.openImplicitResultSets != null && this.openImplicitResultSets.size() != 0) {
                    wrapper = this.openImplicitResultSets.remove();
                    ((OracleResultSet)wrapper).close();
                }
                break;
            }
            default: {
                SQLFeatureNotSupportedException sQLFeatureNotSupportedException = DatabaseError.createUnsupportedFeatureSqlException();
                sQLFeatureNotSupportedException.fillInStackTrace();
                throw sQLFeatureNotSupportedException;
            }
        }
        if (this.implicitResultSetIterator != null && this.implicitResultSetIterator.hasNext() && (wrapper = this.implicitResultSetIterator.next()) != null) {
            ((OracleStatement)wrapper).computeOffsetOfFirstUserColumn();
            ((OracleStatement)wrapper).computeNumberOfUserColumns();
            this.currentResultSet = OracleResultSet.createResultSet((OracleStatement)wrapper);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (!this.isAutoGeneratedKey) {
                ArrayDataResultSet arrayDataResultSet = new ArrayDataResultSet(this.connection, null, null);
                return arrayDataResultSet;
            }
            if (this.accessors == null || this.numReturnParams == 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 144);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.currentResultSet == null) {
                this.isAllFetched = true;
                this.currentResultSet = new OracleReturnResultSet(this.connection, this);
                this.computeOffsetOfFirstUserColumn();
                this.computeNumberOfUserColumns();
            }
            return this.currentResultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, int n2) throws SQLException {
        this.cleanUpBeforeExecute();
        this.autoKeyInfo = new AutoKeyInfo(string);
        if (n2 == 2 || !this.autoKeyInfo.isInsertSqlStmt()) {
            this.autoKeyInfo = null;
            return this.executeUpdate(string);
        }
        if (n2 != 1) {
            this.autoKeyInfo = null;
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.isAutoGeneratedKey = true;
            String string2 = this.autoKeyInfo.getNewSql();
            this.numberOfBindPositions = 1;
            this.autoKeyRegisterReturnParams();
            this.processDmlReturningBind();
            return this.executeUpdateInternal(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.cleanUpBeforeExecute();
        if (nArray == null || nArray.length == 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.autoKeyInfo = new AutoKeyInfo(string, nArray);
        if (!this.autoKeyInfo.isInsertSqlStmt()) {
            this.autoKeyInfo = null;
            return this.executeUpdate(string);
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.isAutoGeneratedKey = true;
            this.connection.doDescribeTable(this.autoKeyInfo);
            String string2 = this.autoKeyInfo.getNewSql();
            this.numberOfBindPositions = nArray.length;
            this.autoKeyRegisterReturnParams();
            this.processDmlReturningBind();
            return this.executeUpdateInternal(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.cleanUpBeforeExecute();
        if (stringArray == null || stringArray.length == 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.autoKeyInfo = new AutoKeyInfo(string, stringArray);
        if (!this.autoKeyInfo.isInsertSqlStmt()) {
            this.autoKeyInfo = null;
            return this.executeUpdate(string);
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.isAutoGeneratedKey = true;
            this.connection.doDescribeTable(this.autoKeyInfo);
            String string2 = this.autoKeyInfo.getNewSql();
            this.numberOfBindPositions = stringArray.length;
            this.autoKeyRegisterReturnParams();
            this.processDmlReturningBind();
            return this.executeUpdateInternal(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, int n2) throws SQLException {
        this.cleanUpBeforeExecute();
        this.autoKeyInfo = new AutoKeyInfo(string);
        if (n2 == 2 || !this.autoKeyInfo.isInsertSqlStmt()) {
            this.autoKeyInfo = null;
            return this.execute(string);
        }
        if (n2 != 1) {
            this.autoKeyInfo = null;
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.isAutoGeneratedKey = true;
            String string2 = this.autoKeyInfo.getNewSql();
            this.numberOfBindPositions = 1;
            this.autoKeyRegisterReturnParams();
            this.processDmlReturningBind();
            return this.executeInternal(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        this.cleanUpBeforeExecute();
        if (nArray == null || nArray.length == 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.autoKeyInfo = new AutoKeyInfo(string, nArray);
        if (!this.autoKeyInfo.isInsertSqlStmt()) {
            this.autoKeyInfo = null;
            return this.execute(string);
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.isAutoGeneratedKey = true;
            this.connection.doDescribeTable(this.autoKeyInfo);
            String string2 = this.autoKeyInfo.getNewSql();
            this.numberOfBindPositions = nArray.length;
            this.autoKeyRegisterReturnParams();
            this.processDmlReturningBind();
            return this.executeInternal(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.cleanUpBeforeExecute();
        if (stringArray == null || stringArray.length == 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.autoKeyInfo = new AutoKeyInfo(string, stringArray);
        if (!this.autoKeyInfo.isInsertSqlStmt()) {
            this.autoKeyInfo = null;
            return this.execute(string);
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.isAutoGeneratedKey = true;
            this.connection.doDescribeTable(this.autoKeyInfo);
            String string2 = this.autoKeyInfo.getNewSql();
            this.numberOfBindPositions = stringArray.length;
            this.autoKeyRegisterReturnParams();
            this.processDmlReturningBind();
            return this.executeInternal(string2);
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.ensureOpen();
        return 1;
    }

    @Override
    public int getcacheState() {
        return this.cacheState;
    }

    @Override
    public int getstatementType() {
        return this.statementType;
    }

    @Override
    public boolean getserverCursor() {
        return this.serverCursor;
    }

    void initializeIndicatorSubRange() {
        this.bindIndicatorSubRange = 0;
    }

    private void autoKeyRegisterReturnParams() throws SQLException {
        if (this.currentResultSet != null) {
            this.currentResultSet.close();
        }
        this.initializeIndicatorSubRange();
        int n2 = this.bindIndicatorSubRange + 5 + this.numberOfBindPositions * 10;
        int n3 = n2 + 2 * this.numberOfBindPositions;
        this.bindIndicators = new short[n3];
        int n4 = this.bindIndicatorSubRange;
        this.bindIndicators[n4 + 0] = (short)this.numberOfBindPositions;
        this.bindIndicators[n4 + 1] = 0;
        this.bindIndicators[n4 + 2] = 1;
        this.bindIndicators[n4 + 3] = 0;
        this.bindIndicators[n4 + 4] = 1;
        n4 += 5;
        short[] sArray = this.autoKeyInfo.tableFormOfUses;
        int[] nArray = this.autoKeyInfo.columnIndexes;
        for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
            short s2;
            this.bindIndicators[n4 + 0] = 994;
            short s3 = s2 = this.connection.defaultnchar ? (short)2 : 1;
            if (sArray != null && nArray != null && sArray[nArray[i2] - 1] == 2) {
                this.bindIndicators[n4 + 9] = s2 = 2;
            }
            n4 += 10;
            this.checkTypeForAutoKey(this.autoKeyInfo.returnTypes[i2]);
            String string = null;
            if (this.autoKeyInfo.returnTypes[i2] == 111) {
                string = this.autoKeyInfo.tableTypeNames[nArray[i2] - 1];
            }
            this.registerReturnParameterInternal(i2, this.autoKeyInfo.returnTypes[i2], this.autoKeyInfo.returnTypes[i2], -1, s2, string);
        }
    }

    private final void cleanUpBeforeExecute() throws SQLException {
        if (this.currentResultSet != null && this.isCloseOnCompletion) {
            this.currentResultSet.close();
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.isAutoGeneratedKey = false;
        this.numberOfBindPositions = 0;
        this.bindIndicators = null;
        this.returnParamMeta = null;
        if (this.executeDoneForDefines) {
            this.clearDefines();
        } else {
            this.executeDoneForDefines = true;
        }
    }

    final void checkTypeForAutoKey(int n2) throws SQLException {
        if (n2 == 109) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 5);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    void moveAllTempLobsToFree() {
        if (this.oldTempClobsToFree != null) {
            if (this.tempClobsToFree == null) {
                this.tempClobsToFree = this.oldTempClobsToFree;
            } else {
                this.tempClobsToFree.add(this.oldTempClobsToFree);
            }
            this.oldTempClobsToFree = null;
        }
        if (this.oldTempBlobsToFree != null) {
            if (this.tempBlobsToFree == null) {
                this.tempBlobsToFree = this.oldTempBlobsToFree;
            } else {
                this.tempBlobsToFree.add(this.oldTempBlobsToFree);
            }
            this.oldTempBlobsToFree = null;
        }
    }

    void moveTempLobsToFree(CLOB cLOB) {
        int n2;
        if (this.oldTempClobsToFree != null && (n2 = this.oldTempClobsToFree.indexOf(cLOB)) != -1) {
            this.addToTempLobsToFree(cLOB);
            this.oldTempClobsToFree.remove(n2);
        }
    }

    void moveTempLobsToFree(BLOB bLOB) {
        int n2;
        if (this.oldTempBlobsToFree != null && (n2 = this.oldTempBlobsToFree.indexOf(bLOB)) != -1) {
            this.addToTempLobsToFree(bLOB);
            this.oldTempBlobsToFree.remove(n2);
        }
    }

    void addToTempLobsToFree(CLOB cLOB) {
        if (this.tempClobsToFree == null) {
            this.tempClobsToFree = new ArrayList();
        }
        this.tempClobsToFree.add(cLOB);
    }

    void addToTempLobsToFree(BLOB bLOB) {
        if (this.tempBlobsToFree == null) {
            this.tempBlobsToFree = new ArrayList();
        }
        this.tempBlobsToFree.add(bLOB);
    }

    void addToOldTempLobsToFree(CLOB cLOB) {
        if (this.oldTempClobsToFree == null) {
            this.oldTempClobsToFree = new ArrayList();
        }
        this.oldTempClobsToFree.add(cLOB);
    }

    void addToOldTempLobsToFree(BLOB bLOB) {
        if (this.oldTempBlobsToFree == null) {
            this.oldTempBlobsToFree = new ArrayList();
        }
        this.oldTempBlobsToFree.add(bLOB);
    }

    void cleanAllTempLobs() {
        this.cleanTempClobs(this.tempClobsToFree);
        this.tempClobsToFree = null;
        this.cleanTempBlobs(this.tempBlobsToFree);
        this.tempBlobsToFree = null;
        this.cleanTempClobs(this.oldTempClobsToFree);
        this.oldTempClobsToFree = null;
        this.cleanTempBlobs(this.oldTempBlobsToFree);
        this.oldTempBlobsToFree = null;
    }

    void cleanOldTempLobs() {
        this.cleanTempClobs(this.oldTempClobsToFree);
        this.cleanTempBlobs(this.oldTempBlobsToFree);
        this.oldTempClobsToFree = this.tempClobsToFree;
        this.tempClobsToFree = null;
        this.oldTempBlobsToFree = this.tempBlobsToFree;
        this.tempBlobsToFree = null;
    }

    void cleanTempClobs(ArrayList arrayList) {
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                try {
                    ((CLOB)iterator.next()).freeTemporary();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    void cleanTempBlobs(ArrayList arrayList) {
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                try {
                    ((BLOB)iterator.next()).freeTemporary();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    TimeZone getDefaultTimeZone() throws SQLException {
        return this.getDefaultTimeZone(false);
    }

    TimeZone getDefaultTimeZone(boolean bl) throws SQLException {
        if (this.defaultTimeZone == null) {
            try {
                this.defaultTimeZone = this.connection.getDefaultTimeZone();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (this.defaultTimeZone == null) {
                this.defaultTimeZone = TimeZone.getDefault();
            }
        }
        return this.defaultTimeZone;
    }

    @Override
    public void setDatabaseChangeRegistration(DatabaseChangeRegistration databaseChangeRegistration) throws SQLException {
        this.registration = (NTFDCNRegistration)databaseChangeRegistration;
    }

    @Override
    public String[] getRegisteredTableNames() throws SQLException {
        return this.dcnTableName;
    }

    @Override
    public long getRegisteredQueryId() throws SQLException {
        return this.dcnQueryId;
    }

    Calendar getDefaultCalendar() throws SQLException {
        if (this.defaultCalendar == null) {
            this.defaultCalendar = Calendar.getInstance(this.getDefaultTimeZone(), Locale.US);
        }
        return this.defaultCalendar;
    }

    void releaseBuffers() {
        this.rowData.free();
        if (this.bindData != null && this.bindData != this.rowData) {
            this.bindData.free();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.cacheState != 3;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.cacheState = bl ? 1 : 3;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (clazz.isInterface()) {
            return clazz.isInstance(this);
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInterface() && clazz.isInstance(this)) {
            return (T)this;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    <T> T getObject(int n2, int n3, Class<T> clazz) throws SQLException {
        this.lastIndex = n3;
        if (this.streamList != null) {
            this.closeUsedStreams(n3);
        }
        return this.accessors[n3 + this.offsetOfFirstUserColumn].getObject(n2 - this.indexOfFirstRow, clazz);
    }

    RowId getPrependedRowId(int n2) throws SQLException {
        assert (this.isRowidPrepended) : "no rowid";
        return this.accessors[0].getROWID(n2 - this.indexOfFirstRow);
    }

    OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int n2, int n3) throws SQLException {
        this.lastIndex = n3;
        if (this.streamList != null) {
            this.closeUsedStreams(n3);
        }
        return this.accessors[n3 - 1].getAuthorizationIndicator(n2 - this.indexOfFirstRow);
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    Calendar getGMTCalendar() {
        if (this.gmtCalendar == null) {
            this.gmtCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
        }
        return this.gmtCalendar;
    }

    void extractNioDefineBuffers(int n2) throws SQLException {
    }

    void processLobPrefetchMetaData(Object[] objectArray) {
    }

    void internalClose() throws SQLException {
        this.closed = true;
        if (this.currentResultSet != null) {
            this.currentResultSet.closed = true;
        }
        this.cleanupDefines();
        this.bindBytes = null;
        this.bindChars = null;
        this.bindIndicators = null;
        this.outBindAccessors = null;
        this.parameterStream = null;
        this.userStream = null;
        this.ibtBindBytes = null;
        this.ibtBindChars = null;
        this.ibtBindIndicators = null;
        this.lobPrefetchMetaData = null;
        this.tmpByteArray = null;
        this.definedColumnType = null;
        this.definedColumnSize = null;
        this.definedColumnFormOfUse = null;
        if (this.wrapper != null) {
            this.wrapper.close();
        }
    }

    void calculateCheckSum() throws SQLException {
        if (!this.connection.checksumMode.needToCalculateFetchChecksum()) {
            return;
        }
        this.localCheckSum = this.checkSum;
        if (this.accessors != null && !this.isDmlReturning) {
            this.accessorChecksum(this.accessors);
        }
        if (this.outBindAccessors != null) {
            this.accessorChecksum(this.outBindAccessors);
        }
        if (this.accessors != null && this.returnParamsFetched && this.isDmlReturning) {
            this.accessorChecksum(this.accessors);
        }
        this.checkSum = this.localCheckSum = CRC64.updateChecksum(this.localCheckSum, this.validRows);
        this.localCheckSum = 0L;
    }

    void accessorChecksum(Accessor[] accessorArray) throws SQLException {
        int n2 = 0;
        boolean bl = false;
        block4: for (Accessor accessor : accessorArray) {
            if (accessor == null) continue;
            switch (accessor.internalType) {
                case 112: 
                case 113: 
                case 114: {
                    if (n2 != 0) continue block4;
                    bl = true;
                    continue block4;
                }
                case 8: 
                case 24: {
                    bl = false;
                    break block4;
                }
                default: {
                    bl = false;
                    ++n2;
                    for (int i2 = 0; i2 < this.validRows; ++i2) {
                        this.localCheckSum = accessor.updateChecksum(this.localCheckSum, i2);
                    }
                }
            }
        }
        if (bl) {
            this.checkSumComputationFailure = true;
        }
    }

    @Override
    public long getChecksum() throws SQLException {
        if (this.checkSumComputationFailure) {
            SQLFeatureNotSupportedException sQLFeatureNotSupportedException = DatabaseError.createUnsupportedFeatureSqlException();
            sQLFeatureNotSupportedException.fillInStackTrace();
            throw sQLFeatureNotSupportedException;
        }
        return this.checkSum;
    }

    @Override
    public void registerBindChecksumListener(OracleStatement.BindChecksumListener bindChecksumListener) throws SQLException {
        this.bindChecksumListener = bindChecksumListener;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.ensureOpen();
        this.isCloseOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.ensureOpen();
        return this.isCloseOnCompletion;
    }

    boolean closeByDependent() throws SQLException {
        if (this.isCloseOnCompletion && (this.currentResultSet == null || this.currentResultSet.isComplete())) {
            if (this.parent == null || !this.parent.closeByDependent()) {
                this.close();
            }
            return true;
        }
        return false;
    }

    @Override
    public void setACProxy(Object object) {
        this.acProxy = object;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }

    @Override
    public final long getQueryId() throws SQLException {
        return this.queryId;
    }

    @Override
    public final byte[] getCompileKey() throws SQLException {
        return this.querycacheCompileKey;
    }

    final void setQueryCompileKey(byte[] byArray) {
        if (this.connection.isResultSetCacheEnabled && byArray != null) {
            this.querycacheCompileKey = byArray;
        }
    }

    final void setQueryId(long l2) {
        this.queryId = l2;
    }

    byte[] getRuntimeKey() throws SQLException {
        return null;
    }

    static enum QueryCacheState {
        UNKNOWN,
        CACHEABLE,
        UNCACHEABLE;

    }

    static enum FetchMode {
        OVERWRITE,
        APPEND;

    }
}

