/*
 * Decompiled with CFR 0.152.
 */
package ice.util.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ReaderUTF8
extends Reader {
    private InputStream is;
    private byte[] buffer;
    private int cursor;
    private int bufferEnd;
    public static final int LONGEST_UTF8_CHAR_BYTES_LENGTH = 6;
    public static final int BROKEN_UTF8_CHAR_MARK = 63;
    public static final int NONJAVA_CHAR_MARK = 191;
    private boolean throwOnBadUTF8;

    public ReaderUTF8(InputStream is) {
        this(is, 4096);
    }

    public ReaderUTF8(InputStream is, int decodingBufferSize) {
        this.is = is;
        this.buffer = new byte[decodingBufferSize];
        this.setThrowOnBadUTF8(true);
    }

    public boolean isThrowOnBadUTF8() {
        return this.throwOnBadUTF8;
    }

    public void setThrowOnBadUTF8(boolean value) {
        this.throwOnBadUTF8 = value;
    }

    public boolean ready() {
        int in_buffer = this.bufferEnd - this.cursor;
        if (6 <= in_buffer) {
            return true;
        }
        try {
            if (this.is.available() >= 6 - in_buffer) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public int read() throws IOException {
        int firstByte;
        if (this.cursor == this.bufferEnd && !this.fillBuffer()) {
            return -1;
        }
        return (firstByte = this.buffer[this.cursor++]) >= 0 ? firstByte : this.readCharTail(firstByte);
    }

    public int read(char[] array, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        if (this.cursor == this.bufferEnd && !this.fillBuffer()) {
            return -1;
        }
        int orig_offset = offset;
        int arrayEnd = offset + length;
        do {
            int firstByte;
            int c = (firstByte = this.buffer[this.cursor++]) >= 0 ? firstByte : this.readCharTail(firstByte);
            array[offset++] = (char)c;
        } while (offset != arrayEnd && this.cursor != this.bufferEnd);
        return offset - orig_offset;
    }

    public long skip(long length) throws IOException {
        if (length == 0L) {
            return 0L;
        }
        if (this.cursor == this.bufferEnd && !this.fillBuffer()) {
            return -1L;
        }
        long orig_length = length;
        do {
            byte firstByte;
            if ((firstByte = this.buffer[this.cursor++]) >= 0) continue;
            this.readCharTail(firstByte);
        } while (--length != 0L && this.cursor != this.bufferEnd);
        return orig_length - length;
    }

    public void close() throws IOException {
        this.is.close();
    }

    private boolean fillBuffer() throws IOException {
        int n = this.is.read(this.buffer, 0, this.buffer.length);
        if (n < 0) {
            return false;
        }
        this.cursor = 0;
        this.bufferEnd = n;
        return true;
    }

    private final int readCharTail(int firstByte) throws IOException {
        int minumum_value;
        int c;
        int utf8_tail;
        if ((0xC0 & firstByte) != 192) {
            return this.onBadBytes();
        }
        if ((0x20 & firstByte) == 0) {
            utf8_tail = 1;
            c = 0x1F & firstByte;
            minumum_value = 128;
        } else if ((0x10 & firstByte) == 0) {
            utf8_tail = 2;
            c = 0xF & firstByte;
            minumum_value = 2048;
        } else if ((8 & firstByte) == 0) {
            utf8_tail = 3;
            c = 7 & firstByte;
            minumum_value = 65536;
        } else if ((4 & firstByte) == 0) {
            utf8_tail = 4;
            c = 3 & firstByte;
            minumum_value = 0x200000;
        } else if ((2 & firstByte) == 0) {
            utf8_tail = 5;
            c = 1 & firstByte;
            minumum_value = 0x4000000;
        } else {
            return this.onBadBytes();
        }
        do {
            byte b;
            if (this.cursor == this.bufferEnd && !this.fillBuffer()) {
                return this.onUnexpectedEof(c, utf8_tail, minumum_value);
            }
            if (((b = this.buffer[this.cursor++]) & 0xC0) != 128) {
                --this.cursor;
                return this.onBadBytes();
            }
            c = c << 6 | 0x3F & b;
        } while (--utf8_tail != 0);
        if (c < minumum_value) {
            c = this.onBadBytes();
        } else if (c > 65535) {
            c = this.onNonJavaChar(c);
        }
        return c;
    }

    private int onBadBytes() throws IOException {
        if (this.throwOnBadUTF8) {
            throw new IOException("Bad UTF-8 bytes");
        }
        return 63;
    }

    private int onUnexpectedEof(int c, int utf8_tail, int minumum_value) throws IOException {
        return this.onBadBytes();
    }

    private int onNonJavaChar(int c) throws IOException {
        return 191;
    }
}

