/*
 * Decompiled with CFR 0.152.
 */
package ice.scripters.js;

import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.Function;
import ice.mozilla.javascript.JavaScriptException;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.Wrapper;
import ice.scripters.js.TheScripter;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.util.Defs;

class JS_Dynamic
implements Scriptable,
Wrapper,
Function {
    private DynamicObject dynamic;
    private TheScripter scripter;
    private Scriptable prototype;
    private Scriptable parent;

    JS_Dynamic(DynamicObject dynamic_arg, TheScripter scripter_arg) {
        this.dynamic = dynamic_arg;
        this.scripter = scripter_arg;
    }

    static boolean shouldAbsent(String name) {
        if (name.length() == 8) {
            return "Function".equals(name);
        }
        return false;
    }

    private static boolean hasFieldOrSlot(DynamicObject dynamic, String name, TheScripter scripter) {
        if (Defs.NOT_FOUND != dynamic.getDynamicValue(name, scripter.env)) {
            return true;
        }
        return dynamic.hasSlot(name, (DynEnv)scripter.env);
    }

    public boolean has(String name, Scriptable start) {
        if (JS_Dynamic.shouldAbsent(name)) {
            return false;
        }
        return JS_Dynamic.hasFieldOrSlot(this.dynamic, name, this.scripter);
    }

    public boolean has(int index, Scriptable start) {
        return this.dynamic.hasSlot(index, (DynEnv)this.scripter.env);
    }

    public Object get(String name, Scriptable start) {
        if (JS_Dynamic.shouldAbsent(name)) {
            return Scriptable.NOT_FOUND;
        }
        Object result = this.scripter.queryField(this, this.dynamic, name);
        if (result == Scriptable.NOT_FOUND) {
            result = this.scripter.querySlot((Scriptable)this, this.dynamic, name);
        }
        return result;
    }

    public Object get(int index, Scriptable start) {
        Object result = this.scripter.querySlot((Scriptable)this, this.dynamic, index);
        return result;
    }

    public void put(String name, Scriptable start, Object value) {
        int set_status = this.dynamic.setDynamicValue(name, value, this.scripter.env);
        if (set_status == 0) {
            boolean done = false;
            if (this != start && !this.dynamic.hasSlot(name, (DynEnv)this.scripter.env)) {
                start.put(name, start, value);
                done = true;
            }
            if (!done) {
                this.dynamic.setSlot(name, value, (DynEnv)this.scripter.env);
            }
        }
    }

    public void put(int index, Scriptable start, Object value) {
        boolean done = false;
        if (this != start && !this.has(index, (Scriptable)this)) {
            start.put(index, start, value);
            done = true;
        }
        if (!done) {
            this.dynamic.setSlot(index, value, (DynEnv)this.scripter.env);
        }
    }

    public boolean hasInstance(Scriptable value) {
        return false;
    }

    public void delete(String name) {
        DynamicObject current = this.dynamic;
        if (current != null) {
            current.setDynamicValue(name, null, this.scripter.env);
            current.deleteSlot(name);
        }
    }

    public void delete(int index) {
        DynamicObject current = this.dynamic;
        if (current != null) {
            current.deleteSlot(index);
        }
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    public void setPrototype(Scriptable object) {
        this.prototype = object;
    }

    public Scriptable getParentScope() {
        if (this.parent == null) {
            this.parent = this.scripter.findScopeObject(this.dynamic);
        }
        return this.parent;
    }

    public void setParentScope(Scriptable object) {
        this.parent = object;
    }

    public Object[] getIds() {
        DynamicObject current = this.dynamic;
        if (current == null) {
            return Defs.EMPTY_OBJECT_ARRAY;
        }
        return current.getEnumeratableIds(this.scripter.env, 0);
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (args.length == 1) {
            return ScriptRuntime.getElem(this, args[0], scope);
        }
        throw TheScripter.notAFunction(this);
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) throws JavaScriptException {
        throw TheScripter.notAFunction(this);
    }

    public Object unwrap() {
        return this.dynamic;
    }

    public String getClassName() {
        return "JavaObject";
    }

    public Object getDefaultValue(Class hint) {
        if (hint == null || hint == ScriptRuntime.StringClass) {
            return this.toString();
        }
        if (hint == ScriptRuntime.BooleanClass && this.dynamic != null) {
            return Boolean.TRUE;
        }
        return "";
    }

    public String toString() {
        return this.dynamic.script_toString(this.scripter.env);
    }
}

