/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.net.URL;
import java.util.Stack;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.QxName;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLTContext;
import oracle.xml.xslt.XSLTDebuggerTraceEventVars;

public class XSLTDebuggerTraceEvent {
    private XSLNode xslnd;
    private XSLTContext context;
    private QxName qxname;

    protected XSLTDebuggerTraceEvent(XSLNode xSLNode, XSLTContext xSLTContext, String string) {
        this.xslnd = xSLNode;
        this.context = xSLTContext;
        this.qxname = this.convertIName2QxName(string);
    }

    void setContext(XSLTContext xSLTContext) {
        this.context = xSLTContext;
    }

    private QxName convertIName2QxName(String string) {
        QxName qxName;
        int n = string.indexOf(58);
        if (n == -1) {
            qxName = new QxName("", string, "", string);
        } else {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            qxName = new QxName("http://www.w3.org/1999/XSL/Transform", string3, string2, string);
        }
        return qxName;
    }

    public XSLTDebuggerTraceEventVars getCurrentVar() {
        return this.context.getOSBDebugCurrentVar();
    }

    public Stack<XSLTDebuggerTraceEventVars> getCurrentVarsInScope(int n) {
        return this.context.getOSBDebugInScopeVars(this.xslnd, n);
    }

    public Stack<XSLTDebuggerTraceEventVars> getCurrentVarsInScope() {
        return this.context.getOSBDebugInScopeVars(this.xslnd, -1);
    }

    public void setFlushIncreamentalOutputFlag(boolean bl) {
        this.xslnd.setFlushIncreamentalOutputFlag(bl);
    }

    public boolean getFlushIncreamentalOutputFlag() {
        return this.xslnd.getFlushIncreamentalOutputFlag();
    }

    public int[] getXSLNodePath() {
        return this.xslnd.getPath4OSBDebugger();
    }

    public int getLineNumber() {
        return this.xslnd.getLineNumber();
    }

    public int getColumnNumber() {
        return this.xslnd.getColumnNumber();
    }

    public QxName getQualifiedName() {
        return this.qxname;
    }

    public OXMLItem getContextItem() {
        return this.context.getContextItem();
    }

    public URL getBaseURL() {
        return this.xslnd.getBaseURL();
    }

    public XMLNode getContextNode() throws XSLException {
        return this.context.getContextNode();
    }

    public XMLNode getCurrentNode() {
        return this.context.getCurrentNode();
    }

    public int getContextSize() {
        return this.context.getContextSize();
    }

    public int getContextPosition() {
        return this.context.getContextPosition();
    }
}

