/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.access;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.capture.OnlineCapturer;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.plugin.access.MSAccessOnlineCapturer;

public class MSAccessThirdPartyProvider
extends ThirdPartyDbProvider {
    private static final String SIG_DBQ = "DBQ=";

    public MSAccessThirdPartyProvider(Connection connection) {
        super(connection);
    }

    public OnlineCapturer getCapturer(MigrationStorer migrationStorer) {
        String string = MSAccessThirdPartyProvider.getMDBFileFromConnection(this.getConnection());
        MSAccessOnlineCapturer mSAccessOnlineCapturer = new MSAccessOnlineCapturer(migrationStorer, this.getConnection(), string);
        return mSAccessOnlineCapturer;
    }

    public String getConnectionLabel() {
        return MSAccessThirdPartyProvider.getMDBFileFromConnection(this.getConnection());
    }

    public static String getMDBFileFromConnection(Connection connection) {
        String[] stringArray;
        if (!connection.getClass().getName().equals("sun.jdbc.odbc.JdbcOdbcConnection")) {
            return null;
        }
        String string = null;
        try {
            stringArray = connection.getClass().getMethod("getURL", null);
            Object object = stringArray.invoke((Object)connection, null);
            string = object.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(MSAccessThirdPartyProvider.class.getClass().getName()).log(Level.WARNING, illegalArgumentException.getStackTrace()[0].toString(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(MSAccessThirdPartyProvider.class.getClass().getName()).log(Level.WARNING, illegalAccessException.getStackTrace()[0].toString(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger(MSAccessThirdPartyProvider.class.getClass().getName()).log(Level.WARNING, invocationTargetException.getStackTrace()[0].toString(), invocationTargetException);
        }
        catch (SecurityException securityException) {
            Logger.getLogger(MSAccessThirdPartyProvider.class.getClass().getName()).log(Level.WARNING, securityException.getStackTrace()[0].toString(), securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Logger.getLogger(MSAccessThirdPartyProvider.class.getClass().getName()).log(Level.WARNING, noSuchMethodException.getStackTrace()[0].toString(), noSuchMethodException);
        }
        stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(SIG_DBQ)) continue;
            String string2 = stringArray[i].substring(SIG_DBQ.length());
            return string2.replace('/', '\\');
        }
        return null;
    }
}

