/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.schemabrowser;

import java.awt.Component;
import java.io.IOException;
import java.sql.Connection;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.WrappedException;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.impl.CatalogFolder;
import oracle.dbtools.raptor.navigator.model.ExceptionDialogRunnable;
import oracle.dbtools.raptor.schemabrowser.SchemaBrowserResources;
import oracle.dbtools.raptor.schemabrowser.view.SBWindow;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.model.Element;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public class SBController
implements Controller {
    public static final String SHOW_ACTION_CMD = "SchemaBrowser.SHOW_BROWSER";
    static final int SHOW_ACTION_ID = Ide.findOrCreateCmdID((String)"SchemaBrowser.SHOW_BROWSER");

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        int n = ideAction.getCommandId();
        if (n == SHOW_ACTION_ID) {
            DatabaseConnection databaseConnection;
            Element element = context.getElement();
            if (element instanceof DatabaseConnection) {
                databaseConnection = (DatabaseConnection)element;
                try {
                    Connection connection = (Connection)databaseConnection.getConnection();
                    ObjectFactory objectFactory = ObjectFactory.getFactory((String)databaseConnection.getQualifiedConnectionName(), (Connection)connection);
                    if (objectFactory.isSupportsCatalog()) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)SchemaBrowserResources.getString("ERROR_NOT_SUPPORTED_CATALOGS"), (String)SchemaBrowserResources.getString("TITLE_NOT_SUPPORTED"), null);
                        return true;
                    }
                }
                catch (IOException iOException) {
                    Throwable throwable = iOException;
                    if (iOException instanceof WrappedException) {
                        throwable = iOException.getCause();
                    }
                    Throwable throwable2 = throwable;
                    while (throwable instanceof DBException) {
                        if ((throwable = throwable.getCause()) == null) continue;
                        throwable2 = throwable;
                    }
                    if (!(throwable2 instanceof ConnectionCanceledException)) {
                        ExceptionDialogRunnable exceptionDialogRunnable = new ExceptionDialogRunnable(DatabaseNavigatorResources.getString((String)"ERROR_OPENING"), throwable2);
                        if (SwingUtilities.isEventDispatchThread()) {
                            exceptionDialogRunnable.run();
                        } else {
                            try {
                                SwingUtilities.invokeAndWait((Runnable)exceptionDialogRunnable);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    return true;
                }
            }
            databaseConnection = this.createInitialBrowserContext(context);
            this.showBrowser((Context)databaseConnection);
            bl = true;
        }
        return bl;
    }

    private void showBrowser(Context context) {
        String string = (String)context.getProperty("SchemaBrowser.Connection");
        DockStation dockStation = DockStation.getDockStation();
        SBWindow sBWindow = SBWindow.findBrowser(string);
        sBWindow.setContext(context);
        dockStation.setDockableVisible((Dockable)sBWindow, true);
        dockStation.activateDockable((Dockable)sBWindow);
    }

    private Context createInitialBrowserContext(Context context) {
        Context context2 = new Context();
        Element element = context.getElement();
        String string = null;
        String string2 = null;
        if (element instanceof DatabaseConnection) {
            string = ((DatabaseConnection)element).getQualifiedConnectionName();
        } else if (element instanceof CatalogFolder) {
            CatalogFolder catalogFolder = (CatalogFolder)element;
            string = (String)catalogFolder.getProperty("ConnectionName");
            string2 = (String)catalogFolder.getProperty("CATALOG");
        }
        context2.setProperty("SchemaBrowser.Connection", (Object)string);
        context2.setProperty("SchemaBrowser.CATALOG", string2);
        return context2;
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        int n = ideAction.getCommandId();
        if (n == SHOW_ACTION_ID) {
            bl = true;
            boolean bl2 = false;
            Element element = context.getElement();
            if (element instanceof DatabaseConnection) {
                DatabaseConnection databaseConnection = (DatabaseConnection)element;
                if (databaseConnection.isConnectionOpen()) {
                    String string = databaseConnection.getQualifiedConnectionName();
                    try {
                        ObjectFactory objectFactory = ObjectFactory.getFactory((String)string, (Connection)((Connection)databaseConnection.getConnection()));
                        bl2 = !objectFactory.isSupportsCatalog();
                    }
                    catch (IOException iOException) {
                        ExceptionHandler.handleException((Exception)iOException, (String)string);
                    }
                } else {
                    bl2 = true;
                }
            } else if (element instanceof CatalogFolder) {
                bl2 = true;
            }
            ideAction.setEnabled(bl2);
        }
        return bl;
    }
}

