/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.triggers;

import org.jdesktop.animation.timing.TimingController;
import org.jdesktop.animation.timing.TimingEvent;
import org.jdesktop.animation.timing.TimingListener;
import org.jdesktop.animation.timing.triggers.TimingTriggerEvent;
import org.jdesktop.animation.timing.triggers.Trigger;
import org.jdesktop.animation.timing.triggers.TriggerEvent;
import org.jdesktop.animation.timing.triggers.TriggerListener;

public class TimingTrigger
extends Trigger {
    public TimingTrigger(TimingController timer, TimingController source, Trigger.TriggerAction action, TimingTriggerEvent event) {
        this.setupListener(timer, source, action, event);
    }

    public TimingTrigger(TimingController startTimer, TimingController source, TimingTriggerEvent event, TimingController stopTimer) {
        super(startTimer, source, event, stopTimer);
    }

    protected void setupListener(TimingController timer, Object source, Trigger.TriggerAction action, TriggerEvent event) {
        try {
            TimingTriggerListener listener = new TimingTriggerListener(timer, action, (TimingTriggerEvent)event);
            this.setupListener(source, listener, "addTimingListener", TimingListener.class);
        }
        catch (Exception e) {
            System.out.println("Exception creating timing listener for object " + source + ": " + e);
        }
    }

    class TimingTriggerListener
    extends TriggerListener
    implements TimingListener {
        TimingTriggerEvent event;

        protected TimingTriggerListener(TimingController timer, Trigger.TriggerAction action, TimingTriggerEvent event) {
            super(timer, action);
            this.event = event;
        }

        public void timerStarted(TimingEvent e) {
            if (this.event == TimingTriggerEvent.START) {
                this.pullTrigger();
            }
        }

        public void timerStopped(TimingEvent e) {
            if (this.event == TimingTriggerEvent.STOP) {
                this.pullTrigger();
            }
        }

        public void timerRepeated(TimingEvent e) {
            if (this.event == TimingTriggerEvent.REPEAT) {
                this.pullTrigger();
            }
        }
    }
}

