/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.interpolation;

import java.lang.reflect.Method;
import org.jdesktop.animation.timing.interpolation.KeySplines;
import org.jdesktop.animation.timing.interpolation.KeyTimes;
import org.jdesktop.animation.timing.interpolation.KeyValues;

public class KeyFrames {
    private KeyValues keyValues;
    private KeyTimes keyTimes;
    private KeySplines keySplines;
    private InterpolationType interpolationType;

    public KeyFrames(KeyValues keyValues) {
        this.init(keyValues, null, null, InterpolationType.LINEAR);
    }

    public KeyFrames(KeyValues keyValues, InterpolationType interpolationType) {
        this.init(keyValues, null, null, interpolationType);
    }

    public KeyFrames(KeyValues keyValues, KeyTimes keyTimes, InterpolationType interpolationType) {
        this.init(keyValues, null, keyTimes, interpolationType);
    }

    public KeyFrames(KeyValues keyValues, KeySplines keySplines, KeyTimes keyTimes, InterpolationType interpolationType) {
        this.init(keyValues, keySplines, keyTimes, interpolationType);
    }

    public KeyFrames(KeyValues keyValues, KeySplines keySplines) {
        if (keySplines != null) {
            this.init(keyValues, keySplines, null, InterpolationType.NONLINEAR);
        } else {
            this.init(keyValues, keySplines, null, InterpolationType.LINEAR);
        }
    }

    private void init(KeyValues keyValues, KeySplines keySplines, KeyTimes keyTimes, InterpolationType interpolationType) {
        if (keyTimes == null) {
            float timeVal;
            int numKeyTimes = keyValues.getSize();
            float[] keyTimesArray = new float[numKeyTimes];
            keyTimesArray[0] = timeVal = 0.0f;
            for (int i = 1; i < numKeyTimes - 1; ++i) {
                keyTimesArray[i] = timeVal += 1.0f / (float)(numKeyTimes - 1);
            }
            keyTimesArray[numKeyTimes - 1] = 1.0f;
            this.keyTimes = new KeyTimes(keyTimesArray);
        } else {
            this.keyTimes = keyTimes;
        }
        this.keyValues = keyValues;
        this.keySplines = keySplines;
        this.interpolationType = interpolationType;
        if (interpolationType == InterpolationType.NONLINEAR && keySplines == null) {
            throw new IllegalArgumentException("NONLINEAR interpolation requires KeySplines");
        }
        if (keyValues.getSize() != this.keyTimes.getSize()) {
            throw new IllegalArgumentException("keyValues and keyTimes must be of equal size");
        }
        if (keySplines != null && keySplines.getSize() != this.keyTimes.getSize() - 1) {
            throw new IllegalArgumentException("keySplines must have a size equal to the one less than the size of keyValues");
        }
    }

    public Class getType() {
        return this.keyValues.getType();
    }

    KeyValues getKeyValues() {
        return this.keyValues;
    }

    KeySplines getKeySplines() {
        return this.keySplines;
    }

    KeyTimes getKeyTimes() {
        return this.keyTimes;
    }

    public void setValue(Object object, Method method, float fraction) {
        int interval = this.keyTimes.getInterval(fraction);
        float t0 = this.keyTimes.getTime(interval);
        if (this.interpolationType == InterpolationType.DISCRETE) {
            if (fraction < 1.0f) {
                this.keyValues.setValue(object, method, interval);
            } else {
                this.keyValues.setValue(object, method, this.keyTimes.getSize() - 1);
            }
        } else {
            float t1 = this.keyTimes.getTime(interval + 1);
            float t = (fraction - t0) / (t1 - t0);
            if (this.interpolationType == InterpolationType.NONLINEAR) {
                t = this.keySplines.interpolate(interval, t);
            }
            this.keyValues.setValue(object, method, interval, interval + 1, t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InterpolationType {
        LINEAR,
        DISCRETE,
        NONLINEAR;

    }
}

