/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.item.BaseContainer;
import oracle.bali.jle.item.GridSnap;

public class ImageItem
extends BaseContainer {
    private Image _image;
    private boolean _defaultSize = true;
    private double _defaultWidth;
    private double _defaultHeight;
    private boolean _isLoaded = false;

    public ImageItem() {
        super(true);
    }

    public ImageItem(Image image) {
        super(true);
        this.setImage(image);
        GridSnap.setGridSnapOverride(this, true);
    }

    public Image getImage() {
        return this._image;
    }

    public void setImage(Image image) {
        this._image = image;
        this.updateSize();
        LayoutItem parent = this.getItemParent();
        if (parent != null) {
            parent.repaintItem();
        }
    }

    public void setItemSize(double width, double height) {
        super.setItemSize(width, height);
        if (width != this._defaultWidth || height != this._defaultHeight) {
            this._defaultSize = false;
        }
    }

    public void setItemParent(LayoutItem parent) {
        super.setItemParent(parent);
        this.updateSize();
    }

    public void paintBackground(Graphics g, AffineTransform trans) {
        if (this._image == null) {
            return;
        }
        Rectangle devRect = this.getDeviceRect(trans);
        JLECanvas canvas = this.getCanvas();
        int width = this._image.getWidth((ImageObserver)((Object)canvas));
        int height = this._image.getHeight((ImageObserver)((Object)canvas));
        if (canvas.isZoomed()) {
            width = (int)Math.round((double)width * canvas.getZoomX());
            height = (int)Math.round((double)height * canvas.getZoomY());
        }
        g.drawImage(this._image, devRect.x, devRect.y, width, height, null);
    }

    public void updateSize() {
        if (this._image == null || !this._defaultSize) {
            return;
        }
        if (!this._isLoaded) {
            this._isLoaded = ImageUtils.isImageLoaded((Image)this._image);
            if (!this._isLoaded) {
                return;
            }
        }
        double euppX = 1.0;
        double euppY = 1.0;
        LayoutItem parent = this.getItemParent();
        if (parent != null) {
            JLECanvas canvas = this.getCanvas();
            if (canvas != null) {
                euppX = canvas.getEngineUnitsPerPixelX();
                euppY = canvas.getEngineUnitsPerPixelY();
            }
            int width = this._image.getWidth((ImageObserver)((Object)canvas));
            int height = this._image.getHeight((ImageObserver)((Object)canvas));
            this._defaultWidth = euppX * (double)width;
            this._defaultHeight = euppY * (double)height;
            this.setItemSize(this._defaultWidth, this._defaultHeight);
        }
    }
}

