/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.BaseContainer;
import oracle.bali.jle.item.JLEContainerEvent;
import oracle.bali.jle.item.JLEContainerListener;
import oracle.bali.share.collection.StringKey;

public class GridSnap
implements JLEContainerListener,
PropertyChangeListener {
    public static final int SNAP_SIZE = 1;
    public static final int SNAP_LOCATION = 2;
    public static final int SNAP_ALL = 3;
    public static final Object GRID_SNAP_KEY = new StringKey("GRID_SNAP_KEY");
    public static final Object GRID_SNAP_OVERRIDE_KEY = new StringKey("GRID_SNAP_OVERRIDE_KEY");
    private double _xInterval = 1.0;
    private double _yInterval = 1.0;
    private double _xHalf = 0.5;
    private double _yHalf = 0.5;
    private BaseContainer _snapped;
    private Vector _children = new Vector(4);
    private int _mode = 3;

    public GridSnap() {
    }

    public GridSnap(BaseContainer snapped, double xInterval, double yInterval) {
        this();
        this.setGridInterval(xInterval, yInterval);
        this.setSnappedItem(snapped);
    }

    public GridSnap(BaseContainer snapped, double xInterval, double yInterval, int mode) {
        this(snapped, xInterval, yInterval);
        this.setMode(mode);
    }

    public void setGridInterval(double xInterval, double yInterval) {
        this._xInterval = xInterval;
        this._yInterval = yInterval;
        this._xHalf = 0.5 * this._xInterval;
        this._yHalf = 0.5 * this._yInterval;
        for (int i = 0; i < this._children.size(); ++i) {
            this._repositionChild((LayoutItem)this._children.elementAt(i));
        }
    }

    public Dimension2D getGridInterval() {
        return new Dimension2D.Double(this._xInterval, this._yInterval);
    }

    public void setSnappedItem(BaseContainer snapped) {
        if (snapped != null) {
            // empty if block
        }
        if (this._snapped != null) {
            this._snapped.removeProperty(GRID_SNAP_KEY);
            for (int i = this._children.size() - 1; i >= 0; --i) {
                LayoutItem curr = (LayoutItem)this._children.elementAt(i);
                PropertyManager pm = curr.getPropertyManager();
                if (pm != null) {
                    pm.removePropertyChangeListener(this);
                }
                this._children.removeElementAt(i);
            }
            this._snapped.removeJLEContainerListener(this);
        }
        this._snapped = snapped;
        if (this._snapped != null) {
            GridSnap oldSnap = GridSnap.getGridSnap(this._snapped);
            if (oldSnap != null) {
                oldSnap.setSnappedItem(null);
            }
            LayoutItem[] newChildren = this._snapped.getItems();
            for (int i = 0; i < newChildren.length; ++i) {
                LayoutItem curr = newChildren[i];
                this._repositionChild(curr);
                PropertyManager pm = curr.getPropertyManager();
                if (pm != null) {
                    pm.addPropertyChangeListener(this);
                }
                this._children.addElement(curr);
            }
            this._snapped.addJLEContainerListener(this);
            this._snapped.putProperty(GRID_SNAP_KEY, this);
        }
    }

    public LayoutItem getSnappedItem() {
        return this._snapped;
    }

    public void setMode(int mode) {
        this._mode = mode;
    }

    public int getMode() {
        return this._mode;
    }

    public static GridSnap getGridSnap(LayoutItem container) {
        Object result = container.getProperty(GRID_SNAP_KEY);
        return result == PropertyManager.NOT_FOUND_OBJECT ? null : (GridSnap)result;
    }

    public static GridSnap removeGridSnap(BaseContainer container) {
        GridSnap doomed = GridSnap.getGridSnap(container);
        if (doomed != null) {
            doomed.setSnappedItem(null);
        }
        return doomed;
    }

    public static void setGridSnapOverride(LayoutItem item, boolean override) {
        if (override) {
            item.putProperty(GRID_SNAP_OVERRIDE_KEY, null);
        } else {
            item.removeProperty(GRID_SNAP_OVERRIDE_KEY);
        }
    }

    public static boolean getGridSnapOverride(LayoutItem item) {
        Object result = item.getProperty(GRID_SNAP_OVERRIDE_KEY);
        return result != PropertyManager.NOT_FOUND_OBJECT;
    }

    public void itemAdded(JLEContainerEvent e) {
        LayoutItem added = e.getChild();
        this._repositionChild(added);
        this._children.addElement(added);
        PropertyManager pm = added.getPropertyManager();
        if (pm != null) {
            pm.addPropertyChangeListener(this);
        }
    }

    public void itemRemoved(JLEContainerEvent e) {
        LayoutItem removed = e.getChild();
        PropertyManager pm = removed.getPropertyManager();
        if (pm != null) {
            pm.removePropertyChangeListener(this);
        }
        this._children.removeElement(removed);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (LayoutItem.BOUNDS_KEY.equals(property)) {
            LayoutItem child = (LayoutItem)evt.getSource();
            this._repositionChild(child);
        }
    }

    private void _repositionChild(LayoutItem child) {
        double remainder;
        if (GridSnap.getGridSnapOverride(child)) {
            return;
        }
        Rectangle2D oldBounds = child.getItemBounds();
        if ((this._mode & 2) != 0) {
            double yIndex;
            double oldX = oldBounds.getX();
            double oldY = oldBounds.getY();
            double xIndex = Math.floor(oldX / this._xInterval);
            remainder = oldX - xIndex * this._xInterval;
            if (remainder > this._xHalf) {
                xIndex += 1.0;
            }
            if ((remainder = oldY - (yIndex = Math.floor(oldY / this._yInterval)) * this._yInterval) > this._yHalf) {
                yIndex += 1.0;
            }
            child.setItemLocation(xIndex * this._xInterval, yIndex * this._yInterval);
        }
        if ((this._mode & 1) != 0) {
            double heightIndex;
            double oldWidth = oldBounds.getWidth();
            double oldHeight = oldBounds.getHeight();
            double widthIndex = Math.floor(oldWidth / this._xInterval);
            remainder = oldWidth - widthIndex * this._xInterval;
            if (remainder > this._xHalf) {
                widthIndex += 1.0;
            }
            if ((remainder = oldHeight - (heightIndex = Math.floor(oldHeight / this._yInterval)) * this._yInterval) > this._yHalf) {
                heightIndex += 1.0;
            }
            child.setItemSize(widthIndex * this._xInterval, heightIndex * this._yInterval);
        }
    }
}

