/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.viewBuilder.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DynamicTable;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.db.event.DynamicTableAdapter;
import oracle.bali.dbUI.db.event.DynamicTableEvent;
import oracle.bali.dbUI.tableComponent.TableComponent;
import oracle.bali.dbUI.viewBuilder.ColumnLinkPort;
import oracle.bali.dbUI.viewBuilder.TableViewBuilderComponent;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLinkPort;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.util.FocusUtils;

public class JInternalFrameTableComponent
extends JInternalFrame
implements TableViewBuilderComponent {
    private ColumnLinkPort[] _ports;
    private Listener _listener = new Listener();
    private static final boolean _sJDK1_3;
    private Component _lastFocused;

    public JInternalFrameTableComponent() {
        this.setMaximizable(false);
        this.setIconifiable(true);
        this.setClosable(true);
        this.setResizable(true);
    }

    public int getLinkPortCount() {
        TableComponent tc = this.getTableComponent();
        return tc == null ? 0 : tc.getSpreadTable().getGrid().getRowCount();
    }

    public ViewBuilderLinkPort getLinkPort(int index) {
        int count = this.getLinkPortCount();
        if (index < 0 || index >= count) {
            return null;
        }
        if (this._ports == null) {
            this._ports = new ColumnLinkPort[count];
        }
        if (this._ports[index] == null) {
            TableComponent tc = this.getTableComponent();
            this._ports[index] = new ColumnLinkPort(this, tc, tc.getColumn(index));
        }
        return this._ports[index];
    }

    public ViewBuilderLinkPort getLinkPortAt(int x, int y) {
        if (this.isIcon()) {
            return null;
        }
        Grid grid = this.getTableComponent().getSpreadTable().getGrid();
        Point p = SwingUtilities.convertPoint(this, x, y, (Component)grid);
        Point cOrigin = grid.getCanvasOrigin();
        p.x += cOrigin.x;
        p.y += cOrigin.y;
        if (p.x < 0 || p.x > grid.getInnerWidth() || p.y < 0 || p.y > grid.getInnerHeight()) {
            return null;
        }
        int count = this.getLinkPortCount();
        Rectangle bounds = null;
        for (int i = 0; i < count; ++i) {
            ViewBuilderLinkPort port = this.getLinkPort(i);
            bounds = port.getBounds();
            if (!bounds.contains(x, y)) continue;
            return port;
        }
        return null;
    }

    public ColumnLinkPort getColumnLinkPort(Column column) {
        TableComponent tc = this.getTableComponent();
        if (tc == null) {
            return null;
        }
        int index = tc.getColumnIndex(column);
        return index == -1 ? null : (ColumnLinkPort)this.getLinkPort(index);
    }

    public Rectangle getComponentBounds() {
        if (this.isIcon()) {
            return this.desktopIcon.getBounds();
        }
        return this.getBounds();
    }

    public void setComponentBounds(Rectangle bounds) {
        this.setBounds(bounds);
    }

    public TableComponent getTableComponent() {
        Container c = this.getContentPane();
        if (c != null && c.getComponentCount() != 0) {
            return (TableComponent)((Object)c.getComponent(0));
        }
        return null;
    }

    public boolean close() {
        try {
            this.setClosed(true);
        }
        catch (PropertyVetoException pve) {
            return false;
        }
        return true;
    }

    public Point getTableComponentLocation() {
        Point p = new Point(0, 0);
        Container content = this.getContentPane();
        while (content != null) {
            Point temp = content.getLocation();
            p.x += temp.x;
            p.y += temp.y;
            if ((content = content.getParent()) != this) continue;
            break;
        }
        return p;
    }

    public void setTableComponent(TableComponent component) {
        TableComponent old = this.getTableComponent();
        if (component != old) {
            Table table;
            if (old != null) {
                this.getContentPane().remove((Component)((Object)old));
            }
            this._clearPorts();
            if (old != null) {
                old.removePropertyChangeListener(this._listener);
                if (FocusUtils.areNewFocusAPIsAvailable()) {
                    old.getSpreadTable().getColumnHeader().removeFocusListener((FocusListener)this._listener);
                    old.getSpreadTable().getGrid().removeFocusListener((FocusListener)this._listener);
                }
                if ((table = old.getTable()) instanceof DynamicTable) {
                    ((DynamicTable)table).removeTableListener(this._listener);
                }
            }
            if (component != null) {
                component.addPropertyChangeListener(this._listener);
                if (FocusUtils.areNewFocusAPIsAvailable()) {
                    component.getSpreadTable().getColumnHeader().addFocusListener((FocusListener)this._listener);
                    component.getSpreadTable().getGrid().addFocusListener((FocusListener)this._listener);
                }
                if ((table = component.getTable()) instanceof DynamicTable) {
                    ((DynamicTable)table).addTableListener(this._listener);
                }
                this.getContentPane().add((Component)((Object)component));
            }
        }
    }

    public void setImage(Image image) {
        this.setFrameIcon(new ImageIcon(image));
    }

    public Image getImage() {
        Icon i = this.getFrameIcon();
        if (i instanceof ImageIcon) {
            return ((ImageIcon)i).getImage();
        }
        return null;
    }

    public void reshape(int x, int y, int width, int height) {
        Rectangle oldRect = this.getBounds();
        super.reshape(x, y, width, height);
        Rectangle newRect = this.getBounds();
        this.firePropertyChange("bounds", oldRect, newRect);
    }

    public Dimension getPreferredSize() {
        JMenuBar bar;
        JRootPane rootPane = this.getRootPane();
        if (_sJDK1_3) {
            rootPane.setPreferredSize(new Dimension(rootPane.getPreferredSize()));
        }
        Dimension d = super.getPreferredSize();
        if (_sJDK1_3) {
            rootPane.setPreferredSize(null);
        }
        if ((bar = this.getMenuBar()) != null) {
            Dimension temp = bar.getPreferredSize();
            d.width = Math.max(d.width, temp.width);
            d.height += temp.height + 2;
        }
        return d;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setIcon(boolean isIcon) throws PropertyVetoException {
        super.setIcon(isIcon);
        int count = this._ports == null ? 0 : this._ports.length;
        for (int i = 0; i < count; ++i) {
            if (this._ports[i] == null) continue;
            this._ports[i].invalidate();
        }
    }

    public boolean isComponentSelected() {
        return this.isSelected();
    }

    public void setComponentSelected(boolean selected) {
        try {
            this.setSelected(selected);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void setSelected(boolean selected) throws PropertyVetoException {
        boolean oldValue = this.isSelected();
        super.setSelected(selected);
        boolean newValue = this.isSelected();
        this.firePropertyChange("componentSelected", oldValue, newValue);
    }

    public Component getFocusOwner() {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            return this._lastFocused;
        }
        return super.getFocusOwner();
    }

    private void _clearPorts() {
        int count = this._ports == null ? 0 : this._ports.length;
        for (int i = 0; i < count; ++i) {
            if (this._ports[i] == null) continue;
            this._ports[i].cleanup();
        }
        this._ports = null;
    }

    private void _reorderPorts() {
        if (this._ports != null) {
            int i;
            TableComponent tc = this.getTableComponent();
            Vector<ColumnLinkPort> temp = new Vector<ColumnLinkPort>();
            temp.setSize(this.getLinkPortCount());
            for (i = 0; i < this._ports.length; ++i) {
                if (this._ports[i] == null) continue;
                temp.setElementAt(this._ports[i], tc.getColumnIndex(this._ports[i].getColumn()));
            }
            for (i = 0; i < temp.size(); ++i) {
                this._ports[i] = (ColumnLinkPort)temp.get(i);
            }
        }
    }

    static {
        String version = System.getProperty("java.version");
        _sJDK1_3 = version == null ? false : version.startsWith("1.3");
    }

    private class Listener
    extends DynamicTableAdapter
    implements PropertyChangeListener,
    FocusListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("table".equals(name)) {
                Table oldTable = (Table)e.getOldValue();
                if (oldTable instanceof DynamicTable) {
                    ((DynamicTable)oldTable).removeTableListener(this);
                }
                JInternalFrameTableComponent.this._clearPorts();
                Table newTable = (Table)e.getNewValue();
                if (newTable instanceof DynamicTable) {
                    ((DynamicTable)newTable).addTableListener(this);
                }
            } else if ("columnLocation".equals(name)) {
                JInternalFrameTableComponent.this._reorderPorts();
            }
        }

        public void columnAdded(DynamicTableEvent e) {
            JInternalFrameTableComponent.this._clearPorts();
        }

        public void columnRemoved(DynamicTableEvent e) {
            JInternalFrameTableComponent.this._clearPorts();
        }

        public void focusGained(FocusEvent e) {
            JInternalFrameTableComponent.this._lastFocused = (Component)e.getSource();
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

