/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.util.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Vector;
import oracle.bali.dbUI.db.Database;
import oracle.bali.dbUI.db.Schema;
import oracle.bali.dbUI.util.jdbc.JDBCSchema;

public class JDBCDatabase
extends Database {
    private static final int _SCHEMA_NAME = 1;
    private Connection _connection;
    private String _name;
    private Schema[] _schemas;
    private String[] _schemaNames;

    public JDBCDatabase(Connection connection) {
        this._connection = connection;
        try {
            this._name = this._connection.getMetaData().getURL();
        }
        catch (SQLException e) {
            System.err.println("A SQLException occured " + e);
        }
    }

    public String getName() {
        return this._name;
    }

    public String getDisplayName(Locale locale) {
        return this.getName();
    }

    public int getSchemaCount() {
        if (this._schemaNames == null) {
            this._schemaNames = this.createSchemaNames();
        }
        return this._schemaNames == null ? 0 : this._schemaNames.length;
    }

    public Schema getSchema(int index) {
        if (this._schemas == null) {
            this._schemas = new Schema[this.getSchemaCount()];
        }
        if (this._schemas[index] == null) {
            this._schemas[index] = this.createSchema(index);
        }
        return this._schemas[index];
    }

    public String getSchemaName(int index) {
        if (this._schemaNames == null) {
            this._schemaNames = this.createSchemaNames();
        }
        return this._schemaNames == null ? null : this._schemaNames[index];
    }

    public String getSchemaDisplayName(int index, Locale locale) {
        return this.getSchemaName(index);
    }

    public Connection getConnection() {
        return this._connection;
    }

    public String toString() {
        return this.getName();
    }

    protected Schema createSchema(int index) {
        return new JDBCSchema(this._connection, this, this.getSchemaName(index));
    }

    protected String[] createSchemaNames() {
        Object[] schemaNames = null;
        try {
            ResultSet data = this._connection.getMetaData().getSchemas();
            Vector<String> temp = new Vector<String>();
            while (data.next()) {
                String schema = data.getString(1);
                temp.addElement(schema);
            }
            schemaNames = new String[temp.size()];
            if (temp.size() != 0) {
                temp.copyInto(schemaNames);
            }
            data.close();
        }
        catch (SQLException e) {
            System.err.println("A SQLException occured " + e);
        }
        return schemaNames;
    }
}

