/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.header;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.bali.dbUI.constraint.Constrainable;
import oracle.bali.dbUI.constraintComponent.ConstraintCompFactory;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.dbUI.header.CBHeaderInputHandler;
import oracle.bali.dbUI.header.CBHeaderItemPainter;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderEvent;
import oracle.bali.ewt.header.HeaderKeyHandler;
import oracle.bali.ewt.header.HeaderMoveAdapter;
import oracle.bali.ewt.header.HeaderMoveListener;
import oracle.bali.ewt.model.Sortable;
import oracle.bali.ewt.painter.Painter;

public class ConstraintSortHandler
extends CBHeaderInputHandler {
    private static final String _SORT_ASCEND = "ascending";
    private static final String _SORT_DESCEND = "descending";
    private static final String _KEY_ASCEND = "HEADER.ASCEND";
    private static final String _KEY_DESCEND = "HEADER.DESCEND";
    private static final String _KEY_SORT = "HEADER.SORT";
    private Listener _listener;
    private Sortable _sortable;
    private boolean[] _decending;
    private boolean _armed;
    private int _item;
    private int _lastItemSorted;

    public ConstraintSortHandler(Header header, Constrainable constrainable, ConstraintCompFactory ccFactory, DataDescriptorProvider ddProvider, Sortable sortable) {
        super(header, constrainable, ccFactory, ddProvider);
        this._sortable = sortable;
        this._lastItemSorted = -1;
        this._item = -1;
        this._listener = new Listener();
    }

    public Sortable getSortable() {
        return this._sortable;
    }

    public void setSortable(Sortable sortable) {
        this._sortable = sortable;
        this._decending = null;
    }

    public void mousePressed(MouseEvent e, Header header, int itemIndex) {
        header.addMoveListener((HeaderMoveListener)this._listener);
        super.mousePressed(e, header, itemIndex);
        if (!e.isConsumed()) {
            if (e.isMetaDown() || e.isPopupTrigger()) {
                return;
            }
            this._armed = true;
            this._item = itemIndex;
        }
    }

    public void mouseReleased(MouseEvent e, Header header, int itemIndex) {
        header.removeMoveListener((HeaderMoveListener)this._listener);
        super.mouseReleased(e, header, itemIndex);
        if (e.isConsumed()) {
            return;
        }
        this._checkArmed(e, header, itemIndex);
        if (this._item == itemIndex && this._armed) {
            this.sort(itemIndex);
            e.consume();
        }
        this._item = -1;
        this._armed = false;
    }

    HeaderKeyHandler createHeaderKeyHandler() {
        return new KeySort();
    }

    JPopupMenu createPopupMenu(int item) {
        JPopupMenu menu = super.createPopupMenu(item);
        JPopupMenu sortSubMenu = new JPopupMenu();
        Header header = this.getHeader();
        Locale locale = header.getLocale();
        ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
        JMenuItem asc = new JMenuItem(b.getString(_KEY_ASCEND));
        asc.setActionCommand(_SORT_ASCEND);
        asc.addActionListener(this._listener);
        JMenuItem desc = new JMenuItem(b.getString(_KEY_DESCEND));
        desc.setActionCommand(_SORT_DESCEND);
        desc.addActionListener(this._listener);
        JMenu sortMenu = new JMenu(b.getString(_KEY_SORT));
        sortMenu.add(asc);
        sortMenu.add(desc);
        menu.add(sortMenu);
        return menu;
    }

    void cancelSort() {
        this._item = -1;
    }

    void sort(int itemIndex) {
        if (this._sortable != null) {
            if (this._decending == null) {
                this._decending = new boolean[this.getHeader().getItemCount()];
            }
            if (this._lastItemSorted == itemIndex) {
                this._decending[itemIndex] = !this._decending[itemIndex];
            }
            this._sortable.sort(itemIndex, !this._decending[itemIndex]);
            this._lastItemSorted = itemIndex;
        }
    }

    void sort(int itemIndex, boolean descending) {
        if (this._sortable != null) {
            if (this._decending == null) {
                this._decending = new boolean[this.getHeader().getItemCount()];
            }
            this._decending[itemIndex] = descending;
            this._sortable.sort(itemIndex, descending);
            this._lastItemSorted = itemIndex;
        }
    }

    private void _checkArmed(MouseEvent e, Header header, int itemIndex) {
        Painter painter;
        if (this._item == itemIndex && (painter = header.getPainter(itemIndex)) instanceof CBHeaderItemPainter) {
            CBHeaderItemPainter p = (CBHeaderItemPainter)painter;
            boolean bl = this._pointInItem(p, header, itemIndex, e.getX(), e.getY());
        }
    }

    private boolean _pointInItem(CBHeaderItemPainter p, Header h, int item, int x, int y) {
        boolean inActive = p.pointInActiveArea(h.getItemSize(item), h.getSize().height, x, y);
        if (inActive) {
            return false;
        }
        if (x < 0 || y < 0) {
            return false;
        }
        return x <= h.getItemSize(item) && y <= h.getSize().height;
    }

    private class KeySort
    extends CBHeaderInputHandler.MenuKeyHandler {
        private KeySort() {
        }

        public void handleKeyEvent(Header header, KeyEvent e) {
            if (!e.isConsumed() && e.getKeyCode() == 32 && e.getID() == 401) {
                int focusItem = header.getFocusItem();
                if (focusItem != -1) {
                    ConstraintSortHandler.this.sort(focusItem);
                }
                e.consume();
            }
            super.handleKeyEvent(header, e);
        }
    }

    private class Listener
    extends HeaderMoveAdapter
    implements ActionListener {
        private Listener() {
        }

        public void itemMoving(HeaderEvent e) {
            ConstraintSortHandler.this.cancelSort();
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (ConstraintSortHandler.this._menuItem != -1) {
                if (ConstraintSortHandler._SORT_ASCEND.equals(cmd)) {
                    ConstraintSortHandler.this.sort(ConstraintSortHandler.this._menuItem, false);
                } else if (ConstraintSortHandler._SORT_DESCEND.equals(cmd)) {
                    ConstraintSortHandler.this.sort(ConstraintSortHandler.this._menuItem, true);
                }
            }
        }
    }
}

