/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import oracle.bali.dbUI.graph.Port;
import oracle.bali.dbUI.graph.jle.JLENodeWindow;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.item.LinkPort;
import oracle.bali.jle.item.LinkPortEvent;
import oracle.bali.jle.item.LinkPortListener;
import oracle.bali.share.event.ListenerManager;

class PortLinkPort
implements LinkPort,
PropertyChangeListener {
    private Port _port;
    private JLENodeWindow _window;
    private boolean _target;
    private boolean _dead;
    private ListenerManager _listeners;
    private double _x;
    private double _y;

    public PortLinkPort(Port port, JLENodeWindow window, boolean target) {
        this._port = port;
        this._window = window;
        this._target = target;
        this._window.getNodeComponent().addPropertyChangeListener(this);
        PropertyManager pm = this._window.getPropertyManager();
        pm.addPropertyChangeListener((PropertyChangeListener)this);
        this._recalculateLocation();
    }

    public LayoutItem getItem() {
        return this._window;
    }

    public void die() {
        if (this.isDead()) {
            return;
        }
        PropertyManager pm = this._window.getPropertyManager();
        pm.removePropertyChangeListener((PropertyChangeListener)this);
        this._window.getNodeComponent().removePropertyChangeListener(this);
        this._fireLinkPortEvent(2);
        this._port = null;
        this._window = null;
        this._dead = true;
        this._listeners = null;
        this._y = Double.NaN;
        this._x = Double.NaN;
    }

    public boolean isDead() {
        return this._dead;
    }

    public Point2D getLocation() {
        return new Point2D.Double(this._x, this._y);
    }

    public double getX() {
        return this._x;
    }

    public double getY() {
        return this._y;
    }

    public void addLinkPortListener(LinkPortListener l) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)l);
    }

    public void removeLinkPortListener(LinkPortListener l) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)l);
        }
    }

    public LinkPortListener[] getLinkPortListeners() {
        if (this._listeners == null) {
            return new LinkPortListener[0];
        }
        Enumeration listeners = this._listeners.getListeners();
        if (listeners == null) {
            return new LinkPortListener[0];
        }
        Vector<LinkPortListener> collect = new Vector<LinkPortListener>();
        while (listeners.hasMoreElements()) {
            LinkPortListener curr = (LinkPortListener)listeners.nextElement();
            collect.addElement(curr);
        }
        Object[] result = new LinkPortListener[collect.size()];
        collect.copyInto(result);
        return result;
    }

    public boolean isUpper() {
        return false;
    }

    public boolean isLower() {
        return false;
    }

    public boolean isLeft() {
        return this._target;
    }

    public boolean isRight() {
        return !this._target;
    }

    public boolean isCenter() {
        return false;
    }

    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (LayoutItem.DEVICE_TRANSFORM_KEY.equals(name) || LayoutItem.BOUNDS_KEY.equals(name) || "portLocation".equals(name)) {
            this._recalculateLocation();
        }
    }

    private void _fireLinkPortEvent(int id) {
        Enumeration listeners;
        Enumeration enumeration = listeners = this._listeners == null ? null : this._listeners.getListeners();
        if (listeners == null) {
            return;
        }
        LinkPortEvent event = new LinkPortEvent((LinkPort)this, id);
        while (listeners.hasMoreElements()) {
            LinkPortListener listener = (LinkPortListener)listeners.nextElement();
            switch (id) {
                case 1: {
                    listener.portMoved(event);
                    break;
                }
                case 2: {
                    listener.portDead(event);
                }
            }
        }
    }

    private void _recalculateLocation() {
        if (this.getNodeWindow().getNodeComponent().isCreateMode()) {
            return;
        }
        Point nodeLocation = this.getNodeWindow().__getContentLocation();
        this._x = this._target ? 0.0 : this.getNodeWindow().getItemSize().getWidth();
        this._y = this.getNodeWindow().isMinimized() ? this.getNodeWindow().getItemSize().getHeight() / 2.0 : (double)(this.getNodeWindow().getNodeComponent().getPortLocation(this.getPort()) + nodeLocation.y);
        this._fireLinkPortEvent(1);
    }

    public Port getPort() {
        return this._port;
    }

    public JLENodeWindow getNodeWindow() {
        return this._window;
    }
}

