/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.DefaultFocusManager;
import oracle.bali.dbUI.graph.jle.GraphCanvas;
import oracle.bali.dbUI.graph.jle.JLENodeWindow;
import oracle.bali.dbUI.graph.jle.NodeBoundsTool;
import oracle.bali.dbUI.graph.jle.NodeTool;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.LayoutTool;

class NodeFocusManager
extends DefaultFocusManager {
    private GraphCanvas _canvas;

    public NodeFocusManager(GraphCanvas canvas) {
        this._canvas = canvas;
    }

    public GraphCanvas getCanvas() {
        return this._canvas;
    }

    public void processKeyEvent(Component focusedComponent, KeyEvent e) {
        if (focusedComponent != null && !this.getCanvas().isAncestorOf(focusedComponent)) {
            super.processKeyEvent(focusedComponent, e);
            return;
        }
        if (e.getKeyCode() == 9 || e.getKeyChar() == '\t') {
            e.consume();
            if (e.getID() != 401) {
                return;
            }
            LayoutItem current = this.getCanvas().getFocusedItem();
            if (e.isControlDown() || current == null) {
                if (e.isShiftDown()) {
                    this._transferBack(current);
                } else {
                    this._transferForward(current);
                }
            } else if (current instanceof JLENodeWindow) {
                JLENodeWindow window = (JLENodeWindow)current;
                Component windowComponent = window.getComponent();
                if (window.isMinimized()) {
                    windowComponent.requestFocus();
                } else {
                    Object nextFocus = null;
                    Grid grid = window.getNodeComponent().getSpreadTable().getGrid();
                    Header header = window.getNodeComponent().getSpreadTable().getColumnHeader();
                    nextFocus = e.getSource() == grid ? (e.isShiftDown() ? windowComponent : header) : (e.getSource() == header ? (e.isShiftDown() ? grid : windowComponent) : (e.isShiftDown() ? header : grid));
                    if (nextFocus != null) {
                        ((Component)nextFocus).requestFocus();
                    }
                }
            }
        }
    }

    public void focusNextComponent(Component aComponent) {
        if (aComponent != null && !this.getCanvas().isAncestorOf(aComponent)) {
            super.focusNextComponent(aComponent);
        }
    }

    public void focusPreviousComponent(Component aComponent) {
        if (aComponent != null && !this.getCanvas().isAncestorOf(aComponent)) {
            super.focusPreviousComponent(aComponent);
        }
    }

    private void _transferForward(LayoutItem current) {
        LayoutItem next = this.getCanvas().getFocusNext(current, true);
        LayoutTool tool = this.getCanvas().getTool();
        if (tool instanceof NodeTool) {
            NodeBoundsTool bounds = ((NodeTool)tool).getBoundsTool();
            if (current != null) {
                bounds.processDeselect(current);
            }
            if (next != null) {
                bounds.processSelect(next);
            }
        }
    }

    private void _transferBack(LayoutItem current) {
        LayoutItem prev = this.getCanvas().getFocusPrevious(current, true);
        LayoutTool tool = this.getCanvas().getTool();
        if (tool instanceof NodeTool) {
            NodeBoundsTool bounds = ((NodeTool)tool).getBoundsTool();
            if (current != null) {
                bounds.processDeselect(current);
            }
            if (prev != null) {
                bounds.processSelect(prev);
            }
        }
    }
}

