/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintBuilder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleSelection;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import oracle.bali.dbUI.constraintBuilder.CBCompArray;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilder;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilderComp;
import oracle.bali.dbUI.constraintBuilder.DragComponent;
import oracle.bali.dbUI.constraintBuilder.PCJDKDropSupport;
import oracle.bali.dbUI.constraintBuilder.Sprout;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.dnd.DBUIDataFlavors;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetContext;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.dnd.JFCSupport;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.share.datatransfer.TransferUtils;

public abstract class ParentComponent
extends ConstraintBuilderComp
implements DropTargetListener {
    public static final int _VINSET = 4;
    public static final int _HINSET = 2;
    private static final int _EXPANDED_WIDTH = 0;
    private static final int _EXPANDED_INCREMENT = 0;
    private boolean _expanded;
    private Sprout _feedbackSprout;
    private Vector _children;
    private Vector _sprouts;
    private ConstraintBuilder _parent;
    private DropTargetListener _dropper = this;
    private boolean _dragSelection;
    private boolean _jdkDnD;
    private PCJDKDropSupport _jdkDropSupport;
    private int _leafLocation;

    public ParentComponent() {
        super.setLayout(null);
        this.addDropTarget(this);
        this._expanded = true;
        this.enableEvents(60L);
    }

    public void enableJDKDnD() {
        if (!this._jdkDnD) {
            this._jdkDnD = true;
            this.removeDropTarget(this);
            this._jdkDropSupport = new PCJDKDropSupport(this);
            this._jdkDropSupport.__addDropTarget(this);
        }
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            ConstraintBuilderComp child = this.getChild(i);
            this.getConstraintBuilder().removeFromSelection(child);
            child.setSelected(selected);
        }
    }

    public void setConstraintBuilder(ConstraintBuilder parent) {
        super.setConstraintBuilder(parent);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            ConstraintBuilderComp child = this.getChild(i);
            child.setConstraintBuilder(parent);
        }
    }

    public void setExpanded(boolean expanded) {
        if (this._expanded != expanded) {
            this._expanded = expanded;
            ConstraintBuilder parent = this.getConstraintBuilder();
            parent.freezeRepaints();
            for (int i = 0; i < this.getChildCount(); ++i) {
                this.getChild(i).setVisible(expanded);
            }
            parent.validate();
            parent.repaint();
            parent.unfreezeRepaints();
        }
    }

    public boolean isExpanded() {
        return this._expanded;
    }

    public final void addChild(ConstraintBuilderComp component) {
        this.addChild(component, -1);
    }

    public void addChild(ConstraintBuilderComp component, int index) {
        if (this._children == null) {
            this._children = new Vector(2);
        }
        if (this._children.indexOf(component) != -1) {
            return;
        }
        int count = this.getChildCount();
        if (index < 0 || index >= count) {
            index = count;
        }
        this._children.insertElementAt(component, index);
        if (!this._jdkDnD) {
            this.addDropTarget(component);
        } else {
            this._jdkDropSupport.__addDropTarget(component);
        }
        this.add((Component)((Object)component), index);
        component.setSelected(this.isSelected());
        component.setEnabled(this.isEnabled());
        component.setVisible(this.isExpanded());
        component.setParentComponent(this);
        AccessibleContext ac = this.accessibleContext;
        if (ac != null) {
            ac.firePropertyChange("AccessibleChild", null, component.getAccessibleContext());
            ac.firePropertyChange("AccessibleName", null, ac.getAccessibleName());
        }
        this.invalidate();
    }

    public void removeChild(ConstraintBuilderComp component) {
        if (this._children == null) {
            return;
        }
        int index = this._children.indexOf(component);
        if (index != -1) {
            if (!this._jdkDnD) {
                this.removeDropTarget(component);
            } else {
                this._jdkDropSupport.__removeDropTarget(component);
            }
            this._children.removeElementAt(index);
            component.setParentComponent(null);
            component.setIndex(-1);
            this.remove((Component)((Object)component));
            this.invalidate();
            AccessibleContext ac = this.accessibleContext;
            if (ac != null) {
                ac.firePropertyChange("AccessibleChild", component.getAccessibleContext(), null);
                ac.firePropertyChange("AccessibleName", null, ac.getAccessibleName());
            }
        }
    }

    public void removeAll() {
        ConstraintBuilderComp[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.removeChild(children[i]);
        }
    }

    public int getChildCount() {
        return this._children == null ? 0 : this._children.size();
    }

    public ConstraintBuilderComp getChild(int index) {
        return index >= this.getChildCount() ? null : (ConstraintBuilderComp)this._children.elementAt(index);
    }

    public int getIndex(ConstraintBuilderComp child) {
        return this._children == null ? -1 : this._children.indexOf(child);
    }

    public ConstraintBuilderComp[] getChildren() {
        int count = this.getChildCount();
        Object[] children = new ConstraintBuilderComp[count];
        if (count != 0) {
            this._children.copyInto(children);
        }
        return children;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.acceptDrag(dtde)) {
            Point p = dtde.getLocation();
            Component comp = dtde.getDropTargetContext().getComponent();
            Point offset = this._getOffset(comp);
            this.calculateFeedback(offset.x + p.x, offset.y + p.y);
        } else {
            dtde.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (this.acceptDrag(dtde)) {
            Point p = dtde.getLocation();
            Component comp = dtde.getDropTargetContext().getComponent();
            Point offset = this._getOffset(comp);
            this.calculateFeedback(offset.x + p.x, offset.y + p.y);
        } else {
            this.calculateFeedback(-1, -1);
            dtde.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dtde) {
        this.calculateFeedback(-1, -1);
    }

    public void drop(DropTargetDropEvent dtde) {
        this.calculateFeedback(-1, -1);
        DropTargetContext context = dtde.getDropTargetContext();
        if (!this.acceptDrop(dtde)) {
            context.dropComplete(false);
            return;
        }
        dtde.acceptDrop(2);
        Transferable transfer = dtde.getTransferable();
        Point p = dtde.getLocation();
        Component comp = dtde.getDropTargetContext().getComponent();
        Point offset = this._getOffset(comp);
        int index = this.getInsertIndex(offset.y + p.y);
        Object data = null;
        if (transfer.isDataFlavorSupported(DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR)) {
            DataDescriptor dd;
            try {
                data = transfer.getTransferData(DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR);
            }
            catch (IOException ioe) {
                data = null;
            }
            catch (UnsupportedFlavorException ufe) {
                data = null;
            }
            if (data instanceof DataDescriptor && (dd = (DataDescriptor)data) != null) {
                context.dropComplete(true);
                ConstraintComponent cc = this.getConstraintBuilder().createConstraintComponent(dd);
                this.getConstraintBuilder().dropConstraintComponent(cc, this, index);
            }
        }
        if (data == null && transfer.isDataFlavorSupported(DBUIDataFlavors.CONSTRAINT_COMPONENT_FLAVOR)) {
            try {
                data = transfer.getTransferData(DBUIDataFlavors.CONSTRAINT_COMPONENT_FLAVOR);
            }
            catch (IOException ioe) {
                data = null;
            }
            catch (UnsupportedFlavorException ufe) {
                data = null;
            }
            if (data instanceof ConstraintComponent) {
                ConstraintComponent cc = (ConstraintComponent)data;
                if (cc != null) {
                    this.getConstraintBuilder().dropConstraintComponent(cc, this, index);
                }
                context.dropComplete(cc != null);
                return;
            }
        }
        if (data == null && transfer.isDataFlavorSupported(CBCompArray.CB_COMP_ARRAY_FLAVOR)) {
            ConstraintBuilderComp[] array;
            try {
                data = transfer.getTransferData(CBCompArray.CB_COMP_ARRAY_FLAVOR);
            }
            catch (IOException ioe) {
                data = null;
            }
            catch (UnsupportedFlavorException ufe) {
                data = null;
            }
            if (data instanceof CBCompArray && (array = ((CBCompArray)data).getData()) != null) {
                context.dropComplete(true);
                for (int i = 0; i < array.length; ++i) {
                    if (array[i] != this) continue;
                    return;
                }
                this.getConstraintBuilder().dropConstraintBuilderComp(array, this, index);
                return;
            }
        }
        context.dropComplete(false);
    }

    public int getGroupWidth() {
        return this.getConstraintBuilder().getGroupWidth();
    }

    public int getGroupDepth() {
        int count = this.getChildCount();
        int max = 0;
        for (int i = 0; i < count; ++i) {
            int temp;
            ConstraintBuilderComp child = this.getChild(i);
            if (!(child instanceof ParentComponent) || (temp = ((ParentComponent)child).getGroupDepth()) <= max) continue;
            max = temp;
        }
        return max + 1;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Component getFocusComponent() {
        return this;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChild(i).setEnabled(enabled);
        }
        if (enabled) {
            this.setBackground(null);
        } else {
            this.setBackground(this.getUIDefaults().getColor("lightIntensity"));
        }
    }

    public Dimension getPreferredSize() {
        int childWidth = 0;
        int childHeight = 0;
        if (!this.isExpanded()) {
            childWidth += 0;
        } else {
            int count = this.getChildCount();
            int leafWidth = this.getConstraintBuilder() == null ? 0 : this.getLeafWidth() + this.getLeafLocation() - this.getGroupWidth();
            for (int i = 0; i < count; ++i) {
                ConstraintBuilderComp child = this.getChild(i);
                Dimension prefSize = child.getPreferredSize();
                int testWidth = child instanceof ParentComponent ? prefSize.width : leafWidth;
                if (testWidth > childWidth) {
                    childWidth = testWidth;
                }
                childHeight += prefSize.height + 4;
            }
        }
        return new Dimension(childWidth += 2, childHeight);
    }

    public Dimension getMinimumSize() {
        int childWidth = 0;
        int childHeight = 0;
        if (!this.isExpanded()) {
            childWidth += 0;
        } else {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                ConstraintBuilderComp child = this.getChild(i);
                Dimension minSize = child.getMinimumSize();
                if (minSize.width > childWidth) {
                    childWidth = minSize.width;
                }
                if (minSize.height <= childHeight) continue;
                childHeight = minSize.height;
            }
            childHeight += count * 4;
        }
        return new Dimension(childWidth += 2, childHeight);
    }

    public Dimension getMaximumSize() {
        int childWidth = 0;
        int childHeight = 0;
        if (!this.isExpanded()) {
            childWidth += 0;
        } else {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                ConstraintBuilderComp child = this.getChild(i);
                Dimension maxSize = child.getMaximumSize();
                if (maxSize.width > childWidth) {
                    childWidth = maxSize.width;
                }
                childHeight += maxSize.height;
            }
            childHeight += count * 4;
        }
        return new Dimension(childWidth += 2, childHeight);
    }

    public ConstraintComponent[] getLeaves() {
        Object[] leaves;
        Vector<Object> v = new Vector<Object>(1);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            ConstraintBuilderComp child = this.getChild(i);
            if (child instanceof ParentComponent) {
                leaves = ((ParentComponent)child).getLeaves();
                if (leaves == null) continue;
                for (int j = 0; j < leaves.length; ++j) {
                    v.addElement(leaves[j]);
                }
                continue;
            }
            v.addElement(((DragComponent)child).getConstraintComponent());
        }
        count = v.size();
        if (count == 0) {
            return null;
        }
        leaves = new ConstraintComponent[count];
        v.copyInto(leaves);
        return leaves;
    }

    public int computeLeafLocation() {
        return 0;
    }

    public void setLeafLocation(int location) {
        this._leafLocation = location;
    }

    public int getLeafLocation() {
        return this._leafLocation;
    }

    public void paintComponent(Graphics g) {
        this.validate();
        PaintContext context = this.getPaintContext();
        UIDefaults defaults = context.getPaintUIDefaults();
        if (this.isEnabled()) {
            g.setColor(Color.black);
        } else {
            g.setColor(defaults.getColor("textInactiveText"));
        }
        int count = this.getSproutCount();
        for (int i = 0; i < count; ++i) {
            Sprout s = this.getSprout(i);
            this.paintSprout(g, s);
        }
        if (this.hasFocus()) {
            Dimension d = this.getSize();
            BorderPainter p = DBUILookAndFeel.getLookAndFeel().getFocusPainter(null);
            int y = 0;
            int height = d.height - 1;
            count = this.getChildCount();
            if (count != 0) {
                ConstraintBuilderComp first = this.getChild(0);
                ConstraintBuilderComp last = this.getChild(count - 1);
                y = first.getLocation().y - 2;
                Rectangle r = last.getBounds();
                height = r.y + r.height - y;
            }
            p.paint(context, g, 0, y, d.width, height);
        }
        this.paintDragFeedback(g);
    }

    protected void addSprout(Sprout sprout) {
        if (this._sprouts == null) {
            this._sprouts = new Vector(2);
        }
        this._sprouts.addElement(sprout);
    }

    protected void removeAllSprouts() {
        if (this._sprouts != null) {
            this._sprouts.removeAllElements();
        }
    }

    protected int getSproutCount() {
        return this._sprouts == null ? 0 : this._sprouts.size();
    }

    protected Sprout getSprout(int index) {
        return this._sprouts == null ? null : (Sprout)this._sprouts.elementAt(index);
    }

    protected void paintSprout(Graphics g, Sprout s) {
        int x1 = s.x1;
        int y1 = s.y1;
        int x2 = s.x2;
        int y2 = s.y2;
        g.drawLine(x1, y1, x1, y2);
        g.drawLine(x1 + 1, y1, x1 + 1, y2);
        g.drawLine(x1, y2, x2 - 3, y2);
        g.drawLine(x1, y2 + 1, x2 - 3, y2 + 1);
        g.drawLine(x2 - 3, y2, x2 - 3, y2);
        g.drawLine(x2 - 2, y2 - 1, x2 - 2, y2 + 2);
        g.drawLine(x2 - 1, y2 - 2, x2 - 1, y2 + 3);
    }

    protected int getInsertIndex(int y) {
        int index = 0;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            ConstraintBuilderComp child = this.getChild(i);
            Rectangle bounds = child.getBounds();
            if (y < bounds.y + bounds.height / 2) {
                return index;
            }
            ++index;
        }
        return index;
    }

    protected void setFeedbackSprout(Sprout feedback) {
        this._feedbackSprout = feedback;
        this.paintImmediateInterior();
    }

    protected Sprout getFeedbackSprout() {
        return this._feedbackSprout;
    }

    protected void paintDragFeedback(Graphics g) {
        Sprout feedback = this.getFeedbackSprout();
        if (feedback != null) {
            g.setColor(this.getConstraintBuilder().DROP_FEEDBACK_COLOR);
            this.paintSprout(g, feedback);
        }
    }

    protected void layoutSprouts() {
    }

    protected void addDropTarget(LWComponent comp) {
        if (JFCSupport.getEWTDropTarget((JComponent)comp) != null) {
            return;
        }
        DropTarget dummy = new DropTarget((Component)comp, this._dropper);
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component child = comp.getComponent(i);
            if (!(child instanceof LWComponent)) continue;
            this.addDropTarget((LWComponent)child);
        }
    }

    protected void removeDropTarget(LWComponent comp) {
        DropTarget drop = JFCSupport.getEWTDropTarget((JComponent)comp);
        boolean found = true;
        try {
            drop.removeDropTargetListener(this._dropper);
        }
        catch (Exception e) {
            found = false;
        }
        if (found) {
            JFCSupport.setEWTDropTarget((JComponent)comp, null);
        }
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component child = comp.getComponent(i);
            if (!(child instanceof LWComponent)) continue;
            this.removeDropTarget((LWComponent)child);
        }
    }

    protected boolean acceptDrag(DropTargetDragEvent dtde) {
        if (!this.isEnabled()) {
            return false;
        }
        for (Object parent = this; parent != null && parent instanceof ParentComponent; parent = ((Component)parent).getParent()) {
            if (!((ConstraintBuilderComp)parent).isDragging()) continue;
            return false;
        }
        DataFlavor[] flavors = dtde.getCurrentDataFlavors();
        if (flavors == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (TransferUtils.supportsDataFlavor((DataFlavor)flavors[i], (DataFlavor)DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR)) {
                return true;
            }
            if (TransferUtils.supportsDataFlavor((DataFlavor)flavors[i], (DataFlavor)DBUIDataFlavors.CONSTRAINT_COMPONENT_FLAVOR)) {
                return true;
            }
            if (!CBCompArray.CB_COMP_ARRAY_FLAVOR.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    protected void calculateFeedback(int x, int y) {
    }

    protected boolean acceptDrop(DropTargetDropEvent e) {
        if (!this.isEnabled()) {
            return false;
        }
        for (Object parent = this; parent != null && parent instanceof ParentComponent; parent = ((Component)parent).getParent()) {
            if (!((ConstraintBuilderComp)parent).isDragging()) continue;
            return false;
        }
        return true;
    }

    protected void updateSelection(int x, int y, int width, int height) {
        ConstraintBuilder builder = this.getConstraintBuilder();
        for (int i = 0; i < this.getChildCount(); ++i) {
            ConstraintBuilderComp child = this.getChild(i);
            if (child instanceof ParentComponent) {
                ParentComponent parent = (ParentComponent)child;
                Point offset = parent.getLocation();
                parent.updateSelection(x - offset.x, y - offset.y, width, height);
                continue;
            }
            if (this.intersects(child.getBounds(), x, y, width, height)) {
                builder.addToSelection(child, false);
                continue;
            }
            builder.removeFromSelection(child, false);
        }
    }

    protected boolean intersects(Rectangle r, int x, int y, int width, int height) {
        return r.x + r.width > x && r.y + r.height > y && r.x < x + width && r.y < y + height;
    }

    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        this.repaint();
    }

    protected void processKeyEvent(KeyEvent e) {
        ConstraintBuilder builder = this.getConstraintBuilder();
        super.processKeyEvent(e);
        if (e.isConsumed() || builder != null && !builder.isEnabled()) {
            return;
        }
        if (e.getID() == 401 && e.getKeyCode() == 121 && (e.getModifiers() & 1) != 0) {
            Dimension d = this.getSize();
            builder.showMenu(this, 10, d.height / 2);
            e.consume();
        } else if (e.getID() == 401 && e.getKeyCode() == 9 && this.hasFocus() && this.getChildCount() != 0) {
            boolean consume = false;
            if (!e.isShiftDown()) {
                this.getChild(0).requestFocus();
                consume = true;
            } else if (this.getParentComponent() != null && this.getParentComponent().getParentComponent() != null) {
                this.getParentComponent().requestFocus();
                consume = true;
            }
            if (consume) {
                e.consume();
            }
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        ConstraintBuilder builder = this.getConstraintBuilder();
        super.processMouseEvent(e);
        if (e.isConsumed() || builder != null && !builder.isEnabled()) {
            return;
        }
        boolean consume = false;
        int x = e.getX();
        int y = e.getY();
        int id = e.getID();
        switch (id) {
            case 501: {
                builder.tryRequestFocus();
                break;
            }
            case 502: {
                if (this._dragSelection) {
                    builder.finishDragSelection(this, x, y);
                } else {
                    builder.clearSelection();
                }
                if (e.isPopupTrigger() && this.contains(x, y)) {
                    builder.showMenu(this, this._dragSelection, x, y);
                }
                this._dragSelection = false;
                consume = true;
            }
        }
        if (consume) {
            e.consume();
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        ConstraintBuilder builder = this.getConstraintBuilder();
        super.processMouseMotionEvent(e);
        if (e.isConsumed() | !builder.isEnabled()) {
            return;
        }
        if (e.getID() == 506) {
            int x = e.getX();
            int y = e.getY();
            if (this._dragSelection) {
                builder.continueDragSelection(this, x, y);
            } else {
                this._dragSelection = true;
                builder.startDragSelection(this, x, y);
            }
            e.consume();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleParent();
        }
        return this.accessibleContext;
    }

    boolean __acceptDrag(Component c, int ops, boolean act, Point cursorLocn, int dropAction, int srcActions, Transferable t) {
        DropTarget target = new DropTarget(c, ops, (DropTargetListener)this, act);
        DropTargetContext context = new DropTargetContext(target);
        context.setTransferable(t);
        return this.acceptDrag(new DropTargetDragEvent(context, cursorLocn, dropAction, srcActions));
    }

    boolean __acceptDrop(Component c, int ops, boolean act, Point cursorLocn, int dropAction, int srcActions, Transferable t) {
        DropTarget target = new DropTarget(c, ops, (DropTargetListener)this, act);
        DropTargetContext context = new DropTargetContext(target);
        context.setTransferable(t);
        return this.acceptDrop(new DropTargetDropEvent(context, cursorLocn, dropAction, srcActions));
    }

    private Point _getOffset(Component comp) {
        int x = 0;
        int y = 0;
        for (Component parent = comp; parent != this; parent = parent.getParent()) {
            Point p = parent.getLocation();
            x += p.x;
            y += p.y;
        }
        return new Point(x, y);
    }

    class AccessibleParent
    extends ConstraintBuilderComp.AccessibleConstraintBuilderComp
    implements AccessibleSelection {
        public int getAccessibleChildrenCount() {
            return ParentComponent.this.getChildCount();
        }

        public Accessible getAccessibleChild(int i) {
            if (i < 0 || i >= this.getAccessibleChildrenCount()) {
                return null;
            }
            return ParentComponent.this.getChild(i);
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            int selectedCount = 0;
            int count = ParentComponent.this.getChildCount();
            for (int i = 0; i < count; ++i) {
                if (!ParentComponent.this.getChild(i).isSelected()) continue;
                ++selectedCount;
            }
            return selectedCount;
        }

        public Accessible getAccessibleSelection(int i) {
            if (i < 0 || i >= this.getAccessibleSelectionCount()) {
                return null;
            }
            int selectedCount = 0;
            int count = ParentComponent.this.getChildCount();
            for (int j = 0; j < count; ++j) {
                ConstraintBuilderComp child = ParentComponent.this.getChild(j);
                if (!child.isSelected()) continue;
                if (selectedCount == i) {
                    return child;
                }
                ++selectedCount;
            }
            return null;
        }

        public boolean isAccessibleChildSelected(int i) {
            if (i < 0 || i >= this.getAccessibleChildrenCount()) {
                return false;
            }
            return ParentComponent.this.getChild(i).isSelected();
        }

        public void addAccessibleSelection(int i) {
            if (i < 0 || i >= this.getAccessibleChildrenCount()) {
                return;
            }
            ConstraintBuilderComp child = ParentComponent.this.getChild(i);
            ParentComponent.this.getConstraintBuilder().addToSelection(child);
            child.setSelected(true);
        }

        public void removeAccessibleSelection(int i) {
            if (i < 0 || i >= this.getAccessibleChildrenCount()) {
                return;
            }
            ConstraintBuilderComp child = ParentComponent.this.getChild(i);
            ParentComponent.this.getConstraintBuilder().removeFromSelection(child);
            child.setSelected(false);
        }

        public void clearAccessibleSelection() {
            int count = ParentComponent.this.getChildCount();
            for (int i = 0; i < count; ++i) {
                ConstraintBuilderComp child = ParentComponent.this.getChild(i);
                if (!child.isSelected()) continue;
                ParentComponent.this.getConstraintBuilder().removeFromSelection(child);
                child.setSelected(false);
            }
        }

        public void selectAllAccessibleSelection() {
            int count = ParentComponent.this.getChildCount();
            for (int i = 0; i < count; ++i) {
                ConstraintBuilderComp child = ParentComponent.this.getChild(i);
                if (child.isSelected()) continue;
                ParentComponent.this.getConstraintBuilder().addToSelection(child);
                child.setSelected(true);
            }
        }
    }
}

