/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.util;

import java.util.HashMap;
import java.util.StringTokenizer;

public final class Version
implements Comparable<Version> {
    private static final HashMap<String, Version> _convertCache = new HashMap();
    private final int[] _numbers;
    private final String _versionLabel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Version(String versionLabel) throws NumberFormatException {
        HashMap<String, Version> hashMap = _convertCache;
        synchronized (hashMap) {
            Version version = _convertCache.get(versionLabel);
            if (version == null) {
                this._versionLabel = versionLabel;
                this._numbers = Version.toVersionString(versionLabel);
                _convertCache.put(versionLabel, this);
            } else {
                this._versionLabel = version._versionLabel;
                this._numbers = version._numbers;
            }
        }
    }

    public static boolean isValid(String versionLabel) {
        if (versionLabel == null) {
            throw new NullPointerException("versionLabel is null");
        }
        try {
            Version.toVersionString(versionLabel);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public int[] toIntArray() {
        int[] numbers = new int[this._numbers.length];
        System.arraycopy(this._numbers, 0, numbers, 0, this._numbers.length);
        return numbers;
    }

    @Override
    public int compareTo(Version other) {
        if (this == other) {
            return 0;
        }
        int[] otherNumbers = other._numbers;
        int len1 = this._numbers.length;
        int len2 = otherNumbers.length;
        int max = Math.max(len1, len2);
        for (int i = 0; i < max; ++i) {
            int d2;
            int d1 = i < len1 ? this._numbers[i] : 0;
            int n = d2 = i < len2 ? otherNumbers[i] : 0;
            if (d1 == d2) continue;
            return d1 - d2;
        }
        return 0;
    }

    public String toString() {
        return this._versionLabel;
    }

    public String toCanonicalString() {
        int len = this._numbers.length;
        StringBuffer rtn = new StringBuffer(len * 3).append(this._numbers[0]);
        for (int i = 1; i < len; ++i) {
            rtn.append('.');
            rtn.append(this._numbers[i]);
        }
        return rtn.toString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        Version version = (Version)other;
        int len = this._numbers.length;
        if (len != version._numbers.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this._numbers[i] == version._numbers[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 925295;
        int len = this._numbers.length;
        for (int i = 0; i < len; ++i) {
            hash = 37 * hash + i;
        }
        return hash;
    }

    private static int[] toVersionString(String versionLabel) {
        StringTokenizer tokenizer = new StringTokenizer(versionLabel, ".", true);
        int count = tokenizer.countTokens() + 1;
        if (count % 2 != 0) {
            throw new NumberFormatException("Malformed version specification: `" + versionLabel + "`");
        }
        int[] numbers = new int[count / 2];
        boolean expectingNumber = true;
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (expectingNumber) {
                expectingNumber = false;
                int element = Integer.parseInt(token);
                if (element < 0) {
                    throw new NumberFormatException("Malformed version specification: `" + element + "` must be >= 0");
                }
                numbers[i++] = element;
                continue;
            }
            expectingNumber = true;
        }
        return numbers;
    }
}

