/*
 * Decompiled with CFR 0.152.
 */
package javax.ide;

import java.util.HashMap;
import java.util.Map;
import javax.ide.spi.LookupProvider;
import javax.ide.spi.ProviderNotFoundException;

public abstract class Service {
    private boolean _initialized = false;
    private static final Map<Class<?>, Service> _loadedServices = new HashMap();

    protected void initialize() {
    }

    private static Service findService(Class serviceClass) throws ProviderNotFoundException {
        Service service = _loadedServices.get(serviceClass);
        if (service == null) {
            service = (Service)LookupProvider.lookup(Thread.currentThread().getContextClassLoader(), serviceClass);
            _loadedServices.put(serviceClass, service);
        }
        return service;
    }

    protected static Service getService(Class serviceClass) throws ProviderNotFoundException {
        Service service = Service.findService(serviceClass);
        if (!service._initialized) {
            service._initialized = true;
            service.initialize();
        }
        return service;
    }

    public static void resetAllServices() {
        _loadedServices.clear();
    }

    public static HashMap<Class<?>, Service> cloneLoadedServices() {
        return new HashMap(_loadedServices);
    }

    public static void setLoadedServices(HashMap<Class<?>, Service> loadedServices) {
        _loadedServices.clear();
        _loadedServices.putAll(loadedServices);
    }
}

