/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.ideimpl.deferredupdate.AbstractProgressMonitor;
import oracle.ideimpl.deferredupdate.task.AtomicTask;
import oracle.ideimpl.deferredupdate.task.CreateExtraInfoTask;
import oracle.ideimpl.deferredupdate.task.DeinstallCustomUpdateTask;
import oracle.ideimpl.deferredupdate.task.DeinstallExtensionTask;
import oracle.ideimpl.deferredupdate.task.InstallExtensionTask;
import oracle.ideimpl.deferredupdate.task.InstallPatchTask;
import oracle.ideimpl.deferredupdate.task.ScheduleHookTask;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;
import oracle.ideimpl.deferredupdate.task.TaskProgress;
import oracle.ideimpl.deferredupdate.task.TaskStack;

public final class TaskList {
    public static final String DEINSTALL_EXTENSION_TASK = "DeinstallExtensionTask";
    public static final String DEINSTALL_CUSTOM_UPDATE_TASK = "DeinstallCustomUpdateTask";
    public static final String INSTALL_EXTENSION_TASK = "InstallExtensionTask";
    public static final String INSTALL_PATCH_TASK = "InstallPatchTask";
    public static final String SCHEDULE_HOOK_TASK = "ScheduleHookTask";
    public static final String UPDATE_EXTRA_INFO = "UpdateExtraInfo";
    private List<AtomicTask> tasks = new ArrayList<AtomicTask>();
    private Properties paths = new Properties();

    public TaskList(Map<String, List<String>> properties, TaskContext tc) {
        this.tasks = new ArrayList<AtomicTask>();
        for (String taskName : properties.keySet()) {
            if (taskName.equals(DEINSTALL_EXTENSION_TASK)) {
                this.createDeinstallExtensionTasks(properties.get(taskName));
                continue;
            }
            if (taskName.equals(DEINSTALL_CUSTOM_UPDATE_TASK)) {
                this.createDeinstallCustomUpdateTasks(properties.get(taskName));
                continue;
            }
            if (taskName.equals(INSTALL_EXTENSION_TASK)) {
                this.createInstallExtensionTasks(properties.get(taskName));
                continue;
            }
            if (taskName.equals(INSTALL_PATCH_TASK)) {
                this.createInstallPatchTasks(properties);
                continue;
            }
            if (taskName.equals(SCHEDULE_HOOK_TASK)) {
                this.createScheduleHookTasks(properties.get(taskName));
                continue;
            }
            if (taskName.equals(UPDATE_EXTRA_INFO)) {
                this.createExtraInfoTasks(properties.get(taskName));
                continue;
            }
            this.paths.setProperty(taskName, properties.get(taskName).get(0));
        }
    }

    private void createDeinstallExtensionTasks(List<String> taskDescriptions) {
        for (String task : taskDescriptions) {
            String[] pieces = task.split(",");
            if (pieces.length != 2) continue;
            this.tasks.add(new DeinstallExtensionTask(pieces[0], pieces[1]));
        }
    }

    private void createDeinstallCustomUpdateTasks(List<String> taskDescriptions) {
        for (String task : taskDescriptions) {
            String[] pieces = task.split(",");
            if (pieces.length != 3) continue;
            this.tasks.add(new DeinstallCustomUpdateTask(pieces[0], pieces[1], pieces[2], this.paths.getProperty("oracleHome")));
        }
    }

    private void createExtraInfoTasks(List<String> taskDescriptions) {
        for (String task : taskDescriptions) {
            this.tasks.add(new CreateExtraInfoTask(task));
        }
    }

    private void createInstallExtensionTasks(List<String> taskDescriptions) {
        for (String task : taskDescriptions) {
            String[] pieces = task.split(",");
            if (pieces.length < 4) continue;
            ArrayList<String> updateIds = new ArrayList<String>();
            for (int x = 3; x < pieces.length; ++x) {
                updateIds.add(pieces[x]);
            }
            this.tasks.add(new InstallExtensionTask(pieces[0], pieces[1], pieces[2].equals("true"), updateIds));
        }
    }

    private void createInstallPatchTasks(Map<String, List<String>> properties) {
        List<String> taskDescriptions = properties.get(INSTALL_PATCH_TASK);
        for (String task : taskDescriptions) {
            String[] pieces = task.split(",");
            if (pieces.length < 5) continue;
            ArrayList<String> updateIds = new ArrayList<String>();
            for (int x = 4; x < pieces.length; ++x) {
                updateIds.add(pieces[x]);
            }
            this.tasks.add(new InstallPatchTask(pieces[0], pieces[1], pieces[2], pieces[3].equals("true"), updateIds, this.paths.getProperty("oracleHome")));
        }
    }

    private void createScheduleHookTasks(List<String> taskDescriptions) {
        for (String task : taskDescriptions) {
            String[] pieces = task.split(",");
            if (pieces.length != 3) continue;
            this.tasks.add(new ScheduleHookTask(pieces[0], pieces[1], pieces[2]));
        }
    }

    public void executeAll(TaskContext tc, final AbstractProgressMonitor mon) throws TaskFailedException {
        tc.setProgress(new TaskProgress(){

            @Override
            public void setPercentProgress(double progress) {
                mon.setStepProgress(progress);
            }
        });
        mon.setMajorStepCount(this.tasks.size());
        TaskStack ts = new TaskStack();
        int step = 0;
        Iterator<AtomicTask> i = this.tasks.iterator();
        while (i.hasNext()) {
            try {
                mon.startStep(step);
                ts.performTask(i.next(), tc);
                mon.endStep(step);
            }
            catch (TaskFailedException tfe) {
                ts.rollbackTasks(tc);
                throw tfe;
            }
        }
        ts.commitTasks(tc);
    }
}

