/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.MetaClassVisitor;
import javax.ide.util.MetaClass;
import oracle.jdevimpl.history.HistoryHyperlink;

public class HistoryHyperlinkHook
extends ExtensionHook {
    private static final String NS = "http://xmlns.oracle.com/ide/extension";
    public static final String HISTORY_HYPERLINK_HOOK = "history-hyperlink-hook";
    private static final ElementName HYPERLINK_CLASS = new ElementName("http://xmlns.oracle.com/ide/extension", "hyperlink-class");
    private static final ElementName PATTERN = new ElementName("http://xmlns.oracle.com/ide/extension", "pattern");
    private static final ElementName PRIORITY = new ElementName("http://xmlns.oracle.com/ide/extension", "priority");
    private static final String KEY_PROVIDER = "history-hyperlink";
    private final ElementVisitor _hyperlinkClassHandler = new HyperlinkClassHandler();
    private final ElementVisitor _patternHandler = new PatternHandler();
    private final ElementVisitor _priorityHandler = new PriorityHandler();
    private Collection<HistoryHyperlink> _providers = new TreeSet<HistoryHyperlink>(new HyperlinkComparator());

    Collection<HistoryHyperlink> getHyperlinkProviders() {
        return this._providers;
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(HYPERLINK_CLASS, this._hyperlinkClassHandler);
        context.registerChildVisitor(PATTERN, this._patternHandler);
        context.registerChildVisitor(PRIORITY, this._priorityHandler);
        context.getScopeData().put(KEY_PROVIDER, new HistoryHyperlink());
    }

    public void end(ElementEndContext context) {
        HistoryHyperlink link = (HistoryHyperlink)context.getScopeData().get(KEY_PROVIDER);
        this._providers.add(link);
    }

    private static class HyperlinkComparator
    implements Comparator {
        private HyperlinkComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof HistoryHyperlink)) {
                return -1;
            }
            if (!(o2 instanceof HistoryHyperlink)) {
                return 1;
            }
            HistoryHyperlink p1 = (HistoryHyperlink)o1;
            HistoryHyperlink p2 = (HistoryHyperlink)o2;
            if (p1.getPriority() < p2.getPriority()) {
                return -1;
            }
            if (p1.getPriority() > p2.getPriority()) {
                return 1;
            }
            return 0;
        }
    }

    private class PriorityHandler
    extends ElementVisitor {
        private PriorityHandler() {
        }

        public void end(ElementEndContext context) {
            HistoryHyperlink link = (HistoryHyperlink)context.getScopeData().get(HistoryHyperlinkHook.KEY_PROVIDER);
            Integer pr = 1;
            try {
                pr = Integer.valueOf(context.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            link.setPriority(pr);
        }
    }

    private class PatternHandler
    extends ElementVisitor {
        private PatternHandler() {
        }

        public void end(ElementEndContext context) {
            HistoryHyperlink link = (HistoryHyperlink)context.getScopeData().get(HistoryHyperlinkHook.KEY_PROVIDER);
            link.setPattern(context.getText());
        }
    }

    private class HyperlinkClassHandler
    extends MetaClassVisitor {
        private HyperlinkClassHandler() {
        }

        protected void metaClass(ElementContext context, MetaClass mc) {
            HistoryHyperlink link = (HistoryHyperlink)context.getScopeData().get(HistoryHyperlinkHook.KEY_PROVIDER);
            link.setMetaClass(mc);
        }
    }
}

