/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.navigator;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.ObjectFactoryRegistry;
import oracle.dbtools.raptor.navigator.db.DBNavigatorManager;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.db.DBURLFactory;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.db.model.DatabaseNode;
import oracle.ide.docking.DockableWindow;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.navigator.NavigatorManager;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.util.WeakCache;

public class DatabaseNavigatorHelper {
    private static Logger getLogger() {
        return DBLog.getLogger(DatabaseNavigatorHelper.class);
    }

    @Deprecated
    public static NavigatorManager getDatabaseNavigatorManager() {
        throw new UnsupportedOperationException("The Database Navigator no longer has a NavigatorManager");
    }

    public static DockableWindow getDatabaseNavigatorWindow() {
        return DBNavigatorManager.getInstance().getNavigatorWindow();
    }

    public static ViewId getDatabaseNavigatorViewID() {
        return DBNavigatorManager.getInstance().getViewId();
    }

    public static DatabaseNode findConnectionNode(String storeName, String connName) {
        String qualifiedName;
        String toEncode = storeName == null ? storeName : storeName + "#" + connName;
        try {
            qualifiedName = URLEncoder.encode(toEncode, "utf-8");
        }
        catch (UnsupportedEncodingException uee) {
            qualifiedName = toEncode;
        }
        return DatabaseNavigatorHelper.findConnectionNode(qualifiedName);
    }

    private static DatabaseNode findConnectionNode(String qualifiedName) {
        DatabaseConnection retval = null;
        URL url = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)qualifiedName);
        if (url != null) {
            retval = DatabaseConnection.findConnectionNode((URL)url);
        }
        return retval;
    }

    public static DatabaseNode findConnectionNode(Database db) {
        if (db != null) {
            return DatabaseNavigatorHelper.findConnectionNode(db.getQualifiedName());
        }
        return null;
    }

    public static DBObjectTypeNode findTypeNode(Database db, Schema schema, String type) {
        DBObjectTypeNode retval = null;
        if (db != null) {
            URL url;
            ObjectFactory factory;
            String schemaName = schema == null ? null : schema.getName();
            String catalog = null;
            if (db instanceof JdbcDatabase && (factory = ObjectFactoryRegistry.getDatabaseNavigatorRegistry().getFactory(db.getQualifiedName(), db.getConnection())) != null && factory.isSupportsCatalog()) {
                catalog = ((JdbcDatabase)db).getCatalog();
            }
            if ((url = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)db.getQualifiedName(), catalog, (String)schemaName, (String)type)) != null) {
                try {
                    Field f = DatabaseNavigatorElementFactory.class.getDeclaredField("s_typeFolders");
                    f.setAccessible(true);
                    WeakCache map = (WeakCache)f.get(null);
                    Object node = map.get((Object)url);
                    if (node instanceof DBObjectTypeNode) {
                        retval = (DBObjectTypeNode)node;
                    }
                }
                catch (Throwable t) {
                    DatabaseNavigatorHelper.getLogger().log(Level.FINE, "Failed to get type folder", t);
                }
            }
        }
        return retval;
    }

    public static DBObjectNode findObjectNode(Database db, SystemObject obj) {
        Node node;
        URL url = DBURLFactory.getURL((DBObjectProvider)db, (SystemObject)obj);
        if (url != null && (node = NodeFactory.find((URL)url)) instanceof DBObjectNode) {
            return (DBObjectNode)node;
        }
        return null;
    }
}

