/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.proxy;

import java.sql.Connection;
import java.util.Properties;
import java.util.logging.Level;
import oracle.dbtools.raptor.proxy.AbstractProxy;
import oracle.dbtools.raptor.proxy.Messages;
import oracle.dbtools.raptor.proxy.MethodTracker;
import oracle.dbtools.raptor.proxy.ProxyLogger;
import oracle.dbtools.raptor.proxy.driver.oracle.RaptorProxyOJDBCConnection;
import oracle.dbtools.raptor.proxy.driver.oracle.RaptorProxyOJDBCResultSet;
import oracle.dbtools.raptor.proxy.driver.oracle.RaptorProxyOJDBCStatement;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.proxy._Proxy_;

public class ProxyRegistry {
    public static final String PROXY_WRAPPER_NEVER = "NEVER";
    public static final String PROXY_WRAPPER_ALWAYS = "ALWAYS";
    public static final String CONNECTION_NAME_KEY = "ConnName";
    public static final boolean DEBUG_BUILD = ProxyRegistry.getSystemBoolean("sqldev.debug", false);
    public static final boolean PROXY_FLAG = ProxyRegistry.getSystemBoolean("sqldev.jdbcproxy", true);
    private static volatile ProxyRegistry instance = null;
    private ProxyLogger proxyLogger = new ProxyLogger();
    private ProxyFactory oraJDBCProxyFactory;

    private static boolean getSystemBoolean(String string, boolean bl) {
        boolean bl2 = bl;
        try {
            String string2 = System.getProperty(string);
            if (string2 != null) {
                bl2 = Boolean.parseBoolean(string2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return bl2;
    }

    public ProxyRegistry() {
        MethodTracker.addChangeListener(this.proxyLogger);
        try {
            this.oraJDBCProxyFactory = ProxyRegistry.createJDBCProxyFactory();
        }
        catch (Exception exception) {
            this.nullifyJDBCProxyFactory();
            this.proxyLogger.logException(Level.WARNING, exception);
            this.proxyLogger.log(Level.INFO, Messages.cannotCreateProxies());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.nullifyJDBCProxyFactory();
            this.proxyLogger.logException(noSuchMethodError);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.nullifyJDBCProxyFactory();
            this.proxyLogger.logException(Level.WARNING, noClassDefFoundError);
            this.proxyLogger.log(Level.INFO, Messages.cannotCreateProxies());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProxyRegistry getInstance() {
        if (instance != null) return instance;
        Class<ProxyRegistry> clazz = ProxyRegistry.class;
        synchronized (ProxyRegistry.class) {
            if (instance != null) return instance;
            instance = new ProxyRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public ProxyFactory getJDBCProxyFactory() {
        return this.oraJDBCProxyFactory;
    }

    public void nullifyJDBCProxyFactory() {
        this.oraJDBCProxyFactory = null;
    }

    protected static ProxyFactory createJDBCProxyFactory() {
        ProxyFactory proxyFactory = ProxyFactory.createJDBCProxyFactory((Class[])new Class[]{RaptorProxyOJDBCConnection.class, RaptorProxyOJDBCStatement.class, RaptorProxyOJDBCResultSet.class});
        proxyFactory.setClassLoader(RaptorProxyOJDBCConnection.class.getClassLoader());
        return proxyFactory;
    }

    public String getWrapRequirement() {
        if (this.oraJDBCProxyFactory == null) {
            return PROXY_WRAPPER_NEVER;
        }
        return PROXY_FLAG ? PROXY_WRAPPER_ALWAYS : PROXY_WRAPPER_NEVER;
    }

    public boolean wrapRequired() {
        return this.wrapRequired(null);
    }

    public boolean wrapRequired(Properties properties) {
        String string = this.getWrapRequirement();
        return string == PROXY_WRAPPER_ALWAYS;
    }

    public ProxyLogger getProxyLogger() {
        return this.proxyLogger;
    }

    protected <T> T proxyFor(T t) {
        try {
            ProxyFactory proxyFactory = this.getJDBCProxyFactory();
            if (proxyFactory != null) {
                return (T)proxyFactory.proxyFor(t);
            }
        }
        catch (Exception exception) {
            this.nullifyJDBCProxyFactory();
            this.proxyLogger.logException(Level.WARNING, exception);
            this.proxyLogger.log(Level.INFO, Messages.cannotCreateProxies());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.nullifyJDBCProxyFactory();
            this.proxyLogger.logException(Level.WARNING, noClassDefFoundError);
            this.proxyLogger.log(Level.INFO, Messages.cannotCreateProxies());
        }
        return t;
    }

    public Connection proxyFor(Connection connection, Properties properties) {
        if (this.wrapRequired(properties) && !(connection instanceof AbstractProxy) && (connection = this.proxyFor(connection)) instanceof AbstractProxy) {
            AbstractProxy abstractProxy = (AbstractProxy)((Object)connection);
            abstractProxy.initialize(properties);
            this.proxyLogger.logConnectionWrap(connection, properties);
        }
        return connection;
    }

    public static Connection jdbcProxyFor(Connection connection, Properties properties) {
        return ProxyRegistry.getInstance().proxyFor(connection, properties);
    }

    public static <T> T unwrap(T t) {
        if (t instanceof _Proxy_) {
            return (T)((_Proxy_)t)._getDelegate_();
        }
        return t;
    }
}

