/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem.editor;

import com.oracle.jdeveloper.nbwindowsystem.NbEditorContainer;
import com.oracle.jdeveloper.nbwindowsystem.editor.SplitPane;
import com.oracle.jdeveloper.nbwindowsystem.editor.SplitPaneState;
import com.oracle.jdeveloper.nbwindowsystem.editor.TabGroup;
import com.oracle.jdeveloper.nbwindowsystem.editor.TabGroupState;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import oracle.ideimpl.resource.IdeImplArb;
import org.openide.windows.TopComponent;

public class SplitEditorAction
extends AbstractAction {
    private final NbEditorContainer editor;
    private final boolean verticalSplit;

    public SplitEditorAction(NbEditorContainer editor, boolean verticalSplit) {
        super(verticalSplit ? IdeImplArb.getString((int)22) : IdeImplArb.getString((int)23));
        this.editor = editor;
        this.verticalSplit = verticalSplit;
    }

    public static Action createSplitEditorHorizontallyAction() {
        return new SplitEditorAction(null, true);
    }

    public static Action createSplitEditorVerticallyAction() {
        return new SplitEditorAction(null, false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SplitPaneState splitState;
        TabGroupState tabGroupState;
        TabGroup tg;
        NbEditorContainer context = this.getContextEditor();
        if (null != context && null != (tg = context.getTabGroup()) && null != (tabGroupState = tg.getCurrentTabGroupState()) && null != (splitState = tabGroupState.getCurrentSplitPaneState()) && splitState.isSplitable()) {
            SplitPane sp = splitState.getSplitPane();
            int splitPos = this.verticalSplit ? sp.getWidth() : sp.getHeight();
            tg.split(splitState.getSplitPane(), splitPos /= 2, this.verticalSplit ? 0 : 1);
        }
    }

    @Override
    public boolean isEnabled() {
        TabGroupState tabGroupState;
        TabGroup tg;
        boolean res;
        NbEditorContainer context = this.getContextEditor();
        boolean bl = res = null != context;
        if (res && null != (tg = context.getTabGroup()) && null != (tabGroupState = tg.getCurrentTabGroupState())) {
            SplitPaneState splitState = tabGroupState.getCurrentSplitPaneState();
            res &= null != splitState && splitState.isSplitable();
        }
        return res;
    }

    private NbEditorContainer getContextEditor() {
        if (null != this.editor) {
            return this.editor;
        }
        TopComponent activeTC = TopComponent.getRegistry().getActivated();
        if (activeTC instanceof NbEditorContainer) {
            return (NbEditorContainer)activeTC;
        }
        return null;
    }
}

