/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem.editor;

import com.oracle.jdeveloper.nbwindowsystem.NbEditorContainer;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorUtil;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.appstate.ApplicationStateProvider;
import oracle.ide.editor.EditorManager;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.editor.HashStructureStructuredPropertyAccess;
import oracle.javatools.data.HashStructure;
import org.openide.windows.TopComponent;

public class NbEditorStateProvider
implements ApplicationStateProvider {
    public void saveState(HashStructure data) {
        for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
            NbEditorContainer ec;
            if (!(tc instanceof NbEditorContainer) || (ec = (NbEditorContainer)tc).getEditor() != null) continue;
            ec.loadTabGroup();
        }
        for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
            if (!(tc instanceof NbEditorContainer)) continue;
            ((NbEditorContainer)tc).saveLayout(this.adapt(data), true);
        }
    }

    public void restoreState(HashStructure access) {
        if (access != null) {
            this.closeAllDocuments();
            StructuredPropertyAccess spa = this.adapt(access);
            spa.getName();
            Iterator iter = spa.getChildNodes();
            while (iter.hasNext()) {
                StructuredPropertyAccess spa_ = (StructuredPropertyAccess)iter.next();
                final Context context = EditorUtil.loadContext(spa_);
                if (context == null || context.getNode() == null) continue;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        EditorManager.getEditorManager().openDefaultEditorInFrame(context);
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        }
    }

    private StructuredPropertyAccess adapt(HashStructure hs) {
        return new HashStructureStructuredPropertyAccess(hs);
    }

    private void closeAllDocuments() {
        for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
            if (!(tc instanceof NbEditorContainer)) continue;
            tc.close();
        }
    }
}

