/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.tools;

import java.awt.Color;
import java.awt.Frame;
import java.sql.Connection;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.spatial.dialogs.newquery.controller.NewQueryController;
import oracle.dbtools.spatial.dialogs.newquery.model.NewQueryModel;
import oracle.dbtools.spatial.dialogs.newquery.view.NewQueryDialog;
import oracle.dbtools.spatial.tools.SpatialTool;
import oracle.dbtools.spatial.views.SpatialUtil;
import oracle.dbtools.spatial.views.SpatialViewController;
import oracle.dbtools.spatial.views.tables.QueryObject;
import oracle.dbtools.spatial.views.tables.SpatialListReorderableTableWithTitleBar;
import oracle.dbtools.spatial.views.tables.SpatialReorderableTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.javatools.db.DBException;

public class SpatialAddGeomQuery
extends SpatialTool {
    public static final String TYPE = "ADD_QUERY_LAYER";
    protected static int ACTION = Ide.findOrCreateCmdID((String)"spatial_add_query_layer");
    String queryTitle;
    String queryText;
    String annoTatedColumn;
    Color lblColor;
    Color markerColor;
    Color markerFill;
    int markerSize;
    int markerType;
    Color curveColor;
    int curveWidth;
    Color borderColor;
    Color areaFillColor;
    Connection cnx;
    String tabIdentifier;
    SpatialReorderableTableModel targetTabModel;
    SpatialListReorderableTableWithTitleBar targetTab;
    QueryObject queryObj;

    public SpatialAddGeomQuery() {
        super(TYPE, 3);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == ACTION) {
            String string = SpatialUtil.getPanel().getSelectedTabPage().getCombobox().getCurrentConnectionName();
            if (!SpatialUtil.getPanel().getSelectedTabPage().isConnectionSet() && string != null && string.length() > 0) {
                SpatialUtil.getPanel().getSelectedTabPage().setConnectionAndReturnToTool(string, this);
                return true;
            }
            if (string == null || string.length() < 1 || string.equals("") || !SpatialUtil.getPanel().getSelectedTabPage().isConnectionSet()) {
                string = ConnectionSelectorUI.getConnection((String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_TITLE"), (String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_LABEL"), null, (boolean)true, (boolean)true);
                if (string != null && string.length() > 0) {
                    SpatialUtil.getPanel().getSelectedTabPage().setConnectionAndReturnToTool(string, this);
                }
                return true;
            }
            this.showNewQueryDialog();
            return true;
        }
        return false;
    }

    private QueryObject createQueryObject() {
        String[] stringArray = new String[]{};
        QueryObject queryObject = null;
        this.targetTab = SpatialUtil.getPanel().getSelectedTabPage();
        if (this.targetTab != null) {
            queryObject = new QueryObject(this.queryTitle, this.queryText, this.annoTatedColumn, this.lblColor, this.markerColor, this.markerFill, this.markerSize, this.markerType, this.curveColor, this.curveWidth, this.borderColor, this.areaFillColor, stringArray, this.cnx);
            queryObject.setNewlyCreated();
            queryObject.setPreselected(true);
            queryObject.setConnectionSourceName(this.targetTab.getCurrentConnectionName());
            queryObject.setTabIdentifier(this.tabIdentifier);
        }
        return queryObject;
    }

    private void insertQueryObjectOnTable() {
        if (this.targetTab != null && this.queryObj != null) {
            this.targetTab.setConnectionAndInsertQuery(this.queryObj, this.queryObj.getConnectionSourceName());
        }
    }

    private void insertQueryObjectTask() {
        RaptorTask<Object> raptorTask = new RaptorTask<Object>("Inserting new query object", true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Object doWork() {
                SpatialAddGeomQuery.this.queryObj = SpatialAddGeomQuery.this.createQueryObject();
                return null;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpatialViewController.getInstance().toggleToolbar();
                    }
                });
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpatialViewController.getInstance().toggleToolbar();
                    }
                });
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpatialAddGeomQuery.this.insertQueryObjectOnTable();
                        SpatialViewController.getInstance().toggleToolbar();
                    }
                });
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    @Override
    public boolean isAlwaysEnabled() {
        return true;
    }

    private void showNewQueryDialog() {
        this.targetTabModel = SpatialUtil.getTableModel();
        this.tabIdentifier = this.targetTabModel.getIdentifier().toString();
        this.lblColor = Color.black;
        try {
            this.cnx = Connections.getInstance().getConnection(SpatialUtil.getPanel().getSelectedTabPage().getCombobox().getCurrentConnectionName());
        }
        catch (DBException dBException) {
            return;
        }
        NewQueryModel newQueryModel = new NewQueryModel(this.cnx, (TableModel)((Object)this.targetTabModel));
        NewQueryDialog newQueryDialog = new NewQueryDialog((Frame)new JFrame(), false, newQueryModel);
        NewQueryController newQueryController = new NewQueryController(newQueryModel, newQueryDialog);
        newQueryController.showDialog();
        this.queryTitle = newQueryModel.getQueryTitle();
        this.queryText = newQueryModel.getQueryText();
        this.annoTatedColumn = newQueryModel.getLabelColumn();
        this.markerColor = newQueryModel.getMarker_color();
        this.markerFill = newQueryModel.getMarkerFillColor();
        this.markerSize = newQueryModel.getMarker_size();
        this.markerType = newQueryModel.getMarkerStyle();
        this.curveColor = newQueryModel.getLine_color();
        this.curveWidth = newQueryModel.getLine_width();
        this.borderColor = newQueryModel.getArea_border_color();
        this.areaFillColor = newQueryModel.getArea_fill_color();
        this.lblColor = newQueryModel.getLabelColor();
        if (this.queryTitle.length() > 0 && this.queryText.length() > 0) {
            SpatialViewController.getInstance().lockUI();
            this.insertQueryObjectTask();
        }
    }

    @Override
    public IdeAction getAction() {
        if (this._action == null) {
            this._action = IdeAction.get((int)ACTION);
            this._action.addController((Controller)this);
            this.setEnabled(true);
        }
        return this._action;
    }
}

