/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.dialogs.validate.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.dialogs.validate.model.SpatialValidationGrid;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.IdeUtil;
import oracle.sql.CHAR;

public class ValidateErrors
extends GridContextMenuItem {
    private static ValidateErrors _instance;
    protected static String VALIDATE_ERRORS_TITLE;
    protected static int VALIDATE_ERRORS_ID;
    protected IdeAction VALIDATE_ERRORS = null;
    private String errorString = null;
    JEWTDialog dlg = null;

    private ValidateErrors() {
        this.initAction();
    }

    private void initAction() {
        if (this.VALIDATE_ERRORS == null) {
            this.VALIDATE_ERRORS = this.createAction(VALIDATE_ERRORS_ID, StringUtils.stripMnemonic((String)SpatialArb.getString("ValidateErrors")), null);
        }
    }

    public static ValidateErrors getInstance() {
        if (_instance == null) {
            _instance = new ValidateErrors();
        }
        return _instance;
    }

    protected boolean canShow(ContextMenu contextMenu) {
        this.errorString = null;
        if (contextMenu.getContext().getEvent().getSource() instanceof SpatialValidationGrid) {
            int n = this._table.rowAtPoint(((MouseEvent)contextMenu.getContext().getEvent()).getPoint());
            int n2 = this._table.columnAtPoint(((MouseEvent)contextMenu.getContext().getEvent()).getPoint());
            n = this._table.convertRowIndexToModel(n);
            n2 = this._table.convertColumnIndexToModel(n2);
            String string = this._table.getModel().getColumnName(n2);
            if (string.equals("STATUS")) {
                try {
                    Object object = this._table.getModel().getValueAt(n, n2);
                    if (object instanceof CHAR) {
                        String string2 = ((CHAR)object).stringValue();
                        int n3 = string2.indexOf(" ");
                        String string3 = n3 == -1 ? string2 : string2.substring(0, n3);
                        try {
                            Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.errorString = SpatialArb.getString("NoValidateErrorDetails");
                            return true;
                        }
                        this.errorString = SpatialArb.getString("SpatialError" + string3);
                        if (this.errorString.startsWith("!")) {
                            this.errorString = SpatialArb.getString("NoValidateErrorDetails");
                        }
                        return true;
                    }
                    return false;
                }
                catch (Exception exception) {
                    this.errorString = SpatialArb.getString("NoValidateErrorDetails");
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    protected void createAndShowMenu(ContextMenu contextMenu) {
        JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)this.VALIDATE_ERRORS);
        jMenuItem.setText(SpatialArb.getString("ShowValidationError"));
        contextMenu.add((Component)jMenuItem);
    }

    private void DisplayMessage(String string) {
        PropertyPanel propertyPanel = new PropertyPanel();
        String string2 = SpatialArb.getString("ShowValidationErrorDetails");
        JLabel jLabel = new JLabel(string, 0);
        propertyPanel.addSingleComp((JComponent)jLabel);
        propertyPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)propertyPanel, null, (String)string2, (int)1);
        this.dlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValidateErrors.this.dlg.dispose();
            }
        });
        Dimension dimension = propertyPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 100;
        this.dlg.setSize(n2, n);
        this.dlg.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.setVisible(true);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == VALIDATE_ERRORS_ID) {
            System.out.println("Error to show: " + this.errorString);
            this.DisplayMessage(this.errorString);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    static {
        VALIDATE_ERRORS_TITLE = "ValidateErrors";
        VALIDATE_ERRORS_ID = Ide.findOrCreateCmdID((String)VALIDATE_ERRORS_TITLE);
    }
}

