/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbbridge;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.osgi.framework.BundleException;

public class IdeClassLoadingHook
implements ClassLoadingHook,
HookConfigurator {
    private static final String APPLY_PATCHES_KEY = "oracle.ide.apply.patches";
    private static final String EMMA_PROPERTY = "ide.testcoverage.emma";
    private final Map<String, String> m_bundleId2PatchJarPath;
    private boolean m_applyPatchesProcessed = false;
    private boolean m_emmaCoverageRun = false;
    private boolean m_isDebugBuild = "true".equals(System.getProperty("ide.debugbuild"));
    private String m_oracleHome = System.getProperty("ORACLE_HOME");

    public IdeClassLoadingHook() {
        this.m_bundleId2PatchJarPath = new HashMap<String, String>();
        String coverage = System.getProperty(EMMA_PROPERTY);
        if ("true".equals(coverage)) {
            this.m_emmaCoverageRun = true;
        }
    }

    public byte[] processClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        return null;
    }

    public boolean addClassPathEntry(ArrayList cpEntries, String cp, ClasspathManager hostmanager, BaseData sourcedata, ProtectionDomain sourcedomain) {
        boolean entriesAdded;
        block14: {
            String bundleId;
            entriesAdded = false;
            if (!this.m_applyPatchesProcessed) {
                this.parsePatches(System.getProperty(APPLY_PATCHES_KEY));
            }
            if (this.m_bundleId2PatchJarPath.containsKey(bundleId = sourcedata.getSymbolicName())) {
                File patchesFile;
                BundleFile bundlefile;
                boolean containPatchesEntry = false;
                for (ClasspathEntry nextCPEntry : cpEntries) {
                    if (!(nextCPEntry instanceof PatchClassPathEntry)) continue;
                    containPatchesEntry = true;
                    break;
                }
                if (!containPatchesEntry && (bundlefile = IdeClassLoadingHook.createBundleFile(patchesFile = new File(this.m_bundleId2PatchJarPath.get(bundleId)), sourcedata)) != null) {
                    ClasspathEntry cpEntry = this.createClassPathEntry(bundlefile, sourcedomain);
                    cpEntries.add(0, cpEntry);
                    entriesAdded = true;
                }
            }
            if (this.m_isDebugBuild) {
                try {
                    File classesDir;
                    Dictionary dictionary = sourcedata.getManifest();
                    String projectName = (String)dictionary.get("Oracle-ProjectName");
                    if (projectName == null) break block14;
                    String projectType = (String)dictionary.get("Oracle-ProjectType");
                    String classesDirTail = "/built/" + projectName + ("JUNIT".equals(projectType) ? "/junit-classes" : "/classes");
                    boolean addClassesDir = true;
                    for (ClasspathEntry entry : cpEntries) {
                        if (entry instanceof ProjectClassPathEntry) {
                            addClassesDir = false;
                            break;
                        }
                        BundleFile bf = entry.getBundleFile();
                        File baseFile = bf.getBaseFile();
                        String filepath = baseFile.getAbsolutePath().replace('\\', '/');
                        if (!filepath.endsWith(classesDirTail)) continue;
                        addClassesDir = false;
                        break;
                    }
                    if (!addClassesDir || !(classesDir = new File(this.m_oracleHome + classesDirTail)).exists()) break block14;
                    BundleFile bundleFile = IdeClassLoadingHook.createBundleFile(classesDir, sourcedata);
                    if (sourcedomain == null) {
                        try {
                            sourcedomain = new ProtectionDomain(new CodeSource(new URL("file:" + classesDir), (Certificate[])null), null);
                        }
                        catch (MalformedURLException bf) {
                            // empty catch block
                        }
                    }
                    ProjectClassPathEntry newEntry = new ProjectClassPathEntry(bundleFile, sourcedomain);
                    cpEntries.add(0, newEntry);
                    entriesAdded = true;
                }
                catch (BundleException ex) {
                    sourcedata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, sourcedata.getBundle(), (Throwable)ex);
                }
            }
        }
        if (this.m_emmaCoverageRun) {
            ArrayList<ClasspathEntry> additions = new ArrayList<ClasspathEntry>();
            for (ClasspathEntry entry : cpEntries) {
                BundleFile bf = entry.getBundleFile();
                File baseFile = bf.getBaseFile();
                String filepath = baseFile.getAbsolutePath();
                if (!filepath.endsWith("classes")) continue;
                String icpath = filepath.substring(0, filepath.length() - "classes".length());
                File instrumentedDir = new File(icpath = icpath + "classes-instrumented");
                if (!instrumentedDir.exists()) continue;
                BundleFile instrumentedBundleFile = IdeClassLoadingHook.createBundleFile(instrumentedDir, sourcedata);
                ClasspathEntry newEntry = new ClasspathEntry(instrumentedBundleFile, sourcedomain);
                additions.add(newEntry);
                entriesAdded = true;
            }
            cpEntries.addAll(0, additions);
        }
        return entriesAdded;
    }

    public String findLibrary(BaseData data, String libName) {
        return null;
    }

    public ClassLoader getBundleClassLoaderParent() {
        return null;
    }

    public BaseClassLoader createClassLoader(ClassLoader parent, ClassLoaderDelegate delegate, BundleProtectionDomain domain, BaseData data, String[] bundleclasspath) {
        return null;
    }

    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData data) {
    }

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addClassLoadingHook((ClassLoadingHook)this);
    }

    private static BundleFile createBundleFile(Object content, BaseData sourcedata) {
        try {
            return sourcedata.getAdaptor().createBundleFile(content, sourcedata);
        }
        catch (IOException e) {
            sourcedata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, sourcedata.getBundle(), (Throwable)e);
            return null;
        }
    }

    private ClasspathEntry createClassPathEntry(BundleFile bundlefile, ProtectionDomain cpDomain) {
        return new PatchClassPathEntry(bundlefile, cpDomain);
    }

    private void parsePatches(String applyPatchesValue) {
        if (applyPatchesValue != null) {
            String[] patchInfos;
            for (String patchInfo : patchInfos = applyPatchesValue.split(";")) {
                String[] tuple = patchInfo.split(",");
                if (tuple.length != 2) continue;
                this.m_bundleId2PatchJarPath.put(tuple[0], tuple[1]);
            }
        }
        this.m_applyPatchesProcessed = true;
    }

    private static class ProjectClassPathEntry
    extends ClasspathEntry {
        public ProjectClassPathEntry(BundleFile bundlefile, ProtectionDomain domain) {
            super(bundlefile, domain);
        }
    }

    private static class PatchClassPathEntry
    extends ClasspathEntry {
        public PatchClassPathEntry(BundleFile bundlefile, ProtectionDomain domain) {
            super(bundlefile, domain);
        }
    }
}

