/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import oracle.dbtools.apex.ErrorResponses;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.MissingFormFieldException;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeadersBuilder;
import oracle.dbtools.rt.locale.LocalePreference;
import oracle.dbtools.rt.web.CustomHttpHeader;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpHeaderValue;
import oracle.dbtools.rt.web.HttpStatusCode;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.ResponseException;

public class WebException
extends ResponseException {
    private Iterable<String> allowableMethods;
    private boolean publicResource = true;
    private final List<Reason> reasons = new ArrayList<Reason>();
    private final HttpStatusCode statusCode;
    private static final long serialVersionUID = -62800217304156797L;

    protected WebException(HttpStatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public Iterable<String> allowableMethods() {
        return this.allowableMethods;
    }

    public WebException cause(Throwable cause) {
        this.initCause(cause);
        return this;
    }

    @Override
    public String getMessage() {
        if (this.statusCode == HttpStatusCode.BAD_REQUEST || this.reasons.size() > 0) {
            return Iterables.join(this.reasons, (String)" ");
        }
        if (this.statusCode == HttpStatusCode.INTERNAL_SERVER_ERROR) {
            return this.getCause().getMessage();
        }
        return super.getMessage();
    }

    public boolean isError() {
        return ErrorResponses.isError((int)this.statusCode.statusCode());
    }

    public Iterable<Reason> reasons() {
        return this.reasons;
    }

    public WebException reasons(Iterable<Reason> reasons) {
        Iterables.add(this.reasons, reasons);
        return this;
    }

    public WebException reasons(Reason ... reasons) {
        this.reasons(Iterables.iterable((Object[])reasons));
        return this;
    }

    @Override
    public Entity response(RequestEntity request) throws IOException {
        Iterator<Reason> reasons;
        LocalePreference localePreference = LocalePreference.preference(request);
        EntityHeadersBuilder headers = Entities.headers();
        headers.header((CharSequence)"X-APEX-STATUS-CODE", Integer.toString(this.statusCode().statusCode()));
        if (HttpStatusCode.METHOD_NOT_ALLOWED == this.statusCode) {
            headers.header((CharSequence)HttpHeader.ALLOW, Iterables.join(this.allowableMethods(), (String)", "));
        }
        if ((reasons = this.reasons().iterator()).hasNext()) {
            ArrayList<HttpHeaderValue> allErrors = new ArrayList<HttpHeaderValue>();
            while (reasons.hasNext()) {
                HttpHeaderValue.Builder errors = HttpHeaderValue.builder();
                Reason reason = reasons.next();
                String error = reason.target();
                if (NullOrEmpty.nullOrEmpty((CharSequence)error)) continue;
                errors.parameter("error", error);
                String description = reason.toString((Iterable<Locale>)((Object)localePreference));
                if (!NullOrEmpty.nullOrEmpty((CharSequence)description)) {
                    errors.extendedParameter("error_description", description);
                }
                allErrors.add(errors.build());
            }
            headers.header((CharSequence)CustomHttpHeader.ERROR_REASON, Iterables.join(allErrors, (String)", "));
        }
        if (!this.publicResource) {
            headers.header((CharSequence)"X-APEX-PUBLIC", "false");
        }
        return Entities.entity(null, headers.build());
    }

    public HttpStatusCode statusCode() {
        return this.statusCode;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WebException [statusCode=");
        builder.append(this.statusCode);
        if (!NullOrEmpty.nullOrEmpty(this.reasons)) {
            builder.append(", reasons=");
            builder.append(this.reasons);
        }
        if (!NullOrEmpty.nullOrEmpty(this.allowableMethods)) {
            builder.append(", allowableMethods=");
            builder.append(this.allowableMethods);
        }
        builder.append("]");
        return builder.toString();
    }

    WebException allowableMethods(Iterable<String> allowableMethods) {
        this.allowableMethods = allowableMethods;
        return this;
    }

    WebException publicResource(boolean protectedResource) {
        this.publicResource = protectedResource;
        return this;
    }

    public static WebException badRequest(Iterable<Reason> reasons) {
        return WebException.webException(HttpStatusCode.BAD_REQUEST).reasons(reasons);
    }

    public static WebException badRequest(MissingFormFieldException missingField) {
        return WebException.webException(HttpStatusCode.BAD_REQUEST).reasons(Reason.reason(missingField.missingField(), missingField.getTranslatableMessage())).cause(missingField);
    }

    public static WebException badRequest(Reason ... reasons) {
        return WebException.badRequest(Iterables.iterable((Object[])reasons));
    }

    public static WebException forbidden() {
        return WebException.webException(HttpStatusCode.FORBIDDEN);
    }

    public static WebException internalError(Throwable cause, Reason ... reasons) {
        WebException e = WebException.webException(HttpStatusCode.INTERNAL_SERVER_ERROR);
        if (cause != null) {
            e.cause(cause);
        }
        e.reasons(Iterables.iterable((Object[])reasons));
        return e;
    }

    public static WebException methodNotAllowed(Iterable<String> allowableMethods) {
        return WebException.webException(HttpStatusCode.METHOD_NOT_ALLOWED).allowableMethods(allowableMethods);
    }

    public static WebException notAuthorized() {
        return WebException.webException(HttpStatusCode.UNAUTHORIZED);
    }

    public static WebException notFound() {
        return WebException.webException(HttpStatusCode.NOT_FOUND);
    }

    public static WebException notModified() {
        return WebException.webException(HttpStatusCode.NOT_MODIFIED);
    }

    public static WebException preconditionFailed() {
        return WebException.webException(HttpStatusCode.PRECONDITION_FAILED);
    }

    public static WebException serviceUnavailable() {
        return WebException.webException(HttpStatusCode.SERVICE_UNAVAILABLE);
    }

    public static WebException unsupportedMediaType() {
        return WebException.webException(HttpStatusCode.UNSUPPORTED_MEDIA_TYPE);
    }

    static WebException webException(HttpStatusCode statusCode) {
        return new WebException(statusCode);
    }
}

