/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import oracle.dbtools.apex.ErrorResponse;
import oracle.dbtools.common.TranslatableException;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.web.HasResponse;
import oracle.dbtools.rt.web.HasSessionAttributes;
import oracle.dbtools.rt.web.HttpStatusCode;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.ResponseException;
import oracle.dbtools.rt.web.WebException;

class WebErrorResponse
implements ErrorResponse,
HasResponse,
HasSessionAttributes {
    private ResponseException cause;
    private final ByteArrayOutputStream errorContent = new ByteArrayOutputStream();
    private static final Log LOG = Log.get(WebErrorResponse.class);

    WebErrorResponse() {
    }

    public void badRequest(String target, TranslatableMessage msg) {
        this.error(WebException.badRequest(Reason.reason(target, (Translatable)msg)));
    }

    public void error(int statusCode) {
        this.error(WebException.webException(HttpStatusCode.valueOf(statusCode)));
    }

    public void error(ResponseException cause) {
        this.cause = cause;
    }

    public void error(Throwable cause) {
        if (cause instanceof ResponseException) {
            this.error((ResponseException)cause);
        } else {
            this.internalError(cause);
        }
    }

    public ServletOutputStream getOutputStream(ServletOutputStream target) throws IOException {
        return new DeferErrorOuput(target);
    }

    public void internalError(Throwable cause) {
        LOG.severe(cause);
        this.error(WebException.internalError(cause, new Reason[0]));
    }

    public void methodNotAllowed(String method, String ... supportedMethods) {
        this.error(WebException.methodNotAllowed(Iterables.iterable((Object[])supportedMethods)));
    }

    public void notFound() {
        this.error(WebException.notFound());
    }

    public void notFound(Throwable cause) {
        this.error(WebException.notFound().cause(cause));
    }

    public void reset() throws IOException {
        this.cause = null;
        this.errorContent.close();
        this.errorContent.reset();
    }

    @Override
    public Entity response(RequestEntity request) throws IOException {
        if (this.hasError()) {
            return this.cause.response(request);
        }
        return null;
    }

    public void serviceUnavailable(Throwable cause) {
        WebException e = WebException.serviceUnavailable().cause(cause);
        if (cause instanceof TranslatableException) {
            Translatable msg = ((TranslatableException)cause).getTranslatableMessage();
            e.reasons(Reason.reason("cause", msg));
        }
        this.error(e);
    }

    @Override
    public AssociativeArray<String, Object> session() {
        if (this.cause instanceof HasSessionAttributes) {
            return ((HasSessionAttributes)((Object)this.cause)).session();
        }
        return AssociativeArrays.empty();
    }

    protected boolean hasError() {
        return this.cause != null;
    }

    ResponseException cause() {
        return this.cause;
    }

    InputStream errorContent() {
        return new ByteArrayInputStream(this.errorContent.toByteArray());
    }

    final class DeferErrorOuput
    extends ServletOutputStream {
        private final ServletOutputStream target;

        private DeferErrorOuput(ServletOutputStream target) {
            this.target = target;
        }

        public void flush() throws IOException {
            if (WebErrorResponse.this.hasError()) {
                WebErrorResponse.this.errorContent.flush();
            } else {
                this.target.flush();
            }
        }

        public void write(byte[] b) throws IOException {
            if (WebErrorResponse.this.hasError()) {
                WebErrorResponse.this.errorContent.write(b);
            } else {
                this.target.write(b);
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (WebErrorResponse.this.hasError()) {
                WebErrorResponse.this.errorContent.write(b, off, len);
            } else {
                this.target.write(b, off, len);
            }
        }

        public void write(int b) throws IOException {
            if (WebErrorResponse.this.hasError()) {
                WebErrorResponse.this.errorContent.write(b);
            } else {
                this.target.write(b);
            }
        }

        public boolean isReady() {
            return this.target.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.target.setWriteListener(writeListener);
        }
    }
}

