/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.util.logging.Level;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import oracle.dbtools.apex.cache.CacheManager;
import oracle.dbtools.apex.hooks.ProcessorRegistry;
import oracle.dbtools.apex.security.Security;
import oracle.dbtools.common.app.ApplicationContext;
import oracle.dbtools.common.app.Version;
import oracle.dbtools.common.config.ConfigurationsProviders;
import oracle.dbtools.common.config.GlobalConfiguration;
import oracle.dbtools.common.config.db.DatabaseConfig;
import oracle.dbtools.common.config.dir.ConfigDir;
import oracle.dbtools.common.config.file.ConfigurationFolder;
import oracle.dbtools.common.di.Services;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.ResourceTracker;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.http.servlet.ServletLogAdapter;
import oracle.dbtools.plugin.api.logging.Log;
import oracle.dbtools.rt.web.ForceSecure;
import oracle.dbtools.rt.web.PermGenLeaks;
import oracle.dbtools.rt.web.Requests;

public class SCListener
implements ServletContextListener {
    private boolean initialized = false;

    public void contextDestroyed(ServletContextEvent evt) {
        ServletContext ctx = evt.getServletContext();
        ServletLogAdapter log = new ServletLogAdapter(ctx);
        if (this.initialized) {
            ResourceTracker.reset();
            try {
                DatabaseConfig.teardown();
                ApplicationContext app = (ApplicationContext)ctx.getAttribute(ApplicationContext.APPLICATION_CONTEXT);
                Closeables.close((Object)app);
                ForceSecure.instance().teardown(ConfigurationsProviders.instance());
                ServiceLocator.teardown();
                ConfigurationsProviders.instance().teardown();
                ConfigurationFolder.INSTANCE.teardown();
            }
            catch (RuntimeException e) {
                log.warning((Throwable)e);
                throw e;
            }
            finally {
                ResourceTracker.dumpAndClearLeaks();
            }
            ResourceTracker.teardown();
            PermGenLeaks.teardown();
        }
    }

    public synchronized void contextInitialized(ServletContextEvent evt) {
        ServletContext ctx = evt.getServletContext();
        ServletLogAdapter log = new ServletLogAdapter(ctx);
        if (!this.initialized) {
            this.initialized = true;
            PermGenLeaks.setup();
            ResourceTracker.setup();
            ResourceTracker.reset();
            try {
                ConfigDir configDir = new ConfigDir(ctx.getContextPath(), ctx, System.getProperties());
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                ConfigurationFolder.INSTANCE.setup(ctx.getContextPath(), configDir.location());
                ConfigurationsProviders.instance().setup();
                ApplicationContext app = new ApplicationContext(configDir.location(), (Appendable)System.out, (Appendable)System.err, ApplicationContext.loadServices((ClassLoader)classLoader));
                ConfigurationFolder.INSTANCE.logConfigFolder((Log)log);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("\n" + app.toString() + "\n");
                }
                DatabaseConfig.setup((Services)app.services());
                ctx.setAttribute(ApplicationContext.APPLICATION_CONTEXT, (Object)app);
                ServiceLocator.setup((ClassLoader)classLoader);
                ServiceLocator.activateImmediates();
                if (this.isStandaloneServer(ctx)) {
                    Requests.verifyTransport(false);
                }
                CacheManager.setup();
                Security.setup();
                ForceSecure.instance().setup(ConfigurationsProviders.instance());
                String exts = GlobalConfiguration.globalConfiguration().get("apex.extensions");
                if (exts != null) {
                    ProcessorRegistry.register((String[])Text.commaDelimited((String)exts));
                }
                String serverInfo = ctx.getServerInfo();
                StringBuilder msg = new StringBuilder();
                String productName = Version.INSTANCE.getProductName();
                msg.append(productName);
                msg.append(" initialized\n");
                msg.append(productName);
                msg.append(" version : ");
                msg.append(Version.INSTANCE.getVersion());
                msg.append("\n");
                msg.append(productName);
                msg.append(" server info: ");
                msg.append(serverInfo);
                msg.append("\n");
                if (log.isLoggable(Log.INFO)) {
                    log.info(msg.toString());
                }
            }
            catch (Throwable t) {
                log.severe(t);
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
            finally {
                ResourceTracker.dumpAndClearLeaks();
            }
        }
    }

    private boolean isStandaloneServer(ServletContext ctx) {
        String serverInfo = ctx.getServerInfo();
        return serverInfo.contains("jetty");
    }
}

