/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.authentication.SecurityConfigs;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RedirectException;
import oracle.dbtools.rt.web.RequestDispatchers;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.ResourceDispatcher;
import oracle.dbtools.rt.web.WebException;

public abstract class ReTargetingDispatcher<T extends Target>
implements ResourceDispatcher {
    @Reference
    private RequestDispatchers dispatchers;

    @Override
    public ResourceDispatcher.Score canDispatch(RequestEntity request) {
        RequestEntity modifiedRequest;
        ResourceDispatcher.Score score;
        RequestEntity headersOnly = this.hideBody(request);
        T target = this.target(headersOnly);
        if (target != null && ResourceDispatcher.Score.isMatch(score = this.dispatchers.canDispatch(modifiedRequest = this.modifyRequestHeadersAndPrincipal(target, headersOnly)))) {
            ((Target)target).modifiedRequest = modifiedRequest;
            ((Target)target).score = score;
            return new ResourceDispatcher.Score(score.score() + 1, SecurityConfigs.NONE, target, new String[0]);
        }
        return ResourceDispatcher.NO_MATCH;
    }

    @Override
    public HttpResource dispatch(ResourceDispatcher.Score score, RequestEntity request) throws IOException {
        String actualPath;
        RequestEntity modifiedHeaders;
        if (score == null) {
            throw WebException.badRequest(Reason.reason("target", (Translatable)new TranslatableMessage(ResourceTemplateMessages.class, "ReTargetingDispatcher.0", "Could not determine the original target of this request", new Object[0])));
        }
        String originalPath = request.path();
        Target target = (Target)score.handle();
        if (target == null) {
            throw WebException.badRequest(Reason.reason("target", (Translatable)new TranslatableMessage(ResourceTemplateMessages.class, "ReTargetingDispatcher.1", "Could not find a target service to consume this request", new Object[0])));
        }
        RequestEntity newRequest = modifiedHeaders = target.modifiedRequest;
        if (Requests.hasContent(request)) {
            Entity modifiedBody = null;
            modifiedBody = this.modifyRequestBody(target, modifiedHeaders, request.body());
            if (modifiedBody == null) {
                modifiedBody = Entities.entity(request.body(), modifiedHeaders.headers());
            }
            newRequest = Requests.merge(modifiedHeaders, modifiedBody);
        }
        if ((actualPath = newRequest.path()).equals(originalPath)) {
            throw WebException.internalError(new IllegalStateException("The forwarded path is the same as the originally requested path"), new Reason[0]);
        }
        String reTargettedBase = newRequest.base();
        try {
            HttpResource resource = this.dispatchers.dispatch(target.score, newRequest);
            return new RetargetedResource(this, reTargettedBase, target, resource);
        }
        catch (RedirectException e) {
            throw this.rebase(reTargettedBase, e);
        }
    }

    protected Entity modifyRequestBody(T target, RequestEntity modifiedRequestHeaders, InputStream originalRequestBody) throws IOException {
        return null;
    }

    protected EntityHeaders modifyRequestHeaders(T target, RequestEntity request) {
        return null;
    }

    protected CompoundPrincipal modifyRequestPrincipal(T target, RequestEntity request) {
        return null;
    }

    protected Entity modifyResponse(T target, Entity response) throws IOException {
        return null;
    }

    protected abstract T target(RequestEntity var1);

    private RequestEntity hideBody(RequestEntity request) {
        try {
            Entity noBody = Entities.entity(null, request.headers());
            return Requests.merge(request, noBody);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private RequestEntity modifyRequestHeadersAndPrincipal(T target, RequestEntity headersOnly) {
        EntityHeaders modifedRequestHeaders = this.modifyRequestHeaders(target, headersOnly);
        RequestEntity modifiedRequest = Requests.forward(headersOnly, ((Target)target).target(), false, modifedRequestHeaders);
        CompoundPrincipal modifiedPrincipal = this.modifyRequestPrincipal(target, headersOnly);
        if (modifiedPrincipal == null) {
            return modifiedRequest;
        }
        return Requests.replacePrincipal(modifiedRequest, (Principal)modifiedPrincipal, CompoundPrincipal.class);
    }

    private RedirectException rebase(String reTargettedBase, RedirectException e) {
        return RedirectException.rebase(reTargettedBase, e);
    }

    private static final class RetargetedResource
    implements HttpResource {
        private final HttpResource resource;
        private final String reTargettedBase;
        private final T target;
        final /* synthetic */ ReTargetingDispatcher this$0;

        private RetargetedResource(String reTargettedBase, T target, HttpResource resource) {
            this.this$0 = var1_1;
            this.reTargettedBase = reTargettedBase;
            this.target = target;
            this.resource = resource;
        }

        @Override
        public Entity response(RequestEntity request) throws IOException {
            try {
                Entity response = this.resource.response(request);
                Entity modified = this.this$0.modifyResponse(this.target, response);
                if (modified == null) {
                    return response;
                }
                return modified;
            }
            catch (RedirectException e) {
                throw this.this$0.rebase(this.reTargettedBase, e);
            }
        }

        @Override
        public String version() {
            return this.resource.version();
        }
    }

    public static class Target {
        RequestEntity modifiedRequest;
        ResourceDispatcher.Score score;
        private final String target;

        public Target(String target) {
            this.target = target;
        }

        public String documentBase() {
            return Requests.documentBase(this.modifiedRequest);
        }

        public String target() {
            return this.target;
        }
    }
}

