/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.dbtools.common.config.db.InvalidBaseException;
import oracle.dbtools.common.diagnostics.DiagnosticContext;
import oracle.dbtools.common.diagnostics.Diagnostics;
import oracle.dbtools.common.ecid.ECIDPrincipals;
import oracle.dbtools.common.immutables.Immutables;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.ResourceTracker;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.http.entrypoint.EntryPointServlet;
import oracle.dbtools.http.servlet.NormalizedHttpServletRequest;
import oracle.dbtools.rt.web.AbsoluteLocationHeader;
import oracle.dbtools.rt.web.ForceSecure;
import oracle.dbtools.rt.web.RedirectException;
import oracle.dbtools.rt.web.WebErrorResponse;
import oracle.dbtools.rt.web.WebErrorResponses;

public class HttpEndpointBase
extends HttpServlet {
    private static final boolean DISPATCHABLES_ENABLED = true;
    private static final Log LOG = Log.get(HttpEndpointBase.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse servletResponse) throws ServletException, IOException {
        long millisStart = System.currentTimeMillis();
        long dispatchableDuration = 0L;
        request.setAttribute("nanoStart", (Object)millisStart);
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding(Text.defaultEncoding());
        }
        request = new NormalizedHttpServletRequest(request);
        ECIDPrincipals.ecidPrincipal((HttpServletRequest)request, (boolean)true);
        request = ForceSecure.instance().apply(request);
        servletResponse = AbsoluteLocationHeader.apply(request, servletResponse);
        ResourceTracker.reset();
        try {
            this.diagnostics().diagnosticContext(request, true);
            WebErrorResponse errors = this.errorResponses().errorResponse();
            try {
                try {
                    long dispatchStart = System.currentTimeMillis();
                    try {
                        this.debug(request, "Attempting to process as a Dispatchable Service");
                        this.dispatchableServices(request, servletResponse);
                    }
                    catch (Throwable t) {
                        errors.error(t);
                    }
                    dispatchableDuration = System.currentTimeMillis() - dispatchStart;
                }
                catch (InvalidBaseException e) {
                    this.debug(request, "Request URL is missing trailing slash, doing permanent redirect to correct location");
                    errors.error(RedirectException.permanentRedirect(e.correctBase()));
                }
            }
            finally {
                if (errors.hasError()) {
                    LOG.severe((Throwable)errors.cause());
                    throw new ServletException("Errors leaked to legacy entrypoint", (Throwable)errors.cause());
                }
            }
        }
        finally {
            ResourceTracker.dumpAndClearLeaks();
            long millisDuration = System.currentTimeMillis() - millisStart;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("request duration: " + millisDuration + "ms, " + Immutables.maps().builder().add((Object)"dispatchables", (Object)dispatchableDuration).build());
            }
        }
    }

    private void debug(HttpServletRequest request, CharSequence msg) {
        this.diagnosticContext(request).log(msg);
    }

    private DiagnosticContext diagnosticContext(HttpServletRequest req) {
        try {
            Diagnostics diagnostics = (Diagnostics)ServiceLocator.acquire(Diagnostics.class);
            return diagnostics.diagnosticContext(req);
        }
        catch (Throwable t) {
            LOG.fine(t);
            return DiagnosticContext.DISABLED;
        }
    }

    private final Diagnostics diagnostics() {
        return (Diagnostics)ServiceLocator.acquire(Diagnostics.class);
    }

    private void dispatchableServices(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        EntryPointServlet servlet = new EntryPointServlet();
        servlet.init(this.getServletConfig());
        servlet.service((ServletRequest)request, (ServletResponse)response);
    }

    private WebErrorResponses errorResponses() {
        return (WebErrorResponses)ServiceLocator.acquire(WebErrorResponses.class);
    }
}

