/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import oracle.dbtools.common.util.QueryString;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.rt.web.BaseAndPath;
import oracle.dbtools.rt.web.HttpHeader;

class AbsoluteLocationHeader
extends HttpServletResponseWrapper {
    private final URI documentBase;

    protected AbsoluteLocationHeader(URI documentBase, HttpServletResponse response) {
        super(response);
        this.documentBase = documentBase;
    }

    public void addHeader(String name, String value) {
        value = this.resolve(name, value);
        super.addHeader(name, value);
    }

    public void sendRedirect(String location) throws IOException {
        location = this.resolve(location);
        super.sendRedirect(location);
    }

    public void setHeader(String name, String value) {
        value = this.resolve(name, value);
        super.setHeader(name, value);
    }

    private final String resolve(String location) {
        String normalized = QueryString.parse((String)location).toString();
        String resolved = URIs.resolve((URI)this.documentBase, (String)normalized).toASCIIString();
        return resolved;
    }

    private String resolve(String name, String value) {
        if (HttpHeader.LOCATION.matches(name)) {
            value = this.resolve(value);
        }
        return value;
    }

    public static HttpServletResponse apply(HttpServletRequest request, HttpServletResponse response) {
        String[] baseAndPath = BaseAndPath.baseAndPath(request);
        String documentBase = BaseAndPath.documentBase(baseAndPath[0], baseAndPath[1]);
        URI documentBaseUri = URIs.create((String)documentBase);
        return new AbsoluteLocationHeader(documentBaseUri, response);
    }
}

