/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.TreeReader;
import oracle.dbtools.common.x3p.X3PFactory;
import oracle.dbtools.common.x3p.X3PReader;
import oracle.dbtools.common.x3p.X3PWriterOptions;
import oracle.dbtools.common.zip.ZipBuilder;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.home.StoreMode;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantEntityTreeStorage;
import oracle.dbtools.rt.oauth.OAuthProfile;
import oracle.dbtools.rt.oauth.scope.Scope;
import oracle.dbtools.rt.oauth.scope.ScopeReader;
import oracle.dbtools.rt.oauth.scope.Scopes;
import oracle.dbtools.rt.resource.templates.v2.ResourceModule;
import oracle.dbtools.rt.resource.templates.v2.ResourceModuleReader;
import oracle.dbtools.rt.resource.templates.v2.ResourceModules;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplatesProfile;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.uri.URITemplates;
import oracle.dbtools.rt.validation.Validator;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResources;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.RequestHandlerMetaData;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.ResourceDispatcher;

@Service(provides={ResourceDispatcher.class})
public class ResourceModulesService
extends RequestHandler {
    @Reference
    protected Validator validator;
    @Reference
    private ResourceModules modules;
    @Reference
    private Scopes scopes;
    @Reference
    private TenantEntityTreeStorage storage;
    public static final String PATH = ResourceTemplatesProfile.URI_TEMPLATES.collection().encode(new String[0]) + "exports.zip";
    public static final URITemplate URI_TEMPLATE = URITemplates.uriTemplate(PATH);
    static final RequestHandlerMetaData META_DATA = ResourceModulesService.secureService(PATH.toString(), HttpMethod.GET, HttpMethod.PUT);
    static final ContentType ZIP_MEDIA_TYPE = ContentType.contentType((CharSequence)((Object)ContentTypes.ZIP));
    private static final ContentType JAR_MEDIA_TYPE = ContentType.contentType("application/java-archive");
    private static final String MODULE_FILE_EXTENSION = ".ormx";
    private static final Log LOG = Log.get(ResourceModulesService.class);
    private static final String SCOPE_FILE_EXTENSION = ".orsj";

    public ResourceModulesService() {
        super(META_DATA);
    }

    protected TreeReader<TenantEntity> entityGraphReader() {
        return new ResourceModuleReader(this.validator);
    }

    @Override
    protected Entity get(RequestEntity request) throws IOException {
        Transaction txn = this.modules.newTransaction(request.principal());
        InputStream zipStream = this.compressedResourceModules(txn, request.principal());
        return ResourceModulesService.entity(zipStream, ResourceModulesService.headers(new CharSequence[]{HttpHeader.CONTENT_TYPE, ContentTypes.ZIP, "Content-Disposition", "attachment; filename=resources.zip"}), txn);
    }

    @Override
    protected Entity put(RequestEntity request) throws IOException {
        Requests.acceptable(request, ZIP_MEDIA_TYPE, JAR_MEDIA_TYPE);
        this.create(request.principal(), request.contentType(), request.body());
        return HttpResources.NO_CONTENT;
    }

    private InputStream cdata(InputStream content) throws IOException {
        X3PReader r = X3PFactory.newReader((InputStream)content);
        return X3PFactory.newStream((X3PReader)r, (X3PWriterOptions)ResourceTemplatesProfile.DEFAULT_SERIALIZATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream compressedResourceModules(Transaction txn, CompoundPrincipal principal) throws IOException {
        ZipBuilder zip = ZipBuilder.builder();
        Iterable<ResourceModule> resourceModules = null;
        Iterable<Scope> scopes = null;
        try {
            String name;
            resourceModules = this.modules.modules(txn, principal);
            for (ResourceModule module : resourceModules) {
                name = this.name(module);
                zip.addEntry(name, this.cdata(this.modules.content(principal, module)));
            }
            scopes = this.scopes.entities(txn, principal);
            for (Scope scope : scopes) {
                name = this.name(scope);
                zip.addEntry(name, scope.content());
            }
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new Object[]{scopes, resourceModules});
            throw throwable;
        }
        Closeables.close((Object[])new Object[]{scopes, resourceModules});
        return zip.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create(CompoundPrincipal principal, ContentType contentType, InputStream content) throws IOException {
        ZipInputStream zip = null;
        try {
            zip = new ZipInputStream(content);
            InputStream dontClose = StreamCopy.uncloseable((InputStream)zip);
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                ContentType entryContentType = this.contentType(entry);
                if (entryContentType == null) {
                    LOG.fine("Ignoring resource named: " + entry.getName());
                } else {
                    this.create(principal, entryContentType, dontClose, StoreMode.OVERWRITE);
                }
                entry = zip.getNextEntry();
            }
        }
        catch (Throwable throwable) {
            Closeables.close(zip);
            throw throwable;
        }
        Closeables.close((Object)zip);
    }

    private ContentType contentType(ZipEntry entry) {
        String name = entry.getName();
        if (name.endsWith(MODULE_FILE_EXTENSION)) {
            return ResourceTemplatesProfile.MEDIA_TYPE;
        }
        if (name.endsWith(SCOPE_FILE_EXTENSION)) {
            return OAuthProfile.OAUTH_SCOPE_JSON;
        }
        return null;
    }

    private void create(CompoundPrincipal principal, ContentType contentType, InputStream content, StoreMode mode) throws IOException {
        if (ResourceTemplatesProfile.MEDIA_TYPE.matches(contentType)) {
            this.storage.store(principal, null, content, this.entityGraphReader(), mode);
        } else if (OAuthProfile.OAUTH_SCOPE_JSON.matches(contentType)) {
            this.storage.store(principal, null, content, this.scopesReader(), mode);
        } else {
            throw new IllegalStateException();
        }
    }

    private String name(ResourceModule module) {
        String name = module.name() + MODULE_FILE_EXTENSION;
        return name;
    }

    private String name(Scope scope) {
        return scope.name() + SCOPE_FILE_EXTENSION;
    }

    private TreeReader<TenantEntity> scopesReader() {
        return new ScopeReader();
    }
}

