/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.jdbc;

import java.io.IOException;
import java.io.Reader;
import java.security.Principal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCTransaction;
import oracle.dbtools.common.query.ColumnIterator;
import oracle.dbtools.common.query.QueryProvider;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifiers;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;
import oracle.dbtools.rt.resource.templates.jdbc.JDBCResourceHandler;
import oracle.dbtools.rt.resource.templates.jdbc.JDBCResourceTemplate;
import oracle.dbtools.rt.resource.templates.v2.HasResourceTemplates;
import oracle.dbtools.rt.resource.templates.v2.ResourceHandler;
import oracle.dbtools.rt.resource.templates.v2.ResourceModule;
import oracle.dbtools.rt.resource.templates.v2.ResourceParameter;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplate;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.SecurityConstraint;
import oracle.dbtools.rt.web.WebException;

final class JDBCResourceTemplates
implements HasResourceTemplates {
    private final QueryProvider query;
    private static final Log LOG = Log.get(JDBCResourceTemplates.class);
    private static final String SUPPORTED_METHODS = "select handler_method from wwv_flow_rt$services where security_group_id  in (:tenant_id,10) and template_id = :id";
    private static final Statement SUPPORTED_METHODS_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.query().append((CharSequence)"select handler_method from wwv_flow_rt$services where security_group_id  in (:tenant_id,10) and template_id = :id")).build();
    private static final String GET_HANDLER_DATA = "select handler_id, handler_source_type, handler_format, handler_method, handler_mimes_allowed, module_origins_allowed, items_per_page, handler_require_https , handler_source, module_uri_prefix, template_uri_template, template_priority, template_etag_type, template_etag_query, module_id, module_parsing_schema, module_name from wwv_flow_rt$services where security_group_id  in (:tenant_id,10) and template_id = :id and handler_method  = :method";
    private static final Statement GET_HANDLER_DATA_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.query().append((CharSequence)"select handler_id, handler_source_type, handler_format, handler_method, handler_mimes_allowed, module_origins_allowed, items_per_page, handler_require_https , handler_source, module_uri_prefix, template_uri_template, template_priority, template_etag_type, template_etag_query, module_id, module_parsing_schema, module_name from wwv_flow_rt$services where security_group_id  in (:tenant_id,10) and template_id = :id and handler_method  = :method")).parameter("method").build();
    private static final String GET_PARAM_DATA = "select p.name,p.bind_variable_name,p.source_type,p.access_method,p.param_type from wwv_flow_rt$parameters p where p.security_group_id in (:tenant_id,10) and p.handler_id = :id";
    private static final Statement GET_PARAM_DATA_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.query().append((CharSequence)"select p.name,p.bind_variable_name,p.source_type,p.access_method,p.param_type from wwv_flow_rt$parameters p where p.security_group_id in (:tenant_id,10) and p.handler_id = :id")).build();

    JDBCResourceTemplates(QueryProvider query) {
        this.query = query;
    }

    @Override
    public ResourceModule module(CompoundPrincipal principal, ResourceTemplate template) {
        return ((JDBCResourceTemplate)template).module;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResourceHandler resourceHandler(CompoundPrincipal principal, TenantIdentifier templateId, String method) {
        JDBCTransaction txn;
        TenantIdentifier handlerId;
        Iterator rows;
        JDBCResourceHandler.Builder b;
        block10: {
            JDBCCallProvider jdbc = (JDBCCallProvider)ServiceLocator.acquire(JDBCCallProvider.class);
            CompoundPrincipal apexListener = ApexListenerJDBCPrincipal.apexListener(principal);
            b = JDBCResourceHandler.jdbcBuilder();
            rows = null;
            handlerId = null;
            txn = null;
            txn = jdbc.transaction((Principal)apexListener);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, templateId);
            parameters.put("method", method.toUpperCase());
            rows = this.query.query((Transaction)txn, GET_HANDLER_DATA_STMT, parameters, false);
            if (rows.hasNext()) break block10;
            ResourceHandler resourceHandler = this.allowableMethods((Transaction)txn, principal, templateId);
            Closeables.close((Object[])new Object[]{rows, txn});
            return resourceHandler;
        }
        try {
            String[] originsAllowed;
            String[] mimesAllowed;
            ResultRow row = (ResultRow)rows.next();
            ColumnIterator columns = new ColumnIterator(row);
            handlerId = JDBCIdentifiers.valueOf(columns, templateId);
            b.id(handlerId);
            b.contentType(JDBCResourceTemplates.contentType((String)columns.next(String.class), (String)columns.next(String.class)));
            b.method((String)columns.next(String.class));
            for (String mime : mimesAllowed = Text.commaDelimited((String)((String)columns.next(String.class)))) {
                b.acceptable(mime);
            }
            for (String origin : originsAllowed = Text.commaDelimited((String)((String)columns.next(String.class)))) {
                b.originAllowed(origin);
            }
            Integer itemsPerPage = (Integer)columns.next(Integer.class);
            if (itemsPerPage != null) {
                b.itemsPerPage(itemsPerPage);
            }
            SecurityConstraint securityConstraint = SecurityConstraint.fromString((String)columns.next(String.class));
            b.securityConstraint(securityConstraint);
            String content = StreamCopy.string((Readable)((Readable)columns.next(Reader.class)));
            b.content(content);
            JDBCResourceTemplate template = new JDBCResourceTemplate();
            template.id(templateId);
            template.pattern(this.pattern((String)columns.next(String.class), (String)columns.next(String.class)));
            template.priority((Integer)columns.next(Integer.class));
            String etagType = (String)columns.next(String.class);
            String etagQuery = (String)columns.next(String.class);
            if ("HASH".equals(etagType)) {
                etagQuery = "";
            }
            template.etagQuery(etagQuery);
            b.template(template);
            ResourceModule module = new ResourceModule();
            TenantIdentifier moduleId = JDBCIdentifiers.valueOf(columns, handlerId);
            template.parentId(moduleId);
            module.id(moduleId);
            module.parsingSchema((String)columns.next(String.class));
            module.name((String)columns.next(String.class));
            module.published(true);
            b.module(module);
            this.parameters((Transaction)txn, principal, handlerId, b);
        }
        catch (IOException e) {
            try {
                LOG.severe((Throwable)e);
                throw WebException.internalError(e, new Reason[0]);
                catch (SQLException e2) {
                    throw WebException.internalError(e2, new Reason[0]);
                }
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new Object[]{rows, txn});
                throw throwable;
            }
        }
        Closeables.close((Object[])new Object[]{rows, txn});
        return b.build();
    }

    @Override
    public ResourceTemplate resourceTemplate(CompoundPrincipal principal, ResourceHandler handler) {
        return ((JDBCResourceHandler)handler).template;
    }

    @Override
    public ResourceTemplate resourceTemplate(CompoundPrincipal principal, String path) {
        throw new UnsupportedOperationException("not expecting this to be called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceHandler allowableMethods(Transaction txn, CompoundPrincipal principal, TenantIdentifier templateId) {
        Iterator rows = null;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, templateId);
            rows = this.query.query(txn, SUPPORTED_METHODS_STMT, parameters, false);
            if (rows.hasNext()) {
                ArrayList<String> supportedMethods = new ArrayList<String>();
                while (rows.hasNext()) {
                    ResultRow row = (ResultRow)rows.next();
                    String supportedMethod = (String)row.get(1, String.class);
                    supportedMethods.add(supportedMethod);
                }
                throw WebException.methodNotAllowed(supportedMethods);
            }
        }
        catch (Throwable throwable) {
            Closeables.close(rows);
            throw throwable;
        }
        Closeables.close((Object)rows);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parameters(Transaction txn, CompoundPrincipal principal, TenantIdentifier handlerId, JDBCResourceHandler.Builder b) {
        Iterator rows = null;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, handlerId);
            rows = this.query.query(txn, GET_PARAM_DATA_STMT, parameters, false);
            while (rows.hasNext()) {
                ResultRow row = (ResultRow)rows.next();
                ColumnIterator columns = new ColumnIterator(row);
                String originalName = (String)columns.next(String.class);
                String bindName = (String)columns.next(String.class);
                ResourceParameter.Kind kind = ResourceParameter.Kind.HEADER;
                String source = (String)columns.next(String.class);
                if ("URI".equals(source) || "RESPONSE".equals(source)) {
                    kind = ResourceParameter.Kind.URI;
                }
                ParameterAccess access = ParameterAccess.value((String)((String)columns.next(String.class)));
                Class<?> type = this.type((String)columns.next(String.class));
                b.parameter(kind, bindName, originalName, type, access);
            }
        }
        catch (Throwable throwable) {
            Closeables.close(rows);
            throw throwable;
        }
        Closeables.close((Object)rows);
    }

    private String pattern(String uriPrefix, String pattern) {
        if (uriPrefix != null) {
            return uriPrefix.trim() + pattern;
        }
        return pattern;
    }

    private Class<?> type(String paramType) {
        if ("STRING".equals(paramType)) {
            return String.class;
        }
        if ("INT".equals(paramType)) {
            return Integer.class;
        }
        if ("DOUBLE".equals(paramType)) {
            return Double.class;
        }
        if ("BOOLEAN".equals(paramType)) {
            return Boolean.class;
        }
        if ("LONG".equals(paramType)) {
            return Long.class;
        }
        if ("TIMESTAMP".equals(paramType)) {
            return Timestamp.class;
        }
        return String.class;
    }

    static String contentType(String type, String format) {
        String contentType = "oracle.dbtools.rt.web.ResourceGenerator";
        if ("QUERY".equals(type)) {
            contentType = "CSV".equals(format) ? "csv/query" : "json/query";
        } else if ("QUERY_1_ROW".equals(type)) {
            contentType = "json/query;type=single";
        } else if ("PLSQL".equals(type)) {
            contentType = "plsql/block";
        } else if ("FEED".equals(type)) {
            contentType = "json/query;type=feed";
        } else if ("MEDIA".equals(type)) {
            contentType = "resource/lob";
        }
        return contentType;
    }
}

