/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.jdbc;

import java.io.Reader;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.common.jdbc.JDBCCall;
import oracle.dbtools.common.query.ColumnIterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.rt.home.tenants.TenantEntityAccess;
import oracle.dbtools.rt.jdbc.JDBCKey;
import oracle.dbtools.rt.jdbc.entity.JDBCEntityMetaData;
import oracle.dbtools.rt.jdbc.entity.JDBCEntityProviderBase;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifiers;
import oracle.dbtools.rt.resource.templates.v2.ResourceHandler;
import oracle.dbtools.rt.resource.templates.v2.ResourceHandlersProvider;
import oracle.dbtools.rt.resource.templates.v2.ResourceParameter;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

@Service(priority=1)
public class JDBCResourceHandlersProvider
extends JDBCEntityProviderBase<ResourceHandler>
implements ResourceHandlersProvider {
    private static final String CREATE_PARAMETER = "insert into wwv_flow_rt$parameters (handler_id,name,bind_variable_name,source_type,access_method,param_type,security_group_id,created_by,created_on,updated_by,updated_on) values(:id,:name,:bind_variable_name,:source_type,:access_method,:param_type,:tenant_id,:created_by,:created_on,:created_by,:created_on)";
    private static final Statement CREATE_PARAMETER_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.call().append((CharSequence)"insert into wwv_flow_rt$parameters (handler_id,name,bind_variable_name,source_type,access_method,param_type,security_group_id,created_by,created_on,updated_by,updated_on) values(:id,:name,:bind_variable_name,:source_type,:access_method,:param_type,:tenant_id,:created_by,:created_on,:created_by,:created_on)")).parameter("name").parameter("bind_variable_name").parameter("source_type").parameter("access_method").parameter("param_type").parameter("created_by").parameter("created_on", Timestamp.class).build();
    private static final String DELETE_PARAMETERS = "delete from wwv_flow_rt$parameters where security_group_id = :tenant_id and handler_id = :id";
    private static final Statement DELETE_PARAMETERS_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.call().append((CharSequence)"delete from wwv_flow_rt$parameters where security_group_id = :tenant_id and handler_id = :id")).build();
    static final JDBCEntityMetaData<ResourceHandler> META_DATA = JDBCEntityMetaData.builder(ResourceHandler.class, "wwv_flow_rt$handlers", "h", TenantEntityAccess.READ_INTERNAL).column("template_id", JDBCKey.class).parentColumn("template_id").column("source_type").column("format").column("method", String.class, JDBCEntityMetaData.NaturalKeyScope.PARENT).column("mimes_allowed", String.class, "acceptableTypes").column("items_per_page", Integer.class).column("require_https").column("source", Reader.class, "content").build();
    private static final String GET_PARAMETERS = "select p.name, p.bind_variable_name, p.source_type, p.access_method, p.param_type from wwv_flow_rt$parameters p where p.security_group_id in (:tenant_id,10) and p.handler_id = :id order by p.name";
    private static final Statement GET_PARAMETERS_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.query().append((CharSequence)"select p.name, p.bind_variable_name, p.source_type, p.access_method, p.param_type from wwv_flow_rt$parameters p where p.security_group_id in (:tenant_id,10) and p.handler_id = :id order by p.name")).build();

    public JDBCResourceHandlersProvider() {
        super(META_DATA);
    }

    @Override
    protected ResourceHandler inserted(Transaction txn, CompoundPrincipal principal, ResourceHandler instance) {
        try {
            this.insertParameters(txn, principal, instance);
            return super.inserted(txn, principal, instance);
        }
        catch (SQLException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertParameters(Transaction txn, CompoundPrincipal principal, ResourceHandler handler) throws SQLException {
        JDBCCall insertParameter = null;
        try {
            Timestamp created = new Timestamp(handler.metadata().created());
            Timestamp updated = new Timestamp(handler.metadata().updated());
            Object[] parameters = handler.parameters();
            if (!NullOrEmpty.nullOrEmpty((Object[])parameters)) {
                insertParameter = this.jdbc().insert(txn, CREATE_PARAMETER_STMT, new String[0]);
                for (Object parameter : parameters) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    this.creator(params, principal);
                    JDBCIdentifiers.bind(params, principal, handler.id());
                    params.put("bind_variable_name", ((ResourceParameter)parameter).bindName());
                    params.put("name", ((ResourceParameter)parameter).originalName());
                    params.put("access_method", ((ResourceParameter)parameter).access().name());
                    params.put("source_type", this.sourceType(((ResourceParameter)parameter).kind()));
                    params.put("param_type", this.paramType(((ResourceParameter)parameter).primitiveType()));
                    params.put("created_on", created);
                    params.put("updated_on", updated);
                    insertParameter.bind(params);
                    insertParameter.batch();
                }
                insertParameter.execute();
            }
        }
        finally {
            Closeables.close(insertParameter);
        }
    }

    private String paramType(Class<?> primitiveType) {
        if (null == primitiveType || String.class == primitiveType) {
            return "STRING";
        }
        if (Long.class == primitiveType || Long.TYPE == primitiveType) {
            return "LONG";
        }
        if (Integer.class == primitiveType || Integer.TYPE == primitiveType) {
            return "INT";
        }
        if (Double.class == primitiveType || Double.TYPE == primitiveType) {
            return "DOUBLE";
        }
        if (Boolean.class == primitiveType || Boolean.TYPE == primitiveType) {
            return "BOOLEAN";
        }
        if (Timestamp.class == primitiveType) {
            return "TIMESTAMP";
        }
        return null;
    }

    private String sourceType(ResourceParameter.Kind kind) {
        return kind.toString();
    }

    @Override
    protected ResourceHandler retrieved(Transaction txn, CompoundPrincipal principal, ResourceHandler existing) {
        return this.parameters(txn, principal, existing);
    }

    @Override
    protected ResourceHandler updated(Transaction txn, CompoundPrincipal principal, ResourceHandler instance) {
        try {
            this.deleteParameters(txn, principal, instance);
            this.insertParameters(txn, principal, instance);
            return super.updated(txn, principal, instance);
        }
        catch (SQLException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteParameters(Transaction txn, CompoundPrincipal principal, ResourceHandler handler) throws SQLException {
        JDBCCall deleteParameters = null;
        try {
            deleteParameters = this.jdbc().call(txn, DELETE_PARAMETERS_STMT);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, handler.id());
            deleteParameters.bind(parameters);
            deleteParameters.execute();
        }
        catch (Throwable throwable) {
            Closeables.close(deleteParameters);
            throw throwable;
        }
        Closeables.close((Object)deleteParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceHandler parameters(Transaction txn, CompoundPrincipal principal, ResourceHandler existing) {
        Iterator<ResultRow> matches = null;
        try {
            ResourceHandler.ResourceHandlerBuilder b = ResourceHandler.builder(existing);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, existing.id());
            matches = this.query(txn, GET_PARAMETERS_STMT, parameters);
            while (matches.hasNext()) {
                ResultRow row = matches.next();
                ColumnIterator columns = new ColumnIterator(row);
                String originalName = (String)columns.next(String.class);
                String bindName = (String)columns.next(String.class);
                ResourceParameter.Kind kind = ResourceParameter.Kind.value((String)columns.next(String.class));
                ParameterAccess accessMethod = ParameterAccess.value((String)((String)columns.next(String.class)));
                Class<?> primitiveType = JDBCResourceHandlersProvider.type((String)columns.next(String.class));
                b.parameter(kind, bindName, originalName, primitiveType, accessMethod);
            }
            Object t = b.build();
            return t;
        }
        finally {
            Closeables.close(matches);
        }
    }

    private static Class<?> type(String paramType) {
        if ("STRING".equals(paramType)) {
            return String.class;
        }
        if ("INT".equals(paramType)) {
            return Integer.class;
        }
        if ("DOUBLE".equals(paramType)) {
            return Double.class;
        }
        if ("BOOLEAN".equals(paramType)) {
            return Boolean.class;
        }
        if ("LONG".equals(paramType)) {
            return Long.class;
        }
        if ("TIMESTAMP".equals(paramType)) {
            return Timestamp.class;
        }
        return String.class;
    }
}

