/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.jdbc;

import java.security.Principal;
import oracle.dbtools.common.config.db.DatabaseConfig;
import oracle.dbtools.common.ecid.ECIDPrincipal;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCMetricsPrincipal;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.WebException;

public abstract class ApexListenerJDBCPrincipal {
    public static final String APEX_LISTENER_POOL_SUFFIX = "_al";
    private static final String RESOURCE_TEMPLATES_POOL_SUFFIX = "_rt";

    private ApexListenerJDBCPrincipal() {
    }

    public static CompoundPrincipal apexListener(CompoundPrincipal principal) {
        JDBCCallProvider jdbc = (JDBCCallProvider)ServiceLocator.acquire(JDBCCallProvider.class);
        if (principal == null) {
            return null;
        }
        JDBCPrincipal existing = (JDBCPrincipal)principal.principal(JDBCPrincipal.class);
        if (existing == null) {
            existing = jdbc.principal(null);
        } else if (existing.getName().endsWith(APEX_LISTENER_POOL_SUFFIX)) {
            return principal;
        }
        if (existing == null) {
            throw WebException.serviceUnavailable();
        }
        JDBCPrincipal apexListener = jdbc.principal(ApexListenerJDBCPrincipal.apexListenerPoolIdentifier(existing));
        ECIDPrincipal ecidPrincipal = (ECIDPrincipal)principal.principal(ECIDPrincipal.class);
        JDBCMetricsPrincipal metrics = JDBCMetricsPrincipal.metrics((CompoundPrincipal)principal, (String)"APEX Listener", (String)"RESTful Services");
        return CompoundPrincipal.compound((Principal[])new Principal[]{apexListener, ecidPrincipal, metrics});
    }

    public static CompoundPrincipal apexListener(RequestEntity request) {
        return ApexListenerJDBCPrincipal.apexListener(request.principal());
    }

    public static boolean hasApexListener(CompoundPrincipal principal) {
        if (principal == null) {
            return false;
        }
        JDBCPrincipal existing = (JDBCPrincipal)principal.principal(JDBCPrincipal.class);
        if (existing == null) {
            return false;
        }
        String poolIdentifier = ApexListenerJDBCPrincipal.apexListenerPoolIdentifier(existing);
        return DatabaseConfig.pools().isValid(poolIdentifier);
    }

    private static String apexListenerPoolIdentifier(JDBCPrincipal existing) {
        String poolIdentifier = existing.getName();
        if (poolIdentifier.endsWith(RESOURCE_TEMPLATES_POOL_SUFFIX)) {
            poolIdentifier = poolIdentifier.substring(0, poolIdentifier.length() - RESOURCE_TEMPLATES_POOL_SUFFIX.length());
        }
        String poolName = DatabaseConfig.poolName((String)poolIdentifier);
        String serviceName = DatabaseConfig.serviceName((String)poolIdentifier);
        String alPoolName = poolName + APEX_LISTENER_POOL_SUFFIX;
        return DatabaseConfig.poolIdentifier((String)alPoolName, (String)serviceName);
    }
}

