/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.query;

import java.io.IOException;
import java.security.Principal;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.jdbc.JDBCTransaction;
import oracle.dbtools.common.query.Paginated;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.UsesQuery;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.filtering.QueryFiltering;
import oracle.dbtools.rt.paging.Pagination;
import oracle.dbtools.rt.resource.generator.ResourceGenerator;
import oracle.dbtools.rt.resource.generator.ResourceRequest;
import oracle.dbtools.rt.resource.generator.SQLResource;
import oracle.dbtools.rt.web.RequestEntity;

public abstract class QueryGeneratorBase
extends UsesQuery
implements ResourceGenerator {
    private final boolean supportsPagination;
    @Reference
    private JDBCCallProvider jdbc;

    protected QueryGeneratorBase(boolean supportsPagination) {
        this.supportsPagination = supportsPagination;
    }

    @Override
    public Entity generate(ResourceRequest request) throws IOException {
        Entity entity = null;
        JDBCTransaction txn = null;
        Iterator rows = null;
        try {
            request = QueryFiltering.addFilteringClause(request);
            if (this.supportsPagination) {
                request = Pagination.autoPaginate(request);
            }
            SQLResource sqlRequest = SQLResource.query(request);
            Map<String, ?> params = sqlRequest.inboundValues();
            Statement stmt = sqlRequest.statement();
            txn = this.jdbc.transaction((Principal)request.request().principal());
            rows = this.query.query((Transaction)txn, stmt, params, false);
            long pageOffset = this.pageOffset(rows);
            entity = this.toRepresentation(request.request(), pageOffset, rows);
            return Entities.alsoClose(entity, rows, txn);
        }
        catch (SQLException e) {
            Closeables.close((Object[])new Object[]{rows, txn});
            throw JDBCException.wrap((SQLException)e);
        }
        catch (IOException e) {
            Closeables.close((Object[])new Object[]{rows, txn});
            throw e;
        }
    }

    private long pageOffset(Iterator<ResultRow> rows) {
        if (rows instanceof Paginated) {
            return ((Paginated)rows).pageOffset();
        }
        return -1L;
    }

    protected abstract Entity toRepresentation(RequestEntity var1, long var2, Iterator<ResultRow> var4) throws IOException;
}

