/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.jdbc;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import oracle.dbtools.common.jdbc.ConnectionPoolException;
import oracle.dbtools.common.jdbc.JDBCCall;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.home.tenants.TenantEntityAccess;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.home.tenants.TenantIdentifiers;
import oracle.dbtools.rt.jdbc.entity.JDBCEntityMetaData;
import oracle.dbtools.rt.jdbc.entity.JDBCEntityProviderBase;
import oracle.dbtools.rt.jdbc.entity.JDBCEntityStatementBuilder;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifiers;
import oracle.dbtools.rt.oauth.scope.Scope;
import oracle.dbtools.rt.oauth.scope.ScopesProvider;

@Service(priority=1)
public class JDBCScopesProvider
extends JDBCEntityProviderBase<Scope>
implements ScopesProvider {
    private final Statement byScopeName = this.byScopeNameStatement(META_DATA);
    private static final String GET_SCOPE_MODULES = "select m.name from wwv_flow_rt$modules m where m.security_group_id = :tenant_id and m.privilege_id = :id order by m.name";
    private static final Statement GET_SCOPE_MODULES_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.query().append((CharSequence)"select m.name from wwv_flow_rt$modules m where m.security_group_id = :tenant_id and m.privilege_id = :id order by m.name")).build();
    private static final String GET_SCOPE_ROLES = "select wwv_flow_listener.get_workspace_user_group_name(pg.security_group_id, pg.user_group_id) from wwv_flow_rt$privilege_groups pg where security_group_id in (:tenant_id, 10) and privilege_id = :id";
    private static final Statement GET_SCOPE_ROLES_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.query().append((CharSequence)"select wwv_flow_listener.get_workspace_user_group_name(pg.security_group_id, pg.user_group_id) from wwv_flow_rt$privilege_groups pg where security_group_id in (:tenant_id, 10) and privilege_id = :id")).build();
    private static final String INSERT_SCOPE_ROLE = "insert into wwv_flow_rt$privilege_groups (privilege_id,user_group_id,security_group_id,created_by,created_on,updated_by,updated_on) values(:scope_id,wwv_flow_listener.get_workspace_user_group_id(:tenant_id,:group_name),:tenant_id,:created_by,:created_on,:created_by,:created_on)";
    private static final Statement INSERT_SCOPE_ROLE_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.call().append((CharSequence)"insert into wwv_flow_rt$privilege_groups (privilege_id,user_group_id,security_group_id,created_by,created_on,updated_by,updated_on) values(:scope_id,wwv_flow_listener.get_workspace_user_group_id(:tenant_id,:group_name),:tenant_id,:created_by,:created_on,:created_by,:created_on)"), "scope_id", new String[0]).parameter("created_by").parameter("created_on", Timestamp.class).parameter("group_name").build();
    private static final JDBCEntityMetaData<Scope> META_DATA = JDBCEntityMetaData.builder(Scope.class, "wwv_flow_rt$privileges", "s", TenantEntityAccess.READ_INTERNAL).column("name", String.class, JDBCEntityMetaData.NaturalKeyScope.TENANT).column("label", String.class, "title").column("description").build();
    private static final String RESET_MODULE_SCOPE = "update wwv_flow_rt$modules m set m.privilege_id = null where m.security_group_id = :tenant_id and m.privilege_id = :id";
    private static final Statement RESET_MODULE_SCOPE_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.call().append((CharSequence)"update wwv_flow_rt$modules m set m.privilege_id = null where m.security_group_id = :tenant_id and m.privilege_id = :id")).build();
    private static final String RESET_SCOPE_ROLE = "delete from wwv_flow_rt$privilege_groups pg where pg.security_group_id = :tenant_id and pg.privilege_id = :id";
    private static final Statement RESET_SCOPE_ROLE_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.call().append((CharSequence)"delete from wwv_flow_rt$privilege_groups pg where pg.security_group_id = :tenant_id and pg.privilege_id = :id")).build();
    private static final String UPDATE_MODULE_SCOPE = "update wwv_flow_rt$modules m set m.privilege_id = :id where m.security_group_id = :tenant_id and m.name = :name";
    private static final Statement UPDATE_MODULE_SCOPE_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.call().append((CharSequence)"update wwv_flow_rt$modules m set m.privilege_id = :id where m.security_group_id = :tenant_id and m.name = :name")).parameter("name").build();

    public JDBCScopesProvider() {
        super(META_DATA);
    }

    @Override
    public Scope byScopeName(Transaction txn, CompoundPrincipal principal, String name) {
        try {
            return (Scope)this.entity(principal, this.byScopeName, name, "name");
        }
        catch (ConnectionPoolException e) {
            return null;
        }
    }

    @Override
    public Iterable<Scope> scopes(Transaction txn, CompoundPrincipal principal) {
        return TenantIdentifiers.removeInternal(this.entities(txn, principal));
    }

    @Override
    protected void deleted(Transaction txn, CompoundPrincipal principal, TenantIdentifier id) {
        this.resetModuleScopes(txn, principal, id);
    }

    @Override
    protected Scope inserted(Transaction txn, CompoundPrincipal principal, Scope scope) {
        this.updateScopeRoles(txn, principal, scope);
        this.updateModuleScopes(txn, principal, scope);
        return super.inserted(txn, principal, scope);
    }

    @Override
    protected Scope retrieved(Transaction txn, CompoundPrincipal principal, Scope existing) {
        this.scopeRoles(txn, principal, existing);
        this.scopeModules(txn, principal, existing);
        return super.retrieved(txn, principal, existing);
    }

    @Override
    protected Scope updated(Transaction txn, CompoundPrincipal principal, Scope scope) {
        this.resetScopeRoles(txn, principal, scope.id());
        this.updateScopeRoles(txn, principal, scope);
        this.resetModuleScopes(txn, principal, scope.id());
        this.updateModuleScopes(txn, principal, scope);
        return super.updated(txn, principal, scope);
    }

    private Statement byScopeNameStatement(JDBCEntityMetaData<Scope> metadata) {
        JDBCEntityMetaData.Table table = metadata.table();
        return JDBCEntityStatementBuilder.query().selectFrom(table).where(table, JDBCEntityStatementBuilder.eq(JDBCEntityStatementBuilder.column(table, "name"), JDBCEntityStatementBuilder.parameter("name", String.class, ParameterAccess.IN))).build();
    }

    private void resetModuleScopes(Transaction txn, CompoundPrincipal principal, TenantIdentifier id) {
        JDBCCall resetModuleScope = null;
        try {
            resetModuleScope = this.jdbc().call(txn, RESET_MODULE_SCOPE_STMT);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, id);
            resetModuleScope.bind(parameters);
            resetModuleScope.execute();
        }
        catch (SQLException e) {
            try {
                throw JDBCException.wrap((SQLException)e);
            }
            catch (Throwable throwable) {
                Closeables.close(resetModuleScope);
                throw throwable;
            }
        }
        Closeables.close((Object)resetModuleScope);
    }

    private void resetScopeRoles(Transaction txn, CompoundPrincipal principal, TenantIdentifier id) {
        JDBCCall resetModuleScope = null;
        try {
            resetModuleScope = this.jdbc().call(txn, RESET_SCOPE_ROLE_STMT);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, id);
            resetModuleScope.bind(parameters);
            resetModuleScope.execute();
        }
        catch (SQLException e) {
            try {
                throw JDBCException.wrap((SQLException)e);
            }
            catch (Throwable throwable) {
                Closeables.close(resetModuleScope);
                throw throwable;
            }
        }
        Closeables.close((Object)resetModuleScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scopeModules(Transaction txn, CompoundPrincipal principal, Scope existing) {
        Iterator<ResultRow> matches = null;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, existing.id());
            matches = this.query(txn, GET_SCOPE_MODULES_STMT, parameters);
            while (matches.hasNext()) {
                ResultRow row = matches.next();
                existing.module((String)row.get(1, String.class));
            }
        }
        finally {
            Closeables.close(matches);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scopeRoles(Transaction txn, CompoundPrincipal principal, Scope existing) {
        Iterator<ResultRow> matches = null;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, existing.id());
            matches = this.query(txn, GET_SCOPE_ROLES_STMT, parameters);
            while (matches.hasNext()) {
                ResultRow row = matches.next();
                existing.requiredRole((String)row.get(1, String.class));
            }
        }
        finally {
            Closeables.close(matches);
        }
    }

    private void updateModuleScopes(Transaction txn, CompoundPrincipal principal, Scope scope) {
        JDBCCall updateModuleScope = null;
        try {
            Iterable<String> modules = scope.modules();
            if (!NullOrEmpty.nullOrEmpty(modules)) {
                updateModuleScope = this.jdbc().call(txn, UPDATE_MODULE_SCOPE_STMT);
                for (String module : modules) {
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    parameters.put("name", module);
                    JDBCIdentifiers.bind(parameters, principal, scope.id());
                    updateModuleScope.bind(parameters);
                    updateModuleScope.batch();
                }
                updateModuleScope.execute();
            }
        }
        catch (SQLException e) {
            throw JDBCException.wrap((SQLException)e);
        }
        finally {
            Closeables.close(updateModuleScope);
        }
    }

    private void updateScopeRoles(Transaction txn, CompoundPrincipal principal, Scope scope) {
        JDBCCall insertScopeRole = null;
        try {
            LinkedHashSet roles = new LinkedHashSet();
            Iterables.add(roles, scope.requiredRoles());
            if (!NullOrEmpty.nullOrEmpty(roles)) {
                insertScopeRole = this.jdbc().insert(txn, INSERT_SCOPE_ROLE_STMT, new String[0]);
                String creator = Text.upper((String)principal.getName());
                Timestamp now = new Timestamp(System.currentTimeMillis());
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                if (creator != null) {
                    parameters.put("created_by", creator);
                }
                parameters.put("created_on", now);
                JDBCIdentifiers.bind(parameters, principal, scope.id(), "scope_id");
                for (String role : roles) {
                    parameters.put("group_name", role);
                    insertScopeRole.bind(parameters);
                    insertScopeRole.batch();
                }
                insertScopeRole.execute();
            }
        }
        catch (SQLException e) {
            throw JDBCException.wrap((SQLException)e);
        }
        finally {
            Closeables.close(insertScopeRole);
        }
    }
}

