/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

import java.security.Principal;
import java.util.Iterator;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.authorization.AuthorizationPolicy;
import oracle.dbtools.rt.authorization.ScopeAuthorizationPolicy;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.oauth.OAuthScopeProvider;

public abstract class ScopeAuthorizationPolicies {
    private ScopeAuthorizationPolicies() {
    }

    public static TenantIdentifier scope(CompoundPrincipal principal, String path) {
        OAuthScopeProvider scopeProvider;
        TenantIdentifier scopeId = null;
        Iterator i$ = ServiceLocator.acquireAll(OAuthScopeProvider.class, (String[])new String[0]).iterator();
        while (i$.hasNext() && (scopeId = (scopeProvider = (OAuthScopeProvider)i$.next()).scopeForPath(principal, path)) == null) {
        }
        return scopeId;
    }

    public static boolean authorizeScope(CompoundPrincipal principal, TenantIdentifier scopeId) {
        AuthorizationPolicy.Access access = AuthorizationPolicy.Access.PRINCIPAL_UNKNOWN;
        for (ScopeAuthorizationPolicy policy : ServiceLocator.acquireAll(ScopeAuthorizationPolicy.class, (String[])new String[0])) {
            AuthorizationPolicy.Access result = policy.authorize((Principal)principal, scopeId);
            if (AuthorizationPolicy.Access.PRINCIPAL_UNKNOWN == result) continue;
            access = result;
            break;
        }
        return AuthorizationPolicy.Access.NONE != access && AuthorizationPolicy.Access.PRINCIPAL_UNKNOWN != access;
    }
}

