/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.x3p.X3PFactory;
import oracle.dbtools.common.x3p.impl.Event;
import oracle.dbtools.json.JSONParser;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.entity.EntityHeadersBuilder;
import oracle.dbtools.rt.json.xml.JSON2X3PReader;
import oracle.dbtools.rt.json.xml.XMLToJSON;
import oracle.dbtools.rt.transcode.Transcoder;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

@Service
public class JSONToXML
implements Transcoder {
    public Entity apply(Entity entity) {
        try {
            InputStream body = entity.body();
            EntityHeaders headers = entity.headers();
            EntityHeader mediaType = headers.header(HttpHeader.CONTENT_TYPE);
            if (mediaType != null && ContentType.contentType(mediaType.value()).matches(ContentTypes.JSON_TYPES)) {
                Iterator json = JSONParser.read((InputStream)entity.body());
                Iterator<Event> x3p = JSON2X3PReader.transform(json);
                body = X3PFactory.newStream(x3p);
            }
            return Entities.entity(body, this.transform(headers).build());
        }
        catch (IOException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    @Override
    public boolean canTransform(ContentType from, ContentType ... to) {
        return from.matches(ContentTypes.JSON_TYPES) && ContentType.matches(ContentTypes.XML_TYPES, to);
    }

    private EntityHeadersBuilder transform(EntityHeaders headers) {
        EntityHeader mediaType = headers.header(HttpHeader.CONTENT_TYPE);
        EntityHeadersBuilder updatedHeaders = Entities.headers();
        EntityHeader location = headers.header("X-APEX-PATH");
        updatedHeaders.header((CharSequence)"X-APEX-PATH", XMLToJSON.match(location.value()));
        if (mediaType != null) {
            ContentType contentType = ContentType.contentType(mediaType.value());
            if (contentType.matches(ContentTypes.JSON)) {
                updatedHeaders.header((CharSequence)HttpHeader.CONTENT_TYPE, new CharSequence[]{ContentTypes.XML});
            } else {
                updatedHeaders.header((CharSequence)HttpHeader.CONTENT_TYPE, new CharSequence[]{contentType.changeSuffix("xml")});
            }
        }
        return updatedHeaders;
    }
}

