/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json.query;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.json.JSONObject;
import oracle.dbtools.json.JSONOptions;
import oracle.dbtools.json.JSONProperty;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.filtering.Filtering;
import oracle.dbtools.rt.json.query.HyperLinks;
import oracle.dbtools.rt.json.query.JSONQueryStream;
import oracle.dbtools.rt.paging.Pagination;
import oracle.dbtools.rt.query.ResultRowRepresentation;
import oracle.dbtools.rt.web.AcceptFormatting;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebException;

public class JSONRepresentation
implements ResultRowRepresentation {
    private final boolean firstRowOnly;
    private final ContentType contentType;

    public JSONRepresentation(boolean firstRowOnly) {
        this(firstRowOnly, ContentTypes.JSON);
    }

    public JSONRepresentation(boolean firstRowOnly, ContentType contentType) {
        this.firstRowOnly = firstRowOnly;
        this.contentType = contentType;
    }

    @Override
    public Entity toRepresentation(RequestEntity request, long pageOffset, Iterator<ResultRow> rows) throws IOException {
        ResultRow pagination;
        AcceptFormatting contentFormatting = AcceptFormatting.contentFormatting(request);
        JSONOptions options = JSONOptions.configure(contentFormatting.parameters());
        if (this.firstRowOnly && !rows.hasNext()) {
            throw WebException.notFound();
        }
        Iterable<JSONProperty> pageLinks = null;
        if (!this.firstRowOnly && pageOffset != -1L && (pagination = Pagination.hyperlinks(request.path(), pageOffset, rows)) != null) {
            ResultRow withFiltering = Filtering.hyperlinks(request, pagination);
            pageLinks = this.pageLinks(options, HyperLinks.hyperlink(request.base(), Iterators.iterator((Object[])new ResultRow[]{withFiltering})).next());
        }
        Iterator<ResultRow> hyperlinked = HyperLinks.hyperlink(Requests.documentBase(request), rows);
        return Entities.entity((InputStream)((Object)new JSONQueryStream(hyperlinked, options, this.firstRowOnly, pageLinks)), Entities.headers(new CharSequence[]{HttpHeader.CONTENT_TYPE, this.contentType}));
    }

    private Iterable<JSONProperty> pageLinks(JSONOptions options, ResultRow hyperlinks) {
        return (JSONObject)JSONQueryStream.toJson(options, hyperlinks).build();
    }
}

