/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.home.tenants;

import java.security.Principal;
import oracle.dbtools.rt.authorization.AuthorizationPolicy;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantEntityAccess;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.tenants.TenantPrincipal;

public class TenantEntityAuthorizationPolicy<T extends TenantEntity>
implements AuthorizationPolicy<T> {
    private final TenantEntityAccess entityAccess;

    public TenantEntityAuthorizationPolicy(TenantEntityAccess entityAccess) {
        this.entityAccess = entityAccess;
    }

    @Override
    public AuthorizationPolicy.Access authorize(Principal principal, TenantEntity target) {
        if (principal == null) {
            return AuthorizationPolicy.Access.NONE;
        }
        String user = principal.getName();
        if (user == null) {
            return AuthorizationPolicy.Access.NONE;
        }
        boolean sameTenant = this.sameTenant(principal, target);
        boolean isInternal = ((TenantIdentifier)target.id()).isInternal();
        String creator = target.metadata().createdBy();
        if (sameTenant) {
            if (TenantEntityAccess.CREATOR == this.entityAccess) {
                if (this.isCreator(creator, user)) {
                    return AuthorizationPolicy.Access.READ_WRITE;
                }
                return AuthorizationPolicy.Access.NONE;
            }
            return AuthorizationPolicy.Access.READ_WRITE;
        }
        if (isInternal) {
            if (TenantEntityAccess.READ_INTERNAL == this.entityAccess) {
                return AuthorizationPolicy.Access.READ;
            }
            return AuthorizationPolicy.Access.NONE;
        }
        return AuthorizationPolicy.Access.NONE;
    }

    private boolean sameTenant(Principal principal, TenantEntity target) {
        return TenantPrincipal.id(TenantPrincipal.tenant(principal)).equals(((TenantIdentifier)target.id()).tenantId());
    }

    protected boolean isCreator(String creator, String user) {
        if (creator == null) {
            return false;
        }
        return user.toUpperCase().equals(creator.toUpperCase());
    }
}

