/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config.setup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Template;
import oracle.dbtools.common.util.URLEncoding;
import oracle.dbtools.common.zip.ZipBuilder;
import oracle.dbtools.plugin.api.cmdline.CommandProvider;
import oracle.dbtools.plugin.api.cmdline.annotations.Argument;
import oracle.dbtools.plugin.api.cmdline.annotations.Command;
import oracle.dbtools.plugin.api.cmdline.annotations.Option;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.i18n.annotations.TranslatableText;
import oracle.dbtools.rt.config.setup.SetupMessages;

@Provides
@Command(name="static", description=@TranslatableText(type=SetupMessages.class, id="STATIC_DESCRIPTION"), options={@Option(name="context", description=@TranslatableText(type=SetupMessages.class, id="STATIC_CONTEXT_PATH"))}, arguments={@Argument(name="location", description=@TranslatableText(type=SetupMessages.class, id="STATIC_LOCATION"))})
public class StaticResources
implements CommandProvider {
    private static final String[] RESOURCE_PATHS = new String[]{"WEB-INF/web.xml", "WEB-INF/weblogic.xml", "WEB-INF/sun-web.xml"};
    private static final String DEFAULT_CONTEXT_PATH = "/i";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Map<String, Object> values) throws Exception {
        String contextPath = (String)values.get("context-path");
        if (NullOrEmpty.nullOrEmpty((CharSequence)contextPath)) {
            contextPath = DEFAULT_CONTEXT_PATH;
        }
        contextPath = this.normalizeContextPath(contextPath);
        String location = (String)values.get("location");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("location", location);
        params.put("context-path", contextPath);
        ZipBuilder zip = ZipBuilder.builder();
        for (String path : RESOURCE_PATHS) {
            String encoded = this.parse(path, params);
            zip.addEntry(path, StreamCopy.toInputStream((CharSequence)encoded));
        }
        InputStream zipped = null;
        OutputStream out = null;
        try {
            zipped = zip.build();
            File war = Files.file((String)this.warName(contextPath));
            out = Files.outputStream((File)war);
            StreamCopy.drain((InputStream)zipped, (OutputStream)out);
            System.console().printf(SetupMessages.format("STATIC_COMPLETE", war.getCanonicalPath(), contextPath, location), new Object[0]);
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new Object[]{zipped, out});
            throw throwable;
        }
        Closeables.close((Object[])new Object[]{zipped, out});
    }

    private String warName(String contextPath) {
        if (contextPath.isEmpty()) {
            contextPath = DEFAULT_CONTEXT_PATH;
        }
        contextPath = contextPath.substring(1);
        return URLEncoding.encode((String)contextPath) + ".war";
    }

    private String normalizeContextPath(String basePath) {
        while (basePath.endsWith("/")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        if (basePath.isEmpty()) {
            return basePath;
        }
        if (!basePath.startsWith("/")) {
            basePath = "/" + basePath;
        }
        return basePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parse(String path, Map<String, String> params) throws IOException {
        InputStream in = null;
        try {
            in = StaticResources.class.getResourceAsStream(path);
            String template = StreamCopy.string((InputStream)in);
            Template t = new Template(template);
            String string = t.encode(params);
            return string;
        }
        finally {
            Closeables.close((Object)in);
        }
    }
}

