/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config.setup;

import java.io.Console;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.dbtools.common.di.Factory;
import oracle.dbtools.common.install.UpgradeVersions;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.Maps;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.plugin.api.cmdline.CommandProvider;
import oracle.dbtools.rt.config.setup.Setting;
import oracle.dbtools.rt.config.setup.SetupMessages;
import oracle.jdbc.OracleCallableStatement;

class SchemaSetup {
    private static final Log LOG = Log.get(SchemaSetup.class);
    private static final String GET_VERSION_SQL = "declare\ncurr_version varchar2(25);\nbegin\n  select version into :curr_version from ords_metadata.ords_version;end;\n";
    private static final Statement GET_VERSION_STMT = StatementBuilder.call().append((CharSequence)"declare\ncurr_version varchar2(25);\nbegin\n  select version into :curr_version from ords_metadata.ords_version;end;\n").parameter("curr_version", String.class, ParameterAccess.OUT).build();
    private static final String GET_REGISTRY_SQL = "declare\nregistered varchar2(5) := 'false';\nreg_version varchar2(30);\nreg_status  varchar2(30);\nbegin\n  if sys.dbms_registry.is_in_registry('ORDS') then\n    :registered := 'true';\n  end if;\n  :reg_version := sys.dbms_registry.version('ORDS');\n  :reg_status  := sys.dbms_registry.status('ORDS');\nend;\n";
    private static final Statement GET_REGISTRY_STMT = StatementBuilder.call().append((CharSequence)"declare\nregistered varchar2(5) := 'false';\nreg_version varchar2(30);\nreg_status  varchar2(30);\nbegin\n  if sys.dbms_registry.is_in_registry('ORDS') then\n    :registered := 'true';\n  end if;\n  :reg_version := sys.dbms_registry.version('ORDS');\n  :reg_status  := sys.dbms_registry.status('ORDS');\nend;\n").parameter("registered", String.class, ParameterAccess.OUT).parameter("reg_version", String.class, ParameterAccess.OUT).parameter("reg_status", String.class, ParameterAccess.OUT).build();
    private static final String GET_SYSDBA_PRIV_SQL = "declare\nsysdba_priv varchar2(25);\nbegin\n  select privilege into :sysdba_priv from sys.session_privs where privilege = 'SYSDBA';end;\n";
    private static final Statement GET_SYSDBA_PRIV_STMT = StatementBuilder.call().append((CharSequence)"declare\nsysdba_priv varchar2(25);\nbegin\n  select privilege into :sysdba_priv from sys.session_privs where privilege = 'SYSDBA';end;\n").parameter("sysdba_priv", String.class, ParameterAccess.OUT).build();
    private static final String AS_SYSDBA = " AS SYSDBA";
    private static final String SYS = "SYS";
    private static final String SYSAUX = "SYSAUX";
    private static final String USERS = "USERS";
    private static final String TEMP = "TEMP";
    private static final Setting TABLESPACE = Setting.setting("DB_TABLESPACE", null, "USERS");
    private static final Setting SYS_USER = Setting.setting("DB_SYS_USER", null, "SYS");
    private static final Setting PASSWORD = Setting.setting("DB_PWD", null, null, true, new String[0]);
    private static final int RELEASE_END_NDX = 5;
    private static final int MAX_INVALID_PW_ALLOWED = 2;
    private static final int MAX_INVALID_USR_ALLOWED = 4;
    private final Map<String, String> installParams;
    private final boolean isSimpleInstall;

    static void schemaParams(Console console, File war, Map<String, String> installParams) throws Exception {
        new SchemaSetup(installParams).addSchemaParams(console, war);
    }

    static void install(Map<String, String> installParams, Class<?> provider, Factory factory) throws Exception {
        if (NullOrEmpty.nullOrEmpty(installParams)) {
            return;
        }
        String installer = installParams.get("installer");
        if (!NullOrEmpty.nullOrEmpty((CharSequence)installer)) {
            if (installer.equals("install") || installer.equals("upgrade")) {
                Class<?> type = provider;
                CommandProvider installProvider = (CommandProvider)factory.newInstance(type);
                Map requiredValues = (Map)Maps.builder().add((Object)"install.params", installParams).build();
                installProvider.execute(requiredValues);
            } else if (installer.equals("skip")) {
                LOG.warning(SetupMessages.getString("CANNOT_CONNECT_DB"));
            } else {
                LOG.info(SetupMessages.format("SCHEMA_VERSION", installParams.get("product.name"), installParams.get("schema.version")));
            }
        }
    }

    private SchemaSetup(Map<String, String> installParams) {
        this.installParams = installParams;
        String installType = installParams.get("install.type");
        this.isSimpleInstall = NullOrEmpty.nullOrEmpty((CharSequence)installType) || installType.equals("install.simple");
    }

    private void addSchemaParams(Console console, File war) throws Exception {
        String schemaVersion = this.getSchemaVersion(console, war);
        String installer = this.installParams.get("installer");
        if (!NullOrEmpty.nullOrEmpty((CharSequence)installer) && installer.equals("skip")) {
            return;
        }
        this.installParams.put("schema.version", schemaVersion);
        if (NullOrEmpty.nullOrEmpty((CharSequence)schemaVersion)) {
            String schemaNotExist = "\n" + SetupMessages.getString("DB_SCHEMA_NOT_EXIST") + "\n\n";
            LOG.info(schemaNotExist);
            this.retrieveSettingValue(console, "schema.tablespace.default", TABLESPACE, SYSAUX, false, SetupMessages.getString("DEFAULT_TBS"), "ORDS_METADATA");
            this.retrieveSettingValue(console, "schema.tablespace.temp", TABLESPACE, TEMP, false, SetupMessages.getString("TEMPORARY_TBS"), "ORDS_METADATA");
            this.retrieveSettingValue(console, "user.tablespace.default", TABLESPACE, USERS, false, SetupMessages.getString("DEFAULT_TBS"), "ORDS_PUBLIC_USER");
            this.retrieveSettingValue(console, "user.tablespace.temp", TABLESPACE, TEMP, false, SetupMessages.getString("TEMPORARY_TBS"), "ORDS_PUBLIC_USER");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSchemaVersion(Console console, File war) throws Exception {
        String schemaVer = null;
        boolean failedConn = false;
        boolean connectedAsSys = false;
        Connection conn = null;
        String username = this.installParams.get("user.name.public");
        String password = this.installParams.get("user.public.password");
        String url = SchemaSetup.getDbUrl(this.installParams);
        try {
            String errConnMsg = null;
            try {
                String connPassword = SchemaSetup.getPassword(password);
                conn = DriverManager.getConnection(url, username, connPassword);
            }
            catch (SQLException e) {
                errConnMsg = e.getMessage();
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
                if (e.getErrorCode() == 1017) {
                    failedConn = true;
                }
                String msg = SetupMessages.format("ERR_CONN_FAILED", username, url, errConnMsg);
                LOG.warning(msg);
                this.installParams.put("installer", "skip");
                String string = null;
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
                return string;
            }
            if (failedConn) {
                conn = SchemaSetup.verifyDBAUserConnection(console, this.installParams, url, true);
                if (conn == null || this.installParams.get("installer") != null && this.installParams.get("installer").equals("skip")) {
                    String e = null;
                    return e;
                }
                connectedAsSys = true;
            }
            schemaVer = this.getORDSVersion(conn);
            String productVer = this.installParams.get("product.version");
            if (connectedAsSys) {
                if (NullOrEmpty.nullOrEmpty((CharSequence)schemaVer)) {
                    this.installParams.put("installer", "install");
                    this.installParams.put("db.url", url);
                } else {
                    String msg = SetupMessages.format("ERR_INVALID_PASSWORD", schemaVer, errConnMsg != null ? errConnMsg : "");
                    LOG.warning(msg);
                    if (UpgradeVersions.isUpgradeRequired((File)war, (String)schemaVer)) {
                        this.installParams.put("installer", "upgrade");
                        this.installParams.put("db.url", url);
                    } else {
                        this.installParams.put("installer", "none");
                    }
                }
            } else {
                if (NullOrEmpty.nullOrEmpty((CharSequence)schemaVer)) {
                    throw new Exception(SetupMessages.getString("ERR_MD_EXISTS_VERSION_MISSING"));
                }
                if (UpgradeVersions.isUpgradeRequired((File)war, (String)schemaVer)) {
                    SchemaSetup.verifyDBAUserConnection(console, this.installParams, url, false);
                    if (this.installParams.get("installer") != null && this.installParams.get("installer").equals("skip")) {
                    } else {
                        this.installParams.put("installer", "upgrade");
                        this.installParams.put("db.url", url);
                    }
                } else {
                    this.installParams.put("installer", "none");
                }
            }
        }
        finally {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        return schemaVer;
    }

    public String getORDSVersion(Connection conn) throws Exception {
        return this.getORDSVersionFromView(conn);
    }

    private String getORDSVersionFromView(Connection conn) throws Exception {
        String string;
        OracleCallableStatement callStmt;
        block6: {
            callStmt = null;
            String sql = StatementBuilder.encode((Statement)GET_VERSION_STMT);
            callStmt = (OracleCallableStatement)conn.prepareCall(sql);
            callStmt.registerOutParameter(1, 12);
            callStmt.execute();
            String version = callStmt.getString(1);
            if (NullOrEmpty.nullOrEmpty((CharSequence)version)) break block6;
            String string2 = version;
            Closeables.close((Object)callStmt);
            return string2;
        }
        try {
            string = "";
        }
        catch (SQLException e) {
            block7: {
                String string3;
                try {
                    if (e.getErrorCode() != 6550) break block7;
                    string3 = "";
                }
                catch (Throwable throwable) {
                    Closeables.close(callStmt);
                    throw throwable;
                }
                Closeables.close((Object)callStmt);
                return string3;
            }
            LOG.warning(e.getMessage());
            throw e;
        }
        Closeables.close((Object)callStmt);
        return string;
    }

    private String getORDSVersionFromRegistry(Connection conn) throws Exception {
        String registryStatus;
        String registryVersion;
        OracleCallableStatement callStmt;
        block7: {
            block6: {
                callStmt = null;
                String sql = StatementBuilder.encode((Statement)GET_REGISTRY_STMT);
                callStmt = (OracleCallableStatement)conn.prepareCall(sql);
                callStmt.registerOutParameter(1, 12);
                callStmt.registerOutParameter(2, 12);
                callStmt.registerOutParameter(3, 12);
                callStmt.execute();
                boolean isRegistered = Boolean.parseBoolean(callStmt.getString(1));
                registryVersion = callStmt.getString(2);
                registryStatus = callStmt.getString(3);
                if (isRegistered) break block6;
                String string = "";
                Closeables.close((Object)callStmt);
                return string;
            }
            if (NullOrEmpty.nullOrEmpty((CharSequence)registryStatus) || !registryStatus.equalsIgnoreCase("VALID") || !this.validateVersion(registryVersion)) break block7;
            String string = registryVersion;
            Closeables.close((Object)callStmt);
            return string;
        }
        try {
            try {
                String msg = SetupMessages.format("ERR_REGISTRY_VERSION_STATUS", registryVersion, registryStatus);
                throw new Exception(msg);
            }
            catch (SQLException e) {
                LOG.warning(e.getMessage());
                throw e;
            }
        }
        catch (Throwable throwable) {
            Closeables.close(callStmt);
            throw throwable;
        }
    }

    private static String getPassword(String value) {
        if (value != null && value.startsWith("@")) {
            value = value.substring(1);
            value = Passwords.comingIn((String)value);
        }
        return value;
    }

    private static String getUsername(String username) {
        if (username.toUpperCase().equals(SYS) && !username.toUpperCase().endsWith(AS_SYSDBA)) {
            return username + AS_SYSDBA;
        }
        return username;
    }

    private boolean validateVersion(String version) {
        if (!NullOrEmpty.nullOrEmpty((CharSequence)version)) {
            String pattern = "\\d{1,2}\\.\\d{1,2}\\.\\d{1,2}\\.[\\d]+\\.[\\d]+\\.[\\d]+";
            boolean matches = Pattern.matches(pattern, version);
            return matches;
        }
        return false;
    }

    private String retrieveSettingValue(Console console, String key, Setting setting, String defaultValue, boolean isPassword, String ... msgArgs) throws Exception {
        String val = this.installParams.get(key);
        if (console != null) {
            if (!this.isSimpleInstall || NullOrEmpty.nullOrEmpty((CharSequence)val)) {
                if (!isPassword) {
                    String defVal = !NullOrEmpty.nullOrEmpty((CharSequence)val) ? val : defaultValue;
                    setting.setDefaultValue(defVal);
                }
                val = setting.prompt(console, msgArgs);
                this.installParams.put(key, val);
            }
        } else if (this.isSimpleInstall) {
            if (NullOrEmpty.nullOrEmpty((CharSequence)val)) {
                throw new Exception(SetupMessages.format("ERR_MISSING_VALUE_SIMPLE", key));
            }
        } else {
            throw new Exception(SetupMessages.getString("ERR_NO_CONSOLE_ADVANCED"));
        }
        return val;
    }

    public static String getDbUrl(Map<String, String> installParams) {
        String hostName = installParams.get("db.hostname");
        String port = installParams.get("db.port");
        String sid = installParams.get("db.sid");
        String serviceName = installParams.get("db.servicename");
        String driverType = "thin";
        String url = !NullOrEmpty.nullOrEmpty((CharSequence)serviceName) ? "jdbc:oracle:thin:@//" + hostName + ":" + port + "/" + serviceName : "jdbc:oracle:thin:@" + hostName + ":" + port + ":" + sid;
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasSysDBAPrivilege(Connection conn) throws SQLException {
        OracleCallableStatement callStmt;
        block3: {
            boolean bl;
            callStmt = null;
            try {
                String sql = StatementBuilder.encode((Statement)GET_SYSDBA_PRIV_STMT);
                callStmt = (OracleCallableStatement)conn.prepareCall(sql);
                callStmt.registerOutParameter(1, 12);
                callStmt.execute();
                String sysDbaPriv = callStmt.getString(1);
                if (NullOrEmpty.nullOrEmpty((CharSequence)sysDbaPriv) || !sysDbaPriv.equals("SYSDBA")) break block3;
                bl = true;
            }
            catch (Throwable throwable) {
                Closeables.close(callStmt);
                throw throwable;
            }
            Closeables.close((Object)callStmt);
            return bl;
        }
        boolean bl = false;
        Closeables.close((Object)callStmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection verifyDBAUserConnection(Console console, Map<String, String> installParams, String url, boolean stayConnected) {
        String installType = installParams.get("install.type");
        boolean isSimpleInstall = true;
        if (!NullOrEmpty.nullOrEmpty((CharSequence)installType) && !installType.equals("install.simple")) {
            isSimpleInstall = false;
        }
        Connection conn = null;
        try {
            String username = installParams.get("sys.user");
            String password = installParams.get("sys.password");
            if (console != null) {
                if (NullOrEmpty.nullOrEmpty((CharSequence)username) || NullOrEmpty.nullOrEmpty((CharSequence)password)) {
                    LOG.console("\n" + SetupMessages.getString("INFO_SYS_LOGIN") + "\n\n");
                    username = SYS_USER.prompt(console, new String[0]);
                    password = PASSWORD.prompt(console, username);
                }
            } else if (isSimpleInstall) {
                StringBuilder sb = null;
                if (NullOrEmpty.nullOrEmpty((CharSequence)username) && sb == null) {
                    sb = new StringBuilder("sys.user");
                }
                if (NullOrEmpty.nullOrEmpty((CharSequence)password)) {
                    if (sb == null) {
                        sb = new StringBuilder("sys.password");
                    } else {
                        sb.append(", ").append("sys.password");
                    }
                }
                if (sb != null) {
                    throw new Exception(SetupMessages.format("ERR_MISSING_VALUE_SIMPLE", sb.toString()));
                }
            } else {
                throw new Exception(SetupMessages.getString("ERR_NO_CONSOLE_ADVANCED"));
            }
            int totalInvalidPwd = 0;
            int totalInvalidUsr = 0;
            boolean connectedAsSys = false;
            while (!connectedAsSys && totalInvalidPwd <= 2 && totalInvalidUsr <= 4) {
                String connUsername = null;
                String errMsg = null;
                boolean validPriv = false;
                try {
                    connUsername = SchemaSetup.getUsername(username);
                    String connPassword = SchemaSetup.getPassword(password);
                    conn = DriverManager.getConnection(url, connUsername, connPassword);
                    validPriv = SchemaSetup.hasSysDBAPrivilege(conn);
                    if (validPriv) {
                        connectedAsSys = true;
                        installParams.put("sys.user", connUsername);
                        if (!password.startsWith("@")) {
                            password = "@" + Passwords.goingOut((String)password);
                        }
                        installParams.put("sys.password", password);
                        continue;
                    }
                    if (totalInvalidPwd > 0) {
                        totalInvalidPwd = 0;
                    }
                    ++totalInvalidUsr;
                    if (errMsg == null) {
                        errMsg = SetupMessages.getString("ERR_INVALID_SYSDBA_USER") + "\n";
                    }
                    console.printf("%s ", errMsg);
                    username = SYS_USER.prompt(console, new String[0]);
                    password = PASSWORD.prompt(console, username);
                }
                catch (SQLException e) {
                    boolean tryAgain = false;
                    if (console != null) {
                        if (e.getErrorCode() == 1017 && totalInvalidPwd + 1 <= 2) {
                            errMsg = e.getMessage() + SetupMessages.getString("TRY_AGAIN");
                            console.printf("%s ", errMsg);
                            ++totalInvalidPwd;
                            tryAgain = true;
                            password = PASSWORD.prompt(console, username);
                        } else if (e.getErrorCode() == 1031 || e.getErrorCode() == 1403 && totalInvalidUsr + 1 <= 4) {
                            tryAgain = true;
                            errMsg = e.getMessage() + SetupMessages.getString("ERR_INVALID_SYSDBA_USER") + "\n";
                            console.printf("%s ", errMsg);
                            username = SYS_USER.prompt(console, new String[0]);
                            password = PASSWORD.prompt(console, username);
                            ++totalInvalidUsr;
                        }
                    }
                    if (tryAgain) continue;
                    errMsg = SetupMessages.format("ERR_CONN_FAILED", connUsername, url, e.getMessage());
                    LOG.warning(errMsg);
                    try {
                        if (conn != null && !conn.isClosed()) {
                            conn.close();
                            conn = null;
                        }
                    }
                    catch (Exception ex) {
                        LOG.warning(ex.getMessage());
                    }
                    installParams.put("installer", "skip");
                    Connection connection = null;
                    if (!stayConnected) {
                        try {
                            if (conn != null && !conn.isClosed()) {
                                conn.close();
                                conn = null;
                            }
                        }
                        catch (Exception e2) {
                            LOG.warning(e2.getMessage());
                        }
                    }
                    return connection;
                }
            }
            if (!connectedAsSys && NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("installer"))) {
                installParams.put("installer", "skip");
                if (totalInvalidPwd > 2) {
                    LOG.info(SetupMessages.getString("MAX_RETRY_PASSWD_ALLOWED"));
                } else if (totalInvalidUsr > 4) {
                    LOG.info(SetupMessages.getString("MAX_RETRY_USER_ALLOWED"));
                }
            }
        }
        catch (Exception e) {
            installParams.put("installer", "skip");
            try {
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                LOG.warning(e1.getMessage());
            }
            LOG.warning(e.getMessage());
            installParams.put("installer", "skip");
            LOG.warning(e.getMessage());
        }
        finally {
            if (!stayConnected) {
                try {
                    if (conn != null && !conn.isClosed()) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e2) {
                    LOG.warning(e2.getMessage());
                }
            }
        }
        return conn;
    }

    public static boolean getSysDbaUserCredentials(Console console, Map<String, String> installParams, String dbURL) {
        SchemaSetup.verifyDBAUserConnection(console, installParams, dbURL, false);
        return installParams.get("installer") == null || !installParams.get("installer").equals("skip");
    }
}

