/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication.jaas;

import java.io.File;
import java.util.BitSet;

class ParseUtil {
    static BitSet encodedInPath = new BitSet(256);

    ParseUtil() {
    }

    public static String encodePath(String path) {
        return ParseUtil.encodePath(path, true);
    }

    public static String encodePath(String path, boolean flag) {
        char[] retCC = new char[path.length() * 2 + 16];
        int retLen = 0;
        char[] pathCC = path.toCharArray();
        int n = path.length();
        for (int i = 0; i < n; ++i) {
            char c = pathCC[i];
            if (!flag && c == '/' || flag && c == File.separatorChar) {
                retCC[retLen++] = 47;
            } else if (c <= '\u007f') {
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                    retCC[retLen++] = c;
                } else if (encodedInPath.get(c)) {
                    retLen = ParseUtil.escape(retCC, c, retLen);
                } else {
                    retCC[retLen++] = c;
                }
            } else if (c > '\u07ff') {
                retLen = ParseUtil.escape(retCC, (char)(0xE0 | c >> 12 & 0xF), retLen);
                retLen = ParseUtil.escape(retCC, (char)(0x80 | c >> 6 & 0x3F), retLen);
                retLen = ParseUtil.escape(retCC, (char)(0x80 | c >> 0 & 0x3F), retLen);
            } else {
                retLen = ParseUtil.escape(retCC, (char)(0xC0 | c >> 6 & 0x1F), retLen);
                retLen = ParseUtil.escape(retCC, (char)(0x80 | c >> 0 & 0x3F), retLen);
            }
            if (retLen + 9 <= retCC.length) continue;
            int newLen = retCC.length * 2 + 16;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            char[] buf = new char[newLen];
            System.arraycopy(retCC, 0, buf, 0, retLen);
            retCC = buf;
        }
        return new String(retCC, 0, retLen);
    }

    private static int escape(char[] cc, char c, int index) {
        cc[index++] = 37;
        cc[index++] = Character.forDigit(c >> 4 & 0xF, 16);
        cc[index++] = Character.forDigit(c & 0xF, 16);
        return index;
    }

    static {
        encodedInPath.set(61);
        encodedInPath.set(59);
        encodedInPath.set(63);
        encodedInPath.set(47);
        encodedInPath.set(35);
        encodedInPath.set(32);
        encodedInPath.set(60);
        encodedInPath.set(62);
        encodedInPath.set(37);
        encodedInPath.set(34);
        encodedInPath.set(123);
        encodedInPath.set(125);
        encodedInPath.set(124);
        encodedInPath.set(92);
        encodedInPath.set(94);
        encodedInPath.set(91);
        encodedInPath.set(93);
        encodedInPath.set(96);
        for (int i = 0; i < 32; ++i) {
            encodedInPath.set(i);
        }
        encodedInPath.set(127);
    }
}

